/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.potion;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class SwarmingEffect
extends MobEffect {
    public SwarmingEffect() {
        super(MobEffectCategory.BENEFICIAL, 0xFF0000);
    }

    public boolean applyEffectTick(LivingEntity entity, int amplifier) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            for (int i = 0; i < 8; ++i) {
                double angle = ((double)entity.tickCount * 0.2 + (double)i * Math.PI / 4.0) % (Math.PI * 2);
                double radius = 1.5 + Math.sin((double)entity.tickCount * 0.1) * 0.3;
                double x = entity.getX() + Math.cos(angle) * radius;
                double y = entity.getY() + 0.5 + Math.sin((double)entity.tickCount * 0.15) * 0.5;
                double z = entity.getZ() + Math.sin(angle) * radius;
                serverLevel.sendParticles((ParticleOptions)ParticleTypes.ENCHANT, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        return true;
    }

    public boolean shouldApplyEffectTickThisTick(int duration, int amplifier) {
        return duration % 5 == 0;
    }
}

