/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.perk;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.config.ArsAffinityConfig;
import com.github.ars_affinity.perk.AffinityPerkType;
import com.github.ars_affinity.perk.PerkCategory;
import com.github.ars_affinity.perk.PerkNode;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.neoforged.fml.loading.FMLPaths;

public class PerkTreeManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Map<SpellSchool, Map<String, PerkNode>> perkTrees = new HashMap<SpellSchool, Map<String, PerkNode>>();
    private static final Map<String, PerkNode> allNodes = new HashMap<String, PerkNode>();
    private static boolean isLoaded = false;
    private static final SpellSchool[] SUPPORTED_SCHOOLS = new SpellSchool[]{SpellSchools.ELEMENTAL_FIRE, SpellSchools.ELEMENTAL_WATER, SpellSchools.ELEMENTAL_EARTH, SpellSchools.ELEMENTAL_AIR, SpellSchools.ABJURATION, SpellSchools.NECROMANCY, SpellSchools.CONJURATION, SpellSchools.MANIPULATION};

    public static void loadPerkTrees() {
        perkTrees.clear();
        allNodes.clear();
        Path configDir = FMLPaths.CONFIGDIR.get().resolve("ars_affinity").resolve("perk_trees");
        ArsAffinity.LOGGER.info("Loading perk trees from: {}", (Object)configDir.toAbsolutePath());
        try {
            if (!Files.exists(configDir, new LinkOption[0])) {
                Files.createDirectories(configDir, new FileAttribute[0]);
                ArsAffinity.LOGGER.warn("Perk trees directory does not exist, created: {}", (Object)configDir);
            }
            for (SpellSchool school : SUPPORTED_SCHOOLS) {
                String schoolName = PerkTreeManager.getSchoolName(school);
                Path schoolFile = configDir.resolve(schoolName + ".json");
                if (Files.exists(schoolFile, new LinkOption[0])) {
                    ArsAffinity.LOGGER.info("Loading perk tree for school: {} from config", (Object)schoolName);
                    PerkTreeManager.loadSchoolPerkTree(school, schoolFile);
                    continue;
                }
                try {
                    String resourcePath = "data/ars_affinity/config/perk_trees/" + schoolName + ".json";
                    InputStream resourceStream = PerkTreeManager.class.getClassLoader().getResourceAsStream(resourcePath);
                    if (resourceStream != null) {
                        ArsAffinity.LOGGER.info("Copying perk tree for school: {} from JAR resources", (Object)schoolName);
                        Files.createDirectories(schoolFile.getParent(), new FileAttribute[0]);
                        Files.copy(resourceStream, schoolFile, new CopyOption[0]);
                        PerkTreeManager.loadSchoolPerkTree(school, schoolFile);
                        continue;
                    }
                    ArsAffinity.LOGGER.warn("No perk tree file found for school: {}", (Object)schoolName);
                }
                catch (IOException e) {
                    ArsAffinity.LOGGER.error("Failed to copy perk tree file for school {}: {}", (Object)schoolName, (Object)e.getMessage());
                }
            }
            isLoaded = true;
            ArsAffinity.LOGGER.info("Loaded perk trees for {} schools with {} total nodes", (Object)perkTrees.size(), (Object)allNodes.size());
        }
        catch (Exception e) {
            ArsAffinity.LOGGER.error("Error loading perk trees: {}", (Object)e.getMessage(), (Object)e);
            throw new RuntimeException("Failed to load perk trees", e);
        }
    }

    private static void loadSchoolPerkTree(SpellSchool school, Path schoolFile) throws IOException {
        String content = Files.readString(schoolFile, StandardCharsets.UTF_8);
        JsonObject schoolData = JsonParser.parseString((String)content).getAsJsonObject();
        HashMap<String, PerkNode> schoolNodes = new HashMap<String, PerkNode>();
        if (schoolData.has("perks")) {
            JsonArray perksArray = schoolData.getAsJsonArray("perks");
            for (JsonElement nodeElement : perksArray) {
                PerkNode node = PerkTreeManager.parsePerkNode(nodeElement.getAsJsonObject(), school);
                schoolNodes.put(node.getId(), node);
                allNodes.put(node.getId(), node);
            }
        }
        perkTrees.put(school, schoolNodes);
        ArsAffinity.LOGGER.info("Loaded {} nodes for school {}", (Object)schoolNodes.size(), (Object)school.getId());
    }

    private static PerkNode parsePerkNode(JsonObject nodeData, SpellSchool school) {
        String id = nodeData.get("id").getAsString();
        AffinityPerkType perkType = AffinityPerkType.valueOf(nodeData.get("perk").getAsString());
        int tier = nodeData.get("tier").getAsInt();
        int pointCost = nodeData.get("pointCost").getAsInt();
        PerkCategory category = PerkCategory.valueOf(nodeData.get("category").getAsString());
        float amount = nodeData.has("amount") ? nodeData.get("amount").getAsFloat() : 0.0f;
        int time = nodeData.has("time") ? nodeData.get("time").getAsInt() : 0;
        int cooldown = nodeData.has("cooldown") ? nodeData.get("cooldown").getAsInt() : 0;
        float manaCost = nodeData.has("manaCost") ? nodeData.get("manaCost").getAsFloat() : 0.0f;
        float damage = nodeData.has("damage") ? nodeData.get("damage").getAsFloat() : 0.0f;
        int freezeTime = nodeData.has("freezeTime") ? nodeData.get("freezeTime").getAsInt() : 0;
        float radius = nodeData.has("radius") ? nodeData.get("radius").getAsFloat() : 0.0f;
        float dashLength = nodeData.has("dashLength") ? nodeData.get("dashLength").getAsFloat() : 0.0f;
        float dashDuration = nodeData.has("dashDuration") ? nodeData.get("dashDuration").getAsFloat() : 0.0f;
        float health = nodeData.has("health") ? nodeData.get("health").getAsFloat() : 0.0f;
        float hunger = nodeData.has("hunger") ? nodeData.get("hunger").getAsFloat() : 0.0f;
        ArrayList<String> prerequisites = new ArrayList<String>();
        if (nodeData.has("prerequisites")) {
            JsonArray prereqArray = nodeData.getAsJsonArray("prerequisites");
            for (JsonElement prereqElement : prereqArray) {
                prerequisites.add(prereqElement.getAsString());
            }
        }
        String prerequisiteGlyph = nodeData.has("prerequisite_glyph") ? nodeData.get("prerequisite_glyph").getAsString() : null;
        return new PerkNode(id, perkType, school, tier, pointCost, prerequisites, prerequisiteGlyph, category, amount, time, cooldown, manaCost, damage, freezeTime, radius, dashLength, dashDuration, health, hunger);
    }

    public static PerkNode getNode(String nodeId) {
        if (!isLoaded) {
            PerkTreeManager.loadPerkTrees();
        }
        return allNodes.get(nodeId);
    }

    public static Map<String, PerkNode> getSchoolNodes(SpellSchool school) {
        if (!isLoaded) {
            PerkTreeManager.loadPerkTrees();
        }
        return perkTrees.getOrDefault(school, new HashMap());
    }

    public static List<PerkNode> getRootNodes(SpellSchool school) {
        Map<String, PerkNode> schoolNodes = PerkTreeManager.getSchoolNodes(school);
        return schoolNodes.values().stream().filter(PerkNode::isRootNode).collect(Collectors.toList());
    }

    public static List<PerkNode> getChildNodes(String parentNodeId) {
        if (!isLoaded) {
            PerkTreeManager.loadPerkTrees();
        }
        return allNodes.values().stream().filter(node -> node.getPrerequisites().contains(parentNodeId)).collect(Collectors.toList());
    }

    public static int calculatePointCost(SpellSchool school, int currentPoints) {
        return 1;
    }

    public static int convertAffinityToPoints(float affinityPercentage) {
        double scalingDecay = (Double)ArsAffinityConfig.AFFINITY_SCALING_DECAY_STRENGTH.get();
        double minimumFactor = (Double)ArsAffinityConfig.AFFINITY_SCALING_MINIMUM_FACTOR.get();
        double basePoints = 100.0;
        double scalingFactor = Math.max(minimumFactor, Math.pow(1.0 - (double)affinityPercentage, scalingDecay));
        double totalPoints = basePoints * scalingFactor;
        return Math.max(0, (int)Math.round(totalPoints));
    }

    public static int getTotalPerksForSchool(SpellSchool school) {
        Map<String, PerkNode> schoolNodes = PerkTreeManager.getSchoolNodes(school);
        return schoolNodes.size();
    }

    public static int getMaxPointsForSchool(SpellSchool school) {
        return PerkTreeManager.getTotalPerksForSchool(school);
    }

    public static float convertPointsToPercentage(int currentPoints, int maxPoints) {
        if (maxPoints <= 0) {
            return 0.0f;
        }
        return Math.min(1.0f, (float)currentPoints / (float)maxPoints);
    }

    public static void createDefaultPerkTrees() {
        Path configDir = FMLPaths.CONFIGDIR.get().resolve("ars_affinity").resolve("perk_trees");
        try {
            Files.createDirectories(configDir, new FileAttribute[0]);
            PerkTreeManager.createExampleFirePerkTree(configDir);
            ArsAffinity.LOGGER.info("Created default perk trees in: {}", (Object)configDir);
        }
        catch (IOException e) {
            ArsAffinity.LOGGER.error("Failed to create default perk trees: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static void createExampleFirePerkTree(Path configDir) throws IOException {
        JsonObject fireTree = new JsonObject();
        JsonArray perks = new JsonArray();
        JsonObject fireThorns = new JsonObject();
        fireThorns.addProperty("id", "fire_thorns_1");
        fireThorns.addProperty("perk", "PASSIVE_FIRE_THORNS");
        fireThorns.addProperty("tier", (Number)1);
        fireThorns.addProperty("pointCost", (Number)10);
        fireThorns.addProperty("category", "PASSIVE");
        fireThorns.addProperty("isStackable", Boolean.valueOf(false));
        fireThorns.addProperty("maxStacks", (Number)1);
        perks.add((JsonElement)fireThorns);
        JsonObject fireDash = new JsonObject();
        fireDash.addProperty("id", "fire_dash_1");
        fireDash.addProperty("perk", "ACTIVE_FIRE_DASH");
        fireDash.addProperty("tier", (Number)1);
        fireDash.addProperty("pointCost", (Number)15);
        fireDash.addProperty("category", "ACTIVE");
        fireDash.addProperty("isStackable", Boolean.valueOf(false));
        fireDash.addProperty("maxStacks", (Number)1);
        perks.add((JsonElement)fireDash);
        JsonObject spellPower = new JsonObject();
        spellPower.addProperty("id", "fire_spell_power_1");
        spellPower.addProperty("perk", "STACKABLE_SPELL_POWER");
        spellPower.addProperty("tier", (Number)1);
        spellPower.addProperty("pointCost", (Number)5);
        spellPower.addProperty("category", "STACKABLE");
        spellPower.addProperty("isStackable", Boolean.valueOf(true));
        spellPower.addProperty("maxStacks", (Number)5);
        perks.add((JsonElement)spellPower);
        JsonObject enhancedFireThorns = new JsonObject();
        enhancedFireThorns.addProperty("id", "fire_thorns_2");
        enhancedFireThorns.addProperty("perk", "PASSIVE_FIRE_THORNS");
        enhancedFireThorns.addProperty("tier", (Number)2);
        enhancedFireThorns.addProperty("pointCost", (Number)20);
        enhancedFireThorns.addProperty("category", "PASSIVE");
        enhancedFireThorns.addProperty("isStackable", Boolean.valueOf(false));
        enhancedFireThorns.addProperty("maxStacks", (Number)1);
        JsonArray prereqs = new JsonArray();
        prereqs.add("fire_thorns_1");
        enhancedFireThorns.add("prerequisites", (JsonElement)prereqs);
        perks.add((JsonElement)enhancedFireThorns);
        fireTree.add("perks", (JsonElement)perks);
        Path fireFile = configDir.resolve("fire.json");
        Files.writeString(fireFile, (CharSequence)GSON.toJson((JsonElement)fireTree), StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private static String getSchoolName(SpellSchool school) {
        String schoolId;
        return switch (schoolId = school.getId().toString()) {
            case "ars_nouveau:elemental_fire" -> "fire";
            case "ars_nouveau:elemental_water" -> "water";
            case "ars_nouveau:elemental_earth" -> "earth";
            case "ars_nouveau:elemental_air" -> "air";
            case "ars_nouveau:abjuration" -> "abjuration";
            case "ars_nouveau:necromancy" -> "necromancy";
            case "ars_nouveau:conjuration" -> "conjuration";
            case "ars_nouveau:manipulation" -> "manipulation";
            default -> schoolId.replace(":", "_");
        };
    }
}

