/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.common.network;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.client.particles.SpiralParticleHelper;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.common.network.AbstractPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class ParticleEffectPacket
extends AbstractPacket {
    public static final CustomPacketPayload.Type<ParticleEffectPacket> TYPE = new CustomPacketPayload.Type(ArsAffinity.prefix("particle_effect"));
    public static final CustomPacketPayload.Type<ParticleEffectPacket> UPDATE_TYPE = new CustomPacketPayload.Type(ArsAffinity.prefix("particle_effect_update"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ParticleEffectPacket> CODEC = StreamCodec.ofMember(ParticleEffectPacket::toBytes, ParticleEffectPacket::new);
    private final int playerId;
    private final String schoolId;
    private final int particleCount;
    private final double posX;
    private final double posY;
    private final double posZ;
    private final boolean isUpdate;

    public ParticleEffectPacket(int playerId, String schoolId, int particleCount) {
        this(playerId, schoolId, particleCount, 0.0, 0.0, 0.0, false);
    }

    public ParticleEffectPacket(int playerId, String schoolId, double posX, double posY, double posZ) {
        this(playerId, schoolId, 0, posX, posY, posZ, true);
    }

    private ParticleEffectPacket(int playerId, String schoolId, int particleCount, double posX, double posY, double posZ, boolean isUpdate) {
        this.playerId = playerId;
        this.schoolId = schoolId;
        this.particleCount = particleCount;
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.isUpdate = isUpdate;
    }

    public ParticleEffectPacket(RegistryFriendlyByteBuf buf) {
        this.playerId = buf.readVarInt();
        this.schoolId = buf.readUtf();
        this.isUpdate = buf.readBoolean();
        if (this.isUpdate) {
            this.particleCount = 0;
            this.posX = buf.readDouble();
            this.posY = buf.readDouble();
            this.posZ = buf.readDouble();
        } else {
            this.particleCount = buf.readVarInt();
            this.posX = 0.0;
            this.posY = 0.0;
            this.posZ = 0.0;
        }
    }

    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeVarInt(this.playerId);
        buf.writeUtf(this.schoolId);
        buf.writeBoolean(this.isUpdate);
        if (this.isUpdate) {
            buf.writeDouble(this.posX);
            buf.writeDouble(this.posY);
            buf.writeDouble(this.posZ);
        } else {
            buf.writeVarInt(this.particleCount);
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return this.isUpdate ? UPDATE_TYPE : TYPE;
    }

    public void onClientReceived(Minecraft minecraft, Player player) {
        Handle.handle(this, minecraft, player);
    }

    private static class Handle {
        private Handle() {
        }

        public static void handle(ParticleEffectPacket packet, Minecraft minecraft, Player player) {
            ArsAffinity.LOGGER.info("=== PARTICLE EFFECT PACKET RECEIVED ===");
            ArsAffinity.LOGGER.info("ParticleEffectPacket.handle called with playerId={}, schoolId={}, isUpdate={}", (Object)packet.playerId, (Object)packet.schoolId, (Object)packet.isUpdate);
            ArsAffinity.LOGGER.info("Minecraft level: {}, isClientSide: {}", minecraft.level != null ? minecraft.level.dimension().location() : "null", minecraft.level != null ? Boolean.valueOf(minecraft.level.isClientSide()) : "null");
            if (minecraft.level != null && minecraft.level.isClientSide()) {
                ArsAffinity.LOGGER.info("ParticleEffectPacket: Client-side level confirmed");
                if (packet.isUpdate) {
                    ArsAffinity.LOGGER.debug("ParticleEffectPacket: Position update received: ({}, {}, {})", (Object)packet.posX, (Object)packet.posY, (Object)packet.posZ);
                    SpiralParticleHelper.updateParticleCenter(packet.playerId, packet.schoolId, packet.posX, packet.posY, packet.posZ);
                } else {
                    Player p;
                    Player targetPlayer;
                    Entity entity = minecraft.level.getEntity(packet.playerId);
                    Player player2 = targetPlayer = entity instanceof Player ? (p = (Player)entity) : null;
                    if (targetPlayer != null) {
                        ArsAffinity.LOGGER.info("ParticleEffectPacket: Target player found: {} at position ({}, {}, {})", (Object)targetPlayer.getName().getString(), (Object)targetPlayer.getX(), (Object)targetPlayer.getY(), (Object)targetPlayer.getZ());
                        SpellSchool school = Handle.getSchoolFromId(packet.schoolId);
                        if (school != null) {
                            ArsAffinity.LOGGER.info("ParticleEffectPacket: School found: {}, spawning {} particles", (Object)school.getId(), (Object)packet.particleCount);
                            ArsAffinity.LOGGER.info("ParticleEffectPacket: Calling SpiralParticleHelper.spawnSpiralParticles");
                            try {
                                SpiralParticleHelper.spawnSpiralParticles(minecraft.level, targetPlayer, school, packet.particleCount);
                                ArsAffinity.LOGGER.info("ParticleEffectPacket: Particles spawned successfully");
                            }
                            catch (Exception e) {
                                ArsAffinity.LOGGER.error("ParticleEffectPacket: Error spawning particles: {}", (Object)e.getMessage(), (Object)e);
                            }
                        } else {
                            ArsAffinity.LOGGER.warn("ParticleEffectPacket: School not found for ID: {}", (Object)packet.schoolId);
                        }
                    } else {
                        ArsAffinity.LOGGER.warn("ParticleEffectPacket: Target player not found for ID: {}", (Object)packet.playerId);
                    }
                }
            } else {
                ArsAffinity.LOGGER.warn("ParticleEffectPacket: Not on client side or level is null");
            }
            ArsAffinity.LOGGER.info("=== PARTICLE EFFECT PACKET HANDLING COMPLETE ===");
        }

        private static SpellSchool getSchoolFromId(String schoolId) {
            return switch (schoolId) {
                case "fire" -> SpellSchools.ELEMENTAL_FIRE;
                case "water" -> SpellSchools.ELEMENTAL_WATER;
                case "earth" -> SpellSchools.ELEMENTAL_EARTH;
                case "air" -> SpellSchools.ELEMENTAL_AIR;
                case "abjuration" -> SpellSchools.ABJURATION;
                case "necromancy" -> SpellSchools.NECROMANCY;
                case "conjuration" -> SpellSchools.CONJURATION;
                case "manipulation" -> SpellSchools.MANIPULATION;
                default -> {
                    ArsAffinity.LOGGER.warn("ParticleEffectPacket: Unknown school ID: '{}'", (Object)schoolId);
                    yield null;
                }
            };
        }
    }
}

