/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.common.ability.field;

import com.github.ars_affinity.common.ability.field.AbstractFieldAbility;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import net.minecraft.server.level.ServerPlayer;

public class ActiveFieldRegistry {
    private static final Map<UUID, AbstractFieldAbility> ACTIVE = new ConcurrentHashMap<UUID, AbstractFieldAbility>();

    public static boolean toggleOrStart(ServerPlayer player, Supplier<AbstractFieldAbility> supplier) {
        UUID id = player.getUUID();
        if (ACTIVE.containsKey(id)) {
            return false;
        }
        ACTIVE.put(id, supplier.get());
        return true;
    }

    public static void stop(ServerPlayer player) {
        UUID id = player.getUUID();
        AbstractFieldAbility ability = ACTIVE.remove(id);
        if (ability != null) {
            ability.onRelease();
        }
    }

    public static void tick(ServerPlayer player) {
        UUID id = player.getUUID();
        AbstractFieldAbility ability = ACTIVE.get(id);
        if (ability == null) {
            return;
        }
        boolean keep = ability.tick();
        if (!keep) {
            ACTIVE.remove(id);
            ability.onRelease();
        }
    }
}

