/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.client.screen.perk;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.capability.PlayerAffinityData;
import com.github.ars_affinity.capability.PlayerAffinityDataHelper;
import com.github.ars_affinity.client.screen.SchoolGlyphScreen;
import com.github.ars_affinity.client.screen.perk.PerkConnectionRenderer;
import com.github.ars_affinity.client.screen.perk.PerkNodeRenderer;
import com.github.ars_affinity.client.screen.perk.PerkTooltipRenderer;
import com.github.ars_affinity.client.screen.perk.PerkTreeLayout;
import com.github.ars_affinity.perk.PerkAllocation;
import com.github.ars_affinity.perk.PerkAllocationManager;
import com.github.ars_affinity.perk.PerkNode;
import com.github.ars_affinity.perk.PerkTreeManager;
import com.hollingsworth.arsnouveau.api.documentation.DocAssets;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;

public class PerkTreeScreen
extends Screen {
    private static final ResourceLocation PERK_TREE_BACKGROUND = ArsAffinity.prefix("textures/gui/perk_tree_background.png");
    private static final ResourceLocation PERK_TREE_FRAME = ArsAffinity.prefix("textures/gui/perk_tree_frame.png");
    private final Player player;
    private final SpellSchool school;
    private final Screen previousScreen;
    private final Map<String, PerkNode> schoolPerks;
    private final Map<String, PerkAllocation> allocatedPerks;
    private final PlayerAffinityData affinityData;
    private final PerkTreeLayout layout;
    private final PerkNodeRenderer nodeRenderer;
    private final PerkConnectionRenderer connectionRenderer;
    private final PerkTooltipRenderer tooltipRenderer;
    private int scrollX = 0;
    private int scrollY = 0;
    private boolean isDragging = false;
    private PerkNode hoveredNode = null;
    private PerkAllocation hoveredAllocation = null;

    public PerkTreeScreen(Player player, SpellSchool school, Screen previousScreen) {
        super((Component)Component.translatable((String)"ars_affinity.screen.perk_tree.title", (Object[])new Object[]{school.getTextComponent()}));
        this.player = player;
        this.school = school;
        this.previousScreen = previousScreen;
        this.schoolPerks = PerkTreeManager.getSchoolNodes(school);
        this.affinityData = PlayerAffinityDataHelper.getPlayerAffinityData(player);
        this.allocatedPerks = PerkAllocationManager.getAllocatedPerks(player, school);
        this.layout = new PerkTreeLayout(this.schoolPerks);
        this.nodeRenderer = new PerkNodeRenderer(player, this.allocatedPerks);
        this.connectionRenderer = new PerkConnectionRenderer(player, this.allocatedPerks, school, this.layout);
        this.tooltipRenderer = new PerkTooltipRenderer(player, this.allocatedPerks);
    }

    protected void init() {
        super.init();
        this.centerOnRootNode();
    }

    public void refreshData() {
        this.allocatedPerks.clear();
        this.allocatedPerks.putAll(PerkAllocationManager.getAllocatedPerks(this.player, this.school));
    }

    private void centerOnRootNode() {
        int rootX = 0;
        int rootY = 0;
        List<PerkNode> rootNodes = this.schoolPerks.values().stream().filter(node -> node.getPrerequisites().isEmpty()).toList();
        if (!rootNodes.isEmpty()) {
            int totalY = 0;
            for (PerkNode rootNode : rootNodes) {
                totalY += this.layout.getNodeY(rootNode, 0);
            }
            rootY = totalY / rootNodes.size();
        }
        this.scrollX = -rootX;
        this.scrollY = -rootY + this.height / 2 - 50;
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int panelWidth = 256;
        int panelHeight = 200;
        int panelX = centerX - panelWidth / 2;
        int panelY = centerY - panelHeight / 2;
        int startX = this.layout.getStartX(this.width, this.scrollX);
        int startY = this.layout.getStartY(this.scrollY);
        guiGraphics.enableScissor(panelX, panelY, panelX + panelWidth, panelY + panelHeight);
        this.renderParallaxBackground(guiGraphics, panelX, panelY, panelWidth, panelHeight);
        guiGraphics.fill(panelX - 1, panelY - 1, panelX + panelWidth + 1, panelY, -12566464);
        guiGraphics.fill(panelX - 1, panelY + panelHeight, panelX + panelWidth + 1, panelY + panelHeight + 1, -12566464);
        guiGraphics.fill(panelX - 1, panelY, panelX, panelY + panelHeight, -12566464);
        guiGraphics.fill(panelX + panelWidth, panelY, panelX + panelWidth + 1, panelY + panelHeight, -12566464);
        this.connectionRenderer.renderConnections(guiGraphics, this.layout.getPerksByTier(), this.schoolPerks, startX, startY);
        this.renderNodesWithoutNumerals(guiGraphics, startX, startY, mouseX, mouseY);
        this.renderFrameOverlay(guiGraphics);
        this.renderRomanNumerals(guiGraphics, startX, startY);
        guiGraphics.disableScissor();
        if (this.hoveredNode != null) {
            this.tooltipRenderer.renderNodeTooltip(guiGraphics, this.font, this.hoveredNode, this.hoveredAllocation, mouseX, mouseY);
        }
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, mouseX, mouseY, partialTick);
        }
        this.renderBackButtonIcon(guiGraphics, mouseX, mouseY);
        this.renderGlyphButton(guiGraphics, mouseX, mouseY);
        this.renderHeader(guiGraphics);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int panelWidth = 256;
        int panelHeight = 200;
        int panelX = centerX - panelWidth / 2;
        int panelY = centerY - panelHeight / 2;
        int startX = this.layout.getStartX(this.width, this.scrollX);
        int startY = this.layout.getStartY(this.scrollY);
        guiGraphics.enableScissor(panelX, panelY, panelX + panelWidth, panelY + panelHeight);
        this.renderParallaxBackground(guiGraphics, panelX, panelY, panelWidth, panelHeight);
        guiGraphics.fill(panelX - 1, panelY - 1, panelX + panelWidth + 1, panelY, -12566464);
        guiGraphics.fill(panelX - 1, panelY + panelHeight, panelX + panelWidth + 1, panelY + panelHeight + 1, -12566464);
        guiGraphics.fill(panelX - 1, panelY, panelX, panelY + panelHeight, -12566464);
        guiGraphics.fill(panelX + panelWidth, panelY, panelX + panelWidth + 1, panelY + panelHeight, -12566464);
        this.connectionRenderer.renderConnections(guiGraphics, this.layout.getPerksByTier(), this.schoolPerks, startX, startY);
        this.renderNodesWithoutNumerals(guiGraphics, startX, startY, mouseX, mouseY);
        guiGraphics.disableScissor();
        if (this.hoveredNode != null) {
            this.tooltipRenderer.renderNodeTooltip(guiGraphics, this.font, this.hoveredNode, this.hoveredAllocation, mouseX, mouseY);
        }
    }

    private void renderParallaxBackground(GuiGraphics guiGraphics, int panelX, int panelY, int panelWidth, int panelHeight) {
        float parallaxFactor = 0.3f;
        int parallaxOffsetX = (int)((float)this.scrollX * parallaxFactor);
        int parallaxOffsetY = (int)((float)this.scrollY * parallaxFactor);
        int textureSize = 410;
        for (int x = panelX - textureSize + parallaxOffsetX; x < panelX + panelWidth + textureSize; x += textureSize) {
            for (int y = panelY - textureSize + parallaxOffsetY; y < panelY + panelHeight + textureSize; y += textureSize) {
                guiGraphics.blit(PERK_TREE_BACKGROUND, x, y, 0.0f, 0.0f, textureSize, textureSize, textureSize, textureSize);
            }
        }
    }

    private void renderHeader(GuiGraphics guiGraphics) {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int panelWidth = 256;
        int panelHeight = 200;
        int panelX = centerX - panelWidth / 2;
        int panelY = centerY - panelHeight / 2;
        int headerWidth = 14;
        int headerHeight = 14;
        int headerX = panelX + (panelWidth - headerWidth) / 2;
        int headerY = panelY - headerHeight - 5 + headerHeight * 2;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 0.2f);
        guiGraphics.fill(headerX, headerY, headerX + headerWidth, headerY + headerHeight, -16777216);
        int availablePoints = this.affinityData.getAvailablePoints(this.school);
        String pointsText = String.valueOf(availablePoints);
        int textX = headerX + headerWidth / 2 - this.font.width(pointsText) / 2;
        int textY = headerY + 3;
        guiGraphics.drawString(this.font, pointsText, textX, textY, 0xFFFFFF);
        guiGraphics.pose().popPose();
    }

    private void renderBackButtonIcon(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int panelWidth = 256;
        int panelHeight = 200;
        int panelX = centerX - panelWidth / 2;
        int panelY = centerY - panelHeight / 2;
        int buttonWidth = DocAssets.ARROW_BACK.width();
        int buttonHeight = DocAssets.ARROW_BACK.height();
        int buttonX = panelX + 10;
        int buttonY = panelY + 10;
        boolean isHovered = mouseX >= buttonX && mouseX < buttonX + buttonWidth && mouseY >= buttonY && mouseY < buttonY + buttonHeight;
        DocAssets.BlitInfo backIcon = isHovered ? DocAssets.ARROW_BACK_HOVER : DocAssets.ARROW_BACK;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 0.15f);
        guiGraphics.blit(backIcon.location(), buttonX, buttonY, (float)backIcon.u(), (float)backIcon.v(), buttonWidth, buttonHeight, backIcon.width(), backIcon.height());
        guiGraphics.pose().popPose();
    }

    private void renderGlyphButton(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int panelWidth = 256;
        int panelHeight = 200;
        int panelX = centerX - panelWidth / 2;
        int panelY = centerY - panelHeight / 2;
        int buttonSize = 18;
        int buttonX = panelX + panelWidth - buttonSize - 10;
        int buttonY = panelY + 10;
        boolean isHovered = mouseX >= buttonX && mouseX < buttonX + buttonSize && mouseY >= buttonY && mouseY < buttonY + buttonSize;
        int backgroundColor = isHovered ? -11908534 : -14013910;
        guiGraphics.fill(buttonX, buttonY, buttonX + buttonSize, buttonY + buttonSize, backgroundColor);
        int borderColor = isHovered ? -7829368 : -11184811;
        guiGraphics.fill(buttonX, buttonY, buttonX + buttonSize, buttonY + 1, borderColor);
        guiGraphics.fill(buttonX, buttonY, buttonX + 1, buttonY + buttonSize, borderColor);
        guiGraphics.fill(buttonX + buttonSize - 1, buttonY, buttonX + buttonSize, buttonY + buttonSize, borderColor);
        guiGraphics.fill(buttonX, buttonY + buttonSize - 1, buttonX + buttonSize, buttonY + buttonSize, borderColor);
        ResourceLocation iconTexture = this.school.getTexturePath();
        int iconSize = 16;
        int iconX = buttonX + (buttonSize - iconSize) / 2;
        int iconY = buttonY + (buttonSize - iconSize) / 2;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 0.15f);
        guiGraphics.blit(iconTexture, iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        guiGraphics.pose().popPose();
        if (isHovered) {
            MutableComponent tooltip = Component.translatable((String)"ars_affinity.screen.glyphs.tooltip");
            guiGraphics.renderTooltip(this.font, (Component)tooltip, mouseX, mouseY);
        }
    }

    private void renderFrameOverlay(GuiGraphics guiGraphics) {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int panelWidth = 256;
        int panelHeight = 200;
        int panelX = centerX - panelWidth / 2;
        int panelY = centerY - panelHeight / 2;
        int frameWidth = 258;
        int frameHeight = 202;
        int frameX = panelX - 1;
        int frameY = panelY - 1;
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate(0.0f, 0.0f, 0.1f);
        guiGraphics.blit(PERK_TREE_FRAME, frameX, frameY, 0.0f, 0.0f, frameWidth, frameHeight, frameWidth, frameHeight);
        guiGraphics.pose().popPose();
    }

    private void renderNodes(GuiGraphics guiGraphics, int startX, int startY, int mouseX, int mouseY) {
        this.hoveredNode = null;
        this.hoveredAllocation = null;
        for (PerkNode node : this.schoolPerks.values()) {
            int nodeX = this.layout.getNodeX(node, startX);
            int nodeY = this.layout.getNodeY(node, startY);
            this.nodeRenderer.renderNode(guiGraphics, this.font, node, nodeX, nodeY, mouseX, mouseY);
            if (!this.nodeRenderer.isNodeHovered(node, nodeX, nodeY, mouseX, mouseY)) continue;
            this.hoveredNode = node;
            this.hoveredAllocation = this.allocatedPerks.get(node.getId());
        }
    }

    private void renderNodesWithoutNumerals(GuiGraphics guiGraphics, int startX, int startY, int mouseX, int mouseY) {
        this.hoveredNode = null;
        this.hoveredAllocation = null;
        for (PerkNode node : this.schoolPerks.values()) {
            int nodeX = this.layout.getNodeX(node, startX);
            int nodeY = this.layout.getNodeY(node, startY);
            this.nodeRenderer.renderNodeWithoutNumerals(guiGraphics, this.font, node, nodeX, nodeY, mouseX, mouseY);
            this.tooltipRenderer.renderGlyphPrerequisite(guiGraphics, this.font, node, nodeX, nodeY, 32, mouseX, mouseY);
            if (!this.nodeRenderer.isNodeHovered(node, nodeX, nodeY, mouseX, mouseY)) continue;
            this.hoveredNode = node;
            this.hoveredAllocation = this.allocatedPerks.get(node.getId());
        }
    }

    private void renderRomanNumerals(GuiGraphics guiGraphics, int startX, int startY) {
        for (PerkNode node : this.schoolPerks.values()) {
            int nodeX = this.layout.getNodeX(node, startX);
            int nodeY = this.layout.getNodeY(node, startY);
            boolean isActiveAbility = node.getPerkType().name().startsWith("ACTIVE_");
            int nodeSize = isActiveAbility ? 28 : 24;
            String levelText = this.toRomanNumeral(node.getTier());
            guiGraphics.drawString(this.font, levelText, nodeX + nodeSize - 4, nodeY + nodeSize - 4, 0xFFFFFF);
        }
    }

    private String toRomanNumeral(int number) {
        return switch (number) {
            case 1 -> "I";
            case 2 -> "II";
            case 3 -> "III";
            case 4 -> "IV";
            case 5 -> "V";
            case 6 -> "VI";
            case 7 -> "VII";
            case 8 -> "VIII";
            case 9 -> "IX";
            case 10 -> "X";
            default -> String.valueOf(number);
        };
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 0) {
            if (this.handleBackButtonClick((int)mouseX, (int)mouseY)) {
                return true;
            }
            if (this.handleGlyphButtonClick((int)mouseX, (int)mouseY)) {
                return true;
            }
            if (this.handleNodeClick((int)mouseX, (int)mouseY)) {
                return true;
            }
            this.isDragging = true;
            return true;
        }
        return false;
    }

    public boolean mouseReleased(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isDragging = false;
            return true;
        }
        return super.mouseReleased(mouseX, mouseY, button);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.isDragging && button == 0) {
            this.scrollX += (int)deltaX;
            this.scrollY += (int)deltaY;
            int treeMinX = this.layout.getTreeMinX();
            int treeMaxX = this.layout.getTreeMaxX();
            int treeMinY = this.layout.getTreeMinY();
            int treeMaxY = this.layout.getTreeMaxY();
            int padding = 50;
            int minScrollX = -this.width / 2 - treeMaxX - padding;
            int maxScrollX = this.width / 2 - treeMinX + padding;
            int minScrollY = -treeMaxY - padding;
            int maxScrollY = -treeMinY + this.height - padding;
            this.scrollX = Math.max(minScrollX, Math.min(maxScrollX, this.scrollX));
            this.scrollY = Math.max(minScrollY, Math.min(maxScrollY, this.scrollY));
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    private boolean handleBackButtonClick(int mouseX, int mouseY) {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int panelWidth = 256;
        int panelHeight = 200;
        int panelX = centerX - panelWidth / 2;
        int panelY = centerY - panelHeight / 2;
        int buttonWidth = DocAssets.ARROW_BACK.width();
        int buttonHeight = DocAssets.ARROW_BACK.height();
        int buttonX = panelX + 10;
        int buttonY = panelY + 10;
        if (mouseX >= buttonX && mouseX < buttonX + buttonWidth && mouseY >= buttonY && mouseY < buttonY + buttonHeight) {
            this.onClose();
            return true;
        }
        return false;
    }

    private boolean handleGlyphButtonClick(int mouseX, int mouseY) {
        int centerX = this.width / 2;
        int centerY = this.height / 2;
        int panelWidth = 256;
        int panelHeight = 200;
        int panelX = centerX - panelWidth / 2;
        int panelY = centerY - panelHeight / 2;
        int buttonSize = 18;
        int buttonX = panelX + panelWidth - buttonSize - 10;
        int buttonY = panelY + 10;
        if (mouseX >= buttonX && mouseX < buttonX + buttonSize && mouseY >= buttonY && mouseY < buttonY + buttonSize) {
            ArsAffinity.LOGGER.info("Glyph button clicked for school: {}", (Object)this.school);
            try {
                this.minecraft.setScreen((Screen)new SchoolGlyphScreen(this, this.school));
            }
            catch (Exception e) {
                ArsAffinity.LOGGER.error("Error opening SchoolGlyphScreen: {}", (Object)e.getMessage(), (Object)e);
            }
            return true;
        }
        return false;
    }

    private boolean handleNodeClick(int mouseX, int mouseY) {
        int startY;
        int startX = this.layout.getStartX(this.width, this.scrollX);
        PerkNode clickedNode = this.layout.getNodeAt(mouseX, mouseY, startX, startY = this.layout.getStartY(this.scrollY));
        if (clickedNode != null) {
            PerkAllocation allocation = this.allocatedPerks.get(clickedNode.getId());
            if (allocation != null && allocation.isActive()) {
                PerkAllocationManager.deallocatePerk(this.player, clickedNode.getId());
                this.player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.5f, 0.8f);
            } else {
                PerkAllocationManager.allocatePoints(this.player, clickedNode.getId(), 1);
                this.player.playSound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 0.5f, 1.2f);
            }
            this.refreshData();
            return true;
        }
        return false;
    }

    public void onClose() {
        this.minecraft.setScreen(this.previousScreen);
    }

    public boolean isPauseScreen() {
        return false;
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256) {
            this.onClose();
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }
}

