/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.client.screen.perk;

import com.github.ars_affinity.client.screen.perk.SchoolColorHelper;
import com.github.ars_affinity.perk.PerkAllocation;
import com.github.ars_affinity.perk.PerkAllocationManager;
import com.github.ars_affinity.perk.PerkNode;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Map;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class PerkNodeRenderer {
    private static final ResourceLocation PERK_BACKGROUND_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"ars_affinity", (String)"textures/gui/perk_background.png");
    private static final ResourceLocation PERK_BORDER_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"ars_affinity", (String)"textures/gui/perk_border.png");
    private static final ResourceLocation PERK_BORDER_ACTIVE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"ars_affinity", (String)"textures/gui/perk_border_active.png");
    private static final int NODE_SIZE = 24;
    private static final int ACTIVE_NODE_SIZE = 28;
    private final Player player;
    private final Map<String, PerkAllocation> allocatedPerks;

    public PerkNodeRenderer(Player player, Map<String, PerkAllocation> allocatedPerks) {
        this.player = player;
        this.allocatedPerks = allocatedPerks;
    }

    public void renderNode(GuiGraphics guiGraphics, Font font, PerkNode node, int x, int y, int mouseX, int mouseY) {
        PerkAllocation allocation = this.allocatedPerks.get(node.getId());
        boolean isAllocated = allocation != null && allocation.isActive();
        boolean isAvailable = PerkAllocationManager.canAllocate(this.player, node.getId());
        boolean isActiveAbility = node.getPerkType().name().startsWith("ACTIVE_");
        int nodeSize = isActiveAbility ? 28 : 24;
        int color = this.getNodeColor(node, isAllocated, isAvailable);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(PERK_BACKGROUND_TEXTURE, x, y, 0.0f, 0.0f, nodeSize, nodeSize, nodeSize, nodeSize);
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
        ResourceLocation borderTexture = isActiveAbility ? PERK_BORDER_ACTIVE_TEXTURE : PERK_BORDER_TEXTURE;
        guiGraphics.blit(borderTexture, x, y, 0.0f, 0.0f, nodeSize, nodeSize, nodeSize, nodeSize);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderPerkIcon(guiGraphics, node, x, y, isAllocated, isAvailable, nodeSize);
        String levelText = this.toRomanNumeral(node.getTier());
        guiGraphics.drawString(font, levelText, x + nodeSize - 8, y + nodeSize - 8, 0xFFFFFF);
    }

    public void renderNodeWithoutNumerals(GuiGraphics guiGraphics, Font font, PerkNode node, int x, int y, int mouseX, int mouseY) {
        PerkAllocation allocation = this.allocatedPerks.get(node.getId());
        boolean isAllocated = allocation != null && allocation.isActive();
        boolean isAvailable = PerkAllocationManager.canAllocate(this.player, node.getId());
        boolean isActiveAbility = node.getPerkType().name().startsWith("ACTIVE_");
        int nodeSize = isActiveAbility ? 28 : 24;
        int color = this.getNodeColor(node, isAllocated, isAvailable);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.blit(PERK_BACKGROUND_TEXTURE, x, y, 0.0f, 0.0f, nodeSize, nodeSize, nodeSize, nodeSize);
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)1.0f);
        ResourceLocation borderTexture = isActiveAbility ? PERK_BORDER_ACTIVE_TEXTURE : PERK_BORDER_TEXTURE;
        guiGraphics.blit(borderTexture, x, y, 0.0f, 0.0f, nodeSize, nodeSize, nodeSize, nodeSize);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderPerkIcon(guiGraphics, node, x, y, isAllocated, isAvailable, nodeSize);
    }

    private void renderPerkIcon(GuiGraphics guiGraphics, PerkNode node, int nodeX, int nodeY, boolean isAllocated, boolean isAvailable, int nodeSize) {
        ResourceLocation perkIcon = this.getPerkIcon(node);
        int iconSize = 18;
        int iconX = nodeX + (nodeSize - iconSize) / 2;
        int iconY = nodeY + (nodeSize - iconSize) / 2;
        if (isAllocated) {
            guiGraphics.blit(perkIcon, iconX, iconY, 0.0f, 0.0f, iconSize, iconSize, iconSize, iconSize);
        } else {
            this.renderGrayscaleIcon(guiGraphics, perkIcon, iconX, iconY, iconSize);
        }
    }

    private void renderGrayscaleIcon(GuiGraphics guiGraphics, ResourceLocation icon, int x, int y, int size) {
        RenderSystem.setShaderColor((float)0.5f, (float)0.5f, (float)0.5f, (float)0.7f);
        guiGraphics.blit(icon, x, y, 0.0f, 0.0f, size, size, size, size);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private ResourceLocation getPerkIcon(PerkNode node) {
        String perkType = node.getPerkType().name().toLowerCase();
        return ResourceLocation.fromNamespaceAndPath((String)"ars_affinity", (String)("textures/gui/perks/" + perkType + ".png"));
    }

    public boolean isNodeHovered(PerkNode node, int x, int y, int mouseX, int mouseY) {
        boolean isActiveAbility = node.getPerkType().name().startsWith("ACTIVE_");
        int nodeSize = isActiveAbility ? 28 : 24;
        return mouseX >= x && mouseX < x + nodeSize && mouseY >= y && mouseY < y + nodeSize;
    }

    private int getNodeColor(PerkNode node, boolean isAllocated, boolean isAvailable) {
        if (isAllocated) {
            return SchoolColorHelper.getSchoolAllocatedColor(node.getSchool());
        }
        return -10066330;
    }

    private String toRomanNumeral(int number) {
        return switch (number) {
            case 1 -> "I";
            case 2 -> "II";
            case 3 -> "III";
            case 4 -> "IV";
            case 5 -> "V";
            case 6 -> "VI";
            case 7 -> "VII";
            case 8 -> "VIII";
            case 9 -> "IX";
            case 10 -> "X";
            default -> String.valueOf(number);
        };
    }
}

