/*
 * Decompiled with CFR 0.152.
 */
package com.github.ars_affinity.capability;

import com.github.ars_affinity.ArsAffinity;
import com.github.ars_affinity.capability.ActiveAbilityData;
import com.github.ars_affinity.capability.ActiveAbilityProvider;
import com.github.ars_affinity.perk.ActiveAbilityHelper;
import com.github.ars_affinity.perk.AffinityPerkType;
import com.github.ars_affinity.perk.PerkAllocation;
import com.github.ars_affinity.perk.PerkNode;
import com.github.ars_affinity.perk.PerkTreeManager;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.common.util.INBTSerializable;

public class PlayerAffinityData
implements INBTSerializable<CompoundTag> {
    private final Map<SpellSchool, Integer> schoolPoints = new HashMap<SpellSchool, Integer>();
    private final Map<SpellSchool, Float> schoolPercentages = new HashMap<SpellSchool, Float>();
    private final Map<SpellSchool, Integer> availablePoints = new HashMap<SpellSchool, Integer>();
    private final Map<String, PerkAllocation> allocatedPerks = new HashMap<String, PerkAllocation>();
    private final Set<String> unlockedNodes = new HashSet<String>();
    private boolean isDirty = false;
    private Player player;
    private static final SpellSchool[] SUPPORTED_SCHOOLS = new SpellSchool[]{SpellSchools.ELEMENTAL_FIRE, SpellSchools.ELEMENTAL_WATER, SpellSchools.ELEMENTAL_EARTH, SpellSchools.ELEMENTAL_AIR, SpellSchools.ABJURATION, SpellSchools.NECROMANCY, SpellSchools.CONJURATION, SpellSchools.MANIPULATION};

    public PlayerAffinityData() {
        for (SpellSchool school : SUPPORTED_SCHOOLS) {
            this.schoolPoints.put(school, 0);
            this.schoolPercentages.put(school, Float.valueOf(0.0f));
            this.availablePoints.put(school, 0);
        }
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    public void clearPlayer() {
        this.player = null;
    }

    private void markDirty() {
        this.isDirty = true;
    }

    public int getSchoolPoints(SpellSchool school) {
        return this.schoolPoints.getOrDefault(school, 0);
    }

    public int getAvailablePoints(SpellSchool school) {
        return this.availablePoints.getOrDefault(school, 0);
    }

    public boolean hasAnyAvailablePoints() {
        return this.availablePoints.values().stream().anyMatch(points -> points > 0);
    }

    public float getSchoolPercentage(SpellSchool school) {
        return this.schoolPercentages.getOrDefault(school, Float.valueOf(0.0f)).floatValue();
    }

    public Map<SpellSchool, Float> getAllSchoolPercentages() {
        return new HashMap<SpellSchool, Float>(this.schoolPercentages);
    }

    public Map<SpellSchool, Integer> getAllSchoolPoints() {
        return new HashMap<SpellSchool, Integer>(this.schoolPoints);
    }

    public int addSchoolProgress(SpellSchool school, float percentageIncrease) {
        float currentPercentage = this.getSchoolPercentage(school);
        float newPercentage = Math.min(100.0f, currentPercentage + percentageIncrease);
        this.schoolPercentages.put(school, Float.valueOf(newPercentage));
        int maxPoints = PerkTreeManager.getMaxPointsForSchool(school);
        if (maxPoints <= 0) {
            ArsAffinity.LOGGER.warn("No max points configured for school {}, cannot award points", (Object)school.getId());
            return 0;
        }
        int thresholdInterval = 100 / maxPoints;
        int newPoints = (int)(newPercentage / (float)thresholdInterval);
        int oldPoints = this.getSchoolPoints(school);
        int pointsAwarded = Math.max(0, newPoints - oldPoints);
        if (pointsAwarded > 0) {
            this.schoolPoints.put(school, newPoints);
            this.updateAvailablePoints(school);
            this.markDirty();
            ArsAffinity.LOGGER.info("Awarded {} points to {} school ({}% -> {} points)", (Object)pointsAwarded, (Object)school.getId(), (Object)Float.valueOf(newPercentage), (Object)newPoints);
        }
        return pointsAwarded;
    }

    public int getTotalPointsAcrossAllSchools() {
        return this.schoolPoints.values().stream().mapToInt(Integer::intValue).sum();
    }

    public float getSchoolAffinityPercentage(SpellSchool school) {
        int currentPoints = this.getSchoolPoints(school);
        int maxPoints = PerkTreeManager.getMaxPointsForSchool(school);
        return PerkTreeManager.convertPointsToPercentage(currentPoints, maxPoints);
    }

    public Map<SpellSchool, Float> getAllSchoolAffinities() {
        HashMap<SpellSchool, Float> affinities = new HashMap<SpellSchool, Float>();
        for (SpellSchool school : SUPPORTED_SCHOOLS) {
            affinities.put(school, Float.valueOf(this.getSchoolAffinityPercentage(school)));
        }
        return affinities;
    }

    public void addSchoolPoints(SpellSchool school, int points) {
        int maxPoints;
        int currentPoints = this.getSchoolPoints(school);
        int newTotalPoints = currentPoints + points;
        if (newTotalPoints > (maxPoints = PerkTreeManager.getMaxPointsForSchool(school)) && (points = maxPoints - currentPoints) <= 0) {
            ArsAffinity.LOGGER.debug("Cannot add points to {} school - already at maximum ({}/{})", (Object)school.getId(), (Object)currentPoints, (Object)maxPoints);
            return;
        }
        this.schoolPoints.put(school, currentPoints + points);
        this.updateAvailablePoints(school);
        this.markDirty();
        ArsAffinity.LOGGER.debug("Added {} points to {} school. Total: {}/{}", (Object)points, (Object)school.getId(), (Object)this.getSchoolPoints(school), (Object)maxPoints);
    }

    public void setSchoolPoints(SpellSchool school, int points) {
        if (points >= 0) {
            int maxPoints = PerkTreeManager.getMaxPointsForSchool(school);
            int cappedPoints = Math.min(points, maxPoints);
            this.schoolPoints.put(school, cappedPoints);
            this.updateAvailablePoints(school);
            this.markDirty();
            if (points > maxPoints) {
                ArsAffinity.LOGGER.debug("Capped {} school points from {} to maximum {}", (Object)school.getId(), (Object)points, (Object)maxPoints);
            }
        }
    }

    public void setSchoolPercentage(SpellSchool school, float percentage) {
        this.schoolPercentages.put(school, Float.valueOf(Math.max(0.0f, Math.min(100.0f, percentage))));
        this.markDirty();
    }

    public void resetSchoolPercentage(SpellSchool school) {
        this.schoolPercentages.put(school, Float.valueOf(0.0f));
        this.markDirty();
    }

    public void resetAllSchoolPercentages() {
        for (SpellSchool school : SUPPORTED_SCHOOLS) {
            this.schoolPercentages.put(school, Float.valueOf(0.0f));
        }
        this.markDirty();
    }

    public void addAvailablePoints(SpellSchool school, int points) {
        int currentAvailable = this.getAvailablePoints(school);
        this.availablePoints.put(school, currentAvailable + points);
        this.markDirty();
    }

    public void setDirty(boolean dirty) {
        this.isDirty = dirty;
    }

    public Map<String, PerkAllocation> getPerksForSchool(SpellSchool school) {
        HashMap<String, PerkAllocation> schoolPerks = new HashMap<String, PerkAllocation>();
        for (Map.Entry<String, PerkAllocation> entry : this.allocatedPerks.entrySet()) {
            if (!entry.getValue().getSchool().equals(school)) continue;
            schoolPerks.put(entry.getKey(), entry.getValue());
        }
        return schoolPerks;
    }

    private void updateAvailablePoints(SpellSchool school) {
        int totalPoints = this.getSchoolPoints(school);
        int allocatedPoints = this.getAllocatedPointsForSchool(school);
        this.availablePoints.put(school, Math.max(0, totalPoints - allocatedPoints));
    }

    private int getAllocatedPointsForSchool(SpellSchool school) {
        return this.allocatedPerks.values().stream().filter(allocation -> allocation.getSchool().equals(school)).mapToInt(PerkAllocation::getPointsInvested).sum();
    }

    public boolean canAllocatePerk(PerkNode node) {
        if (this.getAvailablePoints(node.getSchool()) < node.getPointCost()) {
            return false;
        }
        for (String prerequisiteId : node.getPrerequisites()) {
            if (this.unlockedNodes.contains(prerequisiteId)) continue;
            return false;
        }
        if (ActiveAbilityHelper.isActiveAbility(node.getPerkType()) && this.hasAnyActiveAbility()) {
            ArsAffinity.LOGGER.debug("Cannot allocate active ability {} - player already has an active ability", (Object)node.getPerkType());
            return false;
        }
        return true;
    }

    public boolean allocatePerk(PerkNode node) {
        if (!this.canAllocatePerk(node)) {
            return false;
        }
        String nodeId = node.getId();
        if (this.allocatedPerks.containsKey(nodeId)) {
            return false;
        }
        PerkAllocation allocation = new PerkAllocation(node);
        this.allocatedPerks.put(nodeId, allocation);
        this.unlockedNodes.add(nodeId);
        this.updateAvailablePoints(node.getSchool());
        this.markDirty();
        if (ActiveAbilityHelper.isActiveAbility(node.getPerkType())) {
            this.updateActiveAbilityData();
        }
        ArsAffinity.LOGGER.info("Allocated perk: {} for {} points", (Object)nodeId, (Object)node.getPointCost());
        return true;
    }

    public boolean deallocatePerk(String nodeId) {
        PerkAllocation allocation = this.allocatedPerks.get(nodeId);
        if (allocation == null) {
            return false;
        }
        for (PerkAllocation otherAllocation : this.allocatedPerks.values()) {
            if (!otherAllocation.getNode().getPrerequisites().contains(nodeId)) continue;
            ArsAffinity.LOGGER.warn("Cannot deallocate {} - other perks depend on it", (Object)nodeId);
            return false;
        }
        this.allocatedPerks.remove(nodeId);
        this.unlockedNodes.remove(nodeId);
        this.updateAvailablePoints(allocation.getSchool());
        this.markDirty();
        if (ActiveAbilityHelper.isActiveAbility(allocation.getPerkType())) {
            this.updateActiveAbilityData();
        }
        ArsAffinity.LOGGER.info("Deallocated perk: {}", (Object)nodeId);
        return true;
    }

    public boolean isPerkAllocated(String nodeId) {
        return this.allocatedPerks.containsKey(nodeId);
    }

    public PerkAllocation getAllocatedPerk(String nodeId) {
        return this.allocatedPerks.get(nodeId);
    }

    public Set<PerkAllocation> getAllAllocatedPerks() {
        return Set.copyOf(this.allocatedPerks.values());
    }

    public Set<PerkAllocation> getAllocatedPerksForSchool(SpellSchool school) {
        return this.allocatedPerks.values().stream().filter(allocation -> allocation.getSchool().equals(school)).collect(Collectors.toSet());
    }

    public boolean hasAnyActiveAbility() {
        return this.allocatedPerks.values().stream().anyMatch(allocation -> ActiveAbilityHelper.isActiveAbility(allocation.getPerkType()));
    }

    public AffinityPerkType getCurrentActiveAbilityType() {
        return this.allocatedPerks.values().stream().filter(allocation -> ActiveAbilityHelper.isActiveAbility(allocation.getPerkType())).findFirst().map(PerkAllocation::getPerkType).orElse(null);
    }

    public PerkAllocation getCurrentActiveAbilityAllocation() {
        return this.allocatedPerks.values().stream().filter(allocation -> ActiveAbilityHelper.isActiveAbility(allocation.getPerkType())).findFirst().orElse(null);
    }

    private void updateActiveAbilityData() {
        ActiveAbilityData activeAbilityData;
        if (this.player != null && (activeAbilityData = ActiveAbilityProvider.getActiveAbilityData(this.player)) != null) {
            AffinityPerkType currentType = this.getCurrentActiveAbilityType();
            activeAbilityData.setActiveAbilityType(currentType);
            ActiveAbilityProvider.savePlayerData(this.player);
        }
    }

    public boolean canRespec() {
        return true;
    }

    public void respecSchool(SpellSchool school) {
        if (!this.canRespec()) {
            return;
        }
        boolean hadActiveAbility = this.hasAnyActiveAbility();
        this.allocatedPerks.entrySet().removeIf(entry -> ((PerkAllocation)entry.getValue()).getSchool().equals(school));
        this.unlockedNodes.removeIf(nodeId -> nodeId.startsWith(school.getId().toString()));
        this.updateAvailablePoints(school);
        this.markDirty();
        if (hadActiveAbility) {
            this.updateActiveAbilityData();
        }
        ArsAffinity.LOGGER.info("Respeced {} school", (Object)school.getId());
    }

    public void respecAll() {
        if (!this.canRespec()) {
            return;
        }
        this.allocatedPerks.clear();
        this.unlockedNodes.clear();
        for (SpellSchool school : SUPPORTED_SCHOOLS) {
            this.updateAvailablePoints(school);
        }
        this.markDirty();
        this.updateActiveAbilityData();
        ArsAffinity.LOGGER.info("Respeced all schools");
    }

    public void migrateFromOldSystem(Map<SpellSchool, Float> oldAffinities) {
        ArsAffinity.LOGGER.info("Migrating from old affinity system...");
        for (Map.Entry<SpellSchool, Float> entry : oldAffinities.entrySet()) {
            SpellSchool school = entry.getKey();
            float oldAffinity = entry.getValue().floatValue();
            int points = this.convertAffinityToPoints(oldAffinity);
            this.schoolPoints.put(school, points);
            this.availablePoints.put(school, points);
            ArsAffinity.LOGGER.info("Migrated {}: {}% -> {} points", (Object)school.getId(), (Object)Float.valueOf(oldAffinity * 100.0f), (Object)points);
        }
        this.markDirty();
    }

    private int convertAffinityToPoints(float affinity) {
        double scalingFactor = 1.0 - Math.pow(affinity, 3.0);
        double minimumFactor = 0.1;
        double basePoints = 100.0;
        double scaledPoints = basePoints * Math.max(minimumFactor, scalingFactor);
        return (int)Math.round(scaledPoints);
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        CompoundTag schoolPointsTag = new CompoundTag();
        for (Map.Entry<SpellSchool, Integer> entry : this.schoolPoints.entrySet()) {
            String string = PlayerAffinityData.getShortSchoolId(entry.getKey());
            schoolPointsTag.putInt(string, entry.getValue().intValue());
        }
        tag.put("schoolPoints", (Tag)schoolPointsTag);
        CompoundTag schoolPercentagesTag = new CompoundTag();
        for (Map.Entry<SpellSchool, Float> entry : this.schoolPercentages.entrySet()) {
            String string = PlayerAffinityData.getShortSchoolId(entry.getKey());
            schoolPercentagesTag.putFloat(string, entry.getValue().floatValue());
        }
        tag.put("schoolPercentages", (Tag)schoolPercentagesTag);
        CompoundTag compoundTag = new CompoundTag();
        for (Map.Entry<SpellSchool, Integer> entry : this.availablePoints.entrySet()) {
            String schoolId = PlayerAffinityData.getShortSchoolId(entry.getKey());
            compoundTag.putInt(schoolId, entry.getValue().intValue());
        }
        tag.put("availablePoints", (Tag)compoundTag);
        ListTag listTag = new ListTag();
        for (PerkAllocation allocation : this.allocatedPerks.values()) {
            listTag.add((Object)allocation.serializeNBT());
        }
        tag.put("allocatedPerks", (Tag)listTag);
        ListTag listTag2 = new ListTag();
        for (String nodeId : this.unlockedNodes) {
            listTag2.add((Object)StringTag.valueOf((String)nodeId));
        }
        tag.put("unlockedNodes", (Tag)listTag2);
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag tag) {
        CompoundTag schoolPointsTag = tag.getCompound("schoolPoints");
        this.schoolPoints.clear();
        for (String string : schoolPointsTag.getAllKeys()) {
            SpellSchool school = PlayerAffinityData.getSpellSchoolFromId(string);
            if (school == null) continue;
            int points = schoolPointsTag.getInt(string);
            this.schoolPoints.put(school, points);
        }
        CompoundTag schoolPercentagesTag = tag.getCompound("schoolPercentages");
        this.schoolPercentages.clear();
        for (String key : schoolPercentagesTag.getAllKeys()) {
            SpellSchool school = PlayerAffinityData.getSpellSchoolFromId(key);
            if (school == null) continue;
            float percentage = schoolPercentagesTag.getFloat(key);
            this.schoolPercentages.put(school, Float.valueOf(percentage));
        }
        if (this.schoolPercentages.isEmpty()) {
            for (SpellSchool school : SUPPORTED_SCHOOLS) {
                this.schoolPercentages.put(school, Float.valueOf(0.0f));
            }
        }
        CompoundTag compoundTag = tag.getCompound("availablePoints");
        this.availablePoints.clear();
        for (String key : compoundTag.getAllKeys()) {
            SpellSchool school = PlayerAffinityData.getSpellSchoolFromId(key);
            if (school == null) continue;
            int points = compoundTag.getInt(key);
            this.availablePoints.put(school, points);
        }
        ListTag allocatedPerksTag = tag.getList("allocatedPerks", 10);
        this.allocatedPerks.clear();
        for (Tag perkTag : allocatedPerksTag) {
            if (!(perkTag instanceof CompoundTag)) continue;
            CompoundTag compoundTag2 = (CompoundTag)perkTag;
            PerkAllocation allocation = PerkAllocation.deserializeNBT(compoundTag2);
            if (allocation != null) {
                this.allocatedPerks.put(allocation.getNodeId(), allocation);
                continue;
            }
            ArsAffinity.LOGGER.warn("Failed to deserialize perk allocation, skipping");
        }
        ListTag unlockedNodesTag = tag.getList("unlockedNodes", 8);
        this.unlockedNodes.clear();
        for (Tag nodeTag : unlockedNodesTag) {
            if (!(nodeTag instanceof StringTag)) continue;
            StringTag stringTag = (StringTag)nodeTag;
            this.unlockedNodes.add(stringTag.getAsString());
        }
    }

    private static SpellSchool getSpellSchoolFromId(String id) {
        return switch (id) {
            case "fire" -> SpellSchools.ELEMENTAL_FIRE;
            case "water" -> SpellSchools.ELEMENTAL_WATER;
            case "earth" -> SpellSchools.ELEMENTAL_EARTH;
            case "air" -> SpellSchools.ELEMENTAL_AIR;
            case "abjuration" -> SpellSchools.ABJURATION;
            case "necromancy" -> SpellSchools.NECROMANCY;
            case "conjuration" -> SpellSchools.CONJURATION;
            case "manipulation" -> SpellSchools.MANIPULATION;
            default -> null;
        };
    }

    private static String getShortSchoolId(SpellSchool school) {
        String schoolId;
        return switch (schoolId = school.getId().toString()) {
            case "ars_nouveau:elemental_fire" -> "fire";
            case "ars_nouveau:elemental_water" -> "water";
            case "ars_nouveau:elemental_earth" -> "earth";
            case "ars_nouveau:elemental_air" -> "air";
            case "ars_nouveau:abjuration" -> "abjuration";
            case "ars_nouveau:necromancy" -> "necromancy";
            case "ars_nouveau:conjuration" -> "conjuration";
            case "ars_nouveau:manipulation" -> "manipulation";
            default -> schoolId;
        };
    }
}

