/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.appexp.me.strategy;

import appeng.api.behaviors.ExternalStorageStrategy;
import appeng.api.config.Actionable;
import appeng.api.networking.security.IActionSource;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.MEStorage;
import appeng.core.localization.GuiText;
import es.degrassi.appexp.me.key.ExperienceKey;
import es.degrassi.appexp.me.key.ExperienceKeyType;
import es.degrassi.experiencelib.api.capability.ExperienceLibCapabilities;
import es.degrassi.experiencelib.api.capability.IExperienceHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import org.jetbrains.annotations.Nullable;

public class ExperienceExternalStorageStrategy
implements ExternalStorageStrategy {
    private final BlockCapabilityCache<IExperienceHandler, Direction> cache;

    public ExperienceExternalStorageStrategy(ServerLevel level, BlockPos fromPos, Direction fromSide) {
        this.cache = BlockCapabilityCache.create((BlockCapability)ExperienceLibCapabilities.EXPERIENCE.block(), (ServerLevel)level, (BlockPos)fromPos, (Object)fromSide);
    }

    @Nullable
    public MEStorage createWrapper(boolean extractableOnly, Runnable injectOrExtractCallback) {
        IExperienceHandler handler = (IExperienceHandler)this.cache.getCapability();
        return handler != null ? new Adaptor(handler, injectOrExtractCallback) : null;
    }

    private record Adaptor(IExperienceHandler handler, Runnable injectOrExtractCallback) implements MEStorage
    {
        public long insert(AEKey what, long amount, Actionable mode, IActionSource source) {
            if (!(what instanceof ExperienceKey)) {
                return 0L;
            }
            long inserted = 0L;
            for (int i = 0; i < this.handler.getTanks() && amount > 0L; amount -= (inserted += this.handler.receiveExperience(i, amount, mode.isSimulate())), ++i) {
            }
            if (inserted > 0L && mode == Actionable.MODULATE) {
                this.injectOrExtractCallback.run();
            }
            return inserted;
        }

        public long extract(AEKey what, long amount, Actionable mode, IActionSource source) {
            if (!(what instanceof ExperienceKey)) {
                return 0L;
            }
            long extracted = 0L;
            for (int i = 0; i < this.handler.getTanks() && amount > 0L; amount -= (extracted += this.handler.extractExperience(i, amount, mode.isSimulate())), ++i) {
            }
            if (extracted > 0L && mode == Actionable.MODULATE) {
                this.injectOrExtractCallback.run();
            }
            return extracted;
        }

        public void getAvailableStacks(KeyCounter out) {
            long currentExperience = this.handler.getExperience();
            if (currentExperience != 0L) {
                out.add((AEKey)ExperienceKey.KEY, currentExperience);
            }
        }

        public Component getDescription() {
            return GuiText.ExternalStorage.text(new Object[]{ExperienceKeyType.TYPE.getDescription()});
        }
    }
}

