/*
 * Decompiled with CFR 0.152.
 */
package es.degrassi.appexp.me.cell;

import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.stacks.KeyCounter;
import appeng.api.storage.cells.ICellHandler;
import appeng.api.storage.cells.ISaveProvider;
import appeng.core.AEConfig;
import appeng.core.localization.Tooltips;
import appeng.items.storage.StorageCellTooltipComponent;
import es.degrassi.appexp.api.item.IExperienceCellItem;
import es.degrassi.appexp.me.cell.ExperienceCellInventory;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class ExperienceCellHandler
implements ICellHandler {
    public static final ExperienceCellHandler INSTANCE = new ExperienceCellHandler();

    private ExperienceCellHandler() {
    }

    public boolean isCell(ItemStack is) {
        return is != null && is.getItem() instanceof IExperienceCellItem;
    }

    @Nullable
    public ExperienceCellInventory getCellInventory(ItemStack is, @Nullable ISaveProvider container) {
        return this.isCell(is) ? new ExperienceCellInventory((IExperienceCellItem)is.getItem(), is, container) : null;
    }

    public void addCellInformationToTooltip(ItemStack is, List<Component> lines) {
        ExperienceCellInventory handler = this.getCellInventory(is, null);
        if (handler != null) {
            lines.add(Tooltips.bytesUsed((long)handler.getUsedBytes(), (long)handler.getTotalBytes()));
        }
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack is) {
        ExperienceCellInventory handler = this.getCellInventory(is, null);
        if (handler == null) {
            return Optional.empty();
        }
        ArrayList upgrades = new ArrayList();
        if (AEConfig.instance().isTooltipShowCellUpgrades()) {
            handler.getUpgrades().forEach(upgrades::add);
        }
        ArrayList content = new ArrayList();
        KeyCounter counter = new KeyCounter();
        handler.getAvailableStacks(counter);
        if (!counter.isEmpty()) {
            counter.forEach(entry -> content.add(new GenericStack((AEKey)entry.getKey(), entry.getLongValue())));
        }
        return Optional.of(new StorageCellTooltipComponent(upgrades, content, false, true));
    }
}

