/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.apothic_compats.data.mekanism;

import dev.shadowsoffire.apotheosis.data.AffixLootEntryProvider;
import dev.shadowsoffire.apotheosis.loot.AffixLootEntry;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.tiers.TieredWeights;
import dev.shadowsoffire.apotheosis.tiers.WorldTier;
import dev.shadowsoffire.placebo.codec.CodecProvider;
import ianm1647.apothic_compats.ApothicCompats;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import mekanism.tools.common.config.MekanismToolsConfig;
import mekanism.tools.common.registries.ToolsArmorMaterials;
import mekanism.tools.common.registries.ToolsItems;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.conditions.ICondition;
import net.neoforged.neoforge.common.conditions.ModLoadedCondition;

public class MekanismAffixLootProvider
extends AffixLootEntryProvider {
    String mod = "mekanismtools";
    public Map<Holder<ArmorMaterial>, TieredWeights> armorWeights = new HashMap<Holder<ArmorMaterial>, TieredWeights>();
    public Map<Tier, TieredWeights> toolWeights = new HashMap<Tier, TieredWeights>();
    public Map<Item, TieredWeights> itemWeights = new HashMap<Item, TieredWeights>();
    protected static final TieredWeights LAPIS = TieredWeights.builder().with(WorldTier.HAVEN, 10, 0.0f).with(WorldTier.FRONTIER, 10, 0.0f).with(WorldTier.ASCENT, 5, 0.0f).build();
    protected static final TieredWeights OSMIUM = TieredWeights.builder().with(WorldTier.FRONTIER, 5, 0.0f).with(WorldTier.ASCENT, 5, 0.0f).with(WorldTier.SUMMIT, 10, 0.0f).build();
    protected static final TieredWeights BRONZE = TieredWeights.builder().with(WorldTier.FRONTIER, 5, 0.0f).with(WorldTier.ASCENT, 10, 0.0f).with(WorldTier.SUMMIT, 10, 0.0f).build();
    protected static final TieredWeights STEEL = TieredWeights.builder().with(WorldTier.ASCENT, 5, 0.0f).with(WorldTier.SUMMIT, 10, 0.0f).build();
    protected static final TieredWeights GLOWSTONE = TieredWeights.builder().with(WorldTier.SUMMIT, 5, 0.0f).with(WorldTier.PINNACLE, 10, 0.0f).build();
    protected static final TieredWeights OBSIDIAN = TieredWeights.builder().with(WorldTier.SUMMIT, 2, 0.0f).with(WorldTier.PINNACLE, 5, 0.0f).build();

    public MekanismAffixLootProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    public void generate() {
        this.armorWeights.put((Holder<ArmorMaterial>)ToolsArmorMaterials.LAPIS_LAZULI, LAPIS);
        this.armorWeights.put((Holder<ArmorMaterial>)ToolsArmorMaterials.OSMIUM, OSMIUM);
        this.armorWeights.put((Holder<ArmorMaterial>)ToolsArmorMaterials.BRONZE, BRONZE);
        this.armorWeights.put((Holder<ArmorMaterial>)ToolsArmorMaterials.STEEL, STEEL);
        this.armorWeights.put((Holder<ArmorMaterial>)ToolsArmorMaterials.REFINED_GLOWSTONE, GLOWSTONE);
        this.armorWeights.put((Holder<ArmorMaterial>)ToolsArmorMaterials.REFINED_OBSIDIAN, OBSIDIAN);
        this.toolWeights.put((Tier)MekanismToolsConfig.materials.lapisLazuli, LAPIS);
        this.toolWeights.put((Tier)MekanismToolsConfig.materials.osmium, OSMIUM);
        this.toolWeights.put((Tier)MekanismToolsConfig.materials.bronze, BRONZE);
        this.toolWeights.put((Tier)MekanismToolsConfig.materials.steel, STEEL);
        this.toolWeights.put((Tier)MekanismToolsConfig.materials.refinedGlowstone, GLOWSTONE);
        this.toolWeights.put((Tier)MekanismToolsConfig.materials.refinedObsidian, OBSIDIAN);
        this.addEntry(new AffixLootEntry(LAPIS, ToolsItems.LAPIS_LAZULI_SHIELD.asStack()));
        this.addEntry(new AffixLootEntry(OSMIUM, ToolsItems.OSMIUM_SHIELD.asStack()));
        this.addEntry(new AffixLootEntry(BRONZE, ToolsItems.BRONZE_SHIELD.asStack()));
        this.addEntry(new AffixLootEntry(STEEL, ToolsItems.STEEL_SHIELD.asStack()));
        this.addEntry(new AffixLootEntry(GLOWSTONE, ToolsItems.REFINED_GLOWSTONE_SHIELD.asStack()));
        this.addEntry(new AffixLootEntry(OBSIDIAN, ToolsItems.REFINED_OBSIDIAN_SHIELD.asStack()));
        for (Item i : BuiltInRegistries.ITEM) {
            ArmorItem a;
            TieredWeights weights;
            LootCategory cat;
            if (!this.mod.equals(BuiltInRegistries.ITEM.getKey((Object)i).getNamespace()) || (cat = LootCategory.forItem((ItemStack)i.getDefaultInstance())).isNone()) continue;
            if (i instanceof TieredItem) {
                TieredItem t = (TieredItem)i;
                weights = this.toolWeights.get(t.getTier());
                if (weights == null) continue;
                this.addEntry(new AffixLootEntry(weights, new ItemStack((ItemLike)i)));
                continue;
            }
            if (!(i instanceof ArmorItem) || (a = (ArmorItem)i).getType() == ArmorItem.Type.BODY || (weights = this.armorWeights.get(a.getMaterial())) == null) continue;
            this.addEntry(new AffixLootEntry(weights, new ItemStack((ItemLike)i)));
        }
    }

    public String getName() {
        return "Mekanism Affix Loot Entries";
    }

    protected void addEntry(AffixLootEntry entry) {
        ResourceLocation key = ApothicCompats.loc(this.mod + "/" + BuiltInRegistries.ITEM.getKey((Object)entry.stack().getItem()).getPath());
        this.addConditionally(key, (CodecProvider)entry, new ICondition[]{new ModLoadedCondition(this.mod)});
    }
}

