/*
 * Decompiled with CFR 0.152.
 */
package ianm1647.apothic_compats.affix.malum;

import com.google.common.base.Predicate;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.apotheosis.AdventureConfig;
import dev.shadowsoffire.apotheosis.affix.Affix;
import dev.shadowsoffire.apotheosis.affix.AffixBuilder;
import dev.shadowsoffire.apotheosis.affix.AffixDefinition;
import dev.shadowsoffire.apotheosis.affix.AffixInstance;
import dev.shadowsoffire.apotheosis.loot.LootCategory;
import dev.shadowsoffire.apotheosis.loot.LootRarity;
import dev.shadowsoffire.apothic_attributes.ApothicAttributes;
import dev.shadowsoffire.placebo.util.StepFunction;
import ianm1647.apothic_compats.loot.ModLootCategories;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;
import org.spongepowered.include.com.google.common.base.Preconditions;

public class ScytheCleavingAffix
extends Affix {
    public static final Codec<ScytheCleavingAffix> CODEC = RecordCodecBuilder.create(inst -> inst.group(ScytheCleavingAffix.affixDef(), (App)LootRarity.mapCodec(CleaveValues.CODEC).fieldOf("values").forGetter(a -> a.values)).apply((Applicative)inst, ScytheCleavingAffix::new));
    protected final Map<LootRarity, CleaveValues> values;
    private static boolean cleaving = false;

    public ScytheCleavingAffix(AffixDefinition def, Map<LootRarity, CleaveValues> values) {
        super(def);
        this.values = values;
    }

    public boolean canApplyTo(ItemStack stack, LootCategory cat, LootRarity rarity) {
        return ModLootCategories.isScythe(cat) && this.values.containsKey(rarity);
    }

    public MutableComponent getDescription(AffixInstance inst, AttributeTooltipContext ctx) {
        return Component.translatable((String)("affix." + String.valueOf(this.id()) + ".desc"), (Object[])new Object[]{ScytheCleavingAffix.fmt((float)(100.0f * this.getChance(inst.getRarity(), inst.level()))), this.getTargets(inst.getRarity(), inst.level())});
    }

    public Component getAugmentingText(AffixInstance inst, AttributeTooltipContext ctx) {
        int maxTargets;
        int minTargets;
        float maxChance;
        MutableComponent comp = this.getDescription(inst, ctx);
        LootRarity rarity = inst.getRarity();
        float minChance = this.getChance(rarity, 0.0f);
        if (minChance != (maxChance = this.getChance(rarity, 1.0f))) {
            MutableComponent minComp = Component.translatable((String)"%s%%", (Object[])new Object[]{ScytheCleavingAffix.fmt((float)(100.0f * minChance))});
            MutableComponent maxComp = Component.translatable((String)"%s%%", (Object[])new Object[]{ScytheCleavingAffix.fmt((float)(100.0f * maxChance))});
            comp.append((Component)ScytheCleavingAffix.valueBounds((Component)minComp, (Component)maxComp));
        }
        if ((minTargets = this.getTargets(rarity, 0.0f)) != (maxTargets = this.getTargets(rarity, 1.0f))) {
            MutableComponent minComp = Component.literal((String)ScytheCleavingAffix.fmt((float)minTargets));
            MutableComponent maxComp = Component.literal((String)ScytheCleavingAffix.fmt((float)maxTargets));
            return comp.append((Component)ScytheCleavingAffix.valueBounds((Component)minComp, (Component)maxComp));
        }
        return comp;
    }

    private float getChance(LootRarity rarity, float level) {
        return this.values.get((Object)rarity).chance.get(level);
    }

    private int getTargets(LootRarity rarity, float level) {
        return this.values.get((Object)rarity).targets.getInt(level);
    }

    public void doPostAttack(AffixInstance inst, LivingEntity user, Entity target) {
        if ((double)ApothicAttributes.getLocalAtkStrength((Entity)user) >= 0.98 && !cleaving && !user.level().isClientSide) {
            cleaving = true;
            float chance = this.getChance(inst.getRarity(), inst.level());
            int targets = this.getTargets(inst.getRarity(), inst.level());
            if (user.level().random.nextFloat() < chance && user instanceof Player) {
                Player player = (Player)user;
                List nearby = target.level().getEntities(target, new AABB(target.blockPosition()).inflate(6.0), ScytheCleavingAffix.cleavePredicate((Entity)user, target));
                for (Entity e : nearby) {
                    if (targets <= 0) continue;
                    ((Player)user).getAttackStrengthScale(300.0f);
                    player.attack(e);
                    --targets;
                }
            }
            cleaving = false;
        }
    }

    public Codec<? extends Affix> getCodec() {
        return CODEC;
    }

    public static Predicate<Entity> cleavePredicate(Entity user, Entity target) {
        return e -> {
            LivingEntity le;
            if (e instanceof Animal && !(target instanceof Animal) || e instanceof AbstractVillager && !(target instanceof AbstractVillager)) {
                return false;
            }
            if (!AdventureConfig.cleaveHitsPlayers && e instanceof Player) {
                return false;
            }
            if (target instanceof Enemy && !(e instanceof Enemy)) {
                return false;
            }
            if (e != user && e instanceof LivingEntity && (le = (LivingEntity)e).isAlive()) {
                boolean var10000 = true;
                return var10000;
            }
            boolean var10000 = false;
            return var10000;
        };
    }

    record CleaveValues(StepFunction chance, StepFunction targets) {
        public static final Codec<CleaveValues> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)StepFunction.CODEC.fieldOf("chance").forGetter(c -> c.chance), (App)StepFunction.CODEC.fieldOf("targets").forGetter(c -> c.targets)).apply((Applicative)inst, CleaveValues::new));
    }

    public static class Builder
    extends AffixBuilder<Builder> {
        protected final Map<LootRarity, CleaveValues> values = new HashMap<LootRarity, CleaveValues>();

        public Builder value(LootRarity rarity, float minChance, float maxChance, int minTargets, int maxTargets) {
            StepFunction chance = StepFunction.fromBounds((float)minChance, (float)maxChance, (float)0.05f);
            StepFunction targets = StepFunction.fromBounds((float)minTargets, (float)maxTargets, (float)1.0f);
            this.values.put(rarity, new CleaveValues(chance, targets));
            return this;
        }

        public ScytheCleavingAffix build() {
            Preconditions.checkNotNull((Object)this.definition);
            Preconditions.checkArgument((this.values.size() > 0 ? 1 : 0) != 0);
            return new ScytheCleavingAffix(this.definition, this.values);
        }
    }
}

