/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.actuallyadditions.mod.tile;

import de.ellpeck.actuallyadditions.api.laser.Network;
import de.ellpeck.actuallyadditions.mod.blocks.ActuallyBlocks;
import de.ellpeck.actuallyadditions.mod.network.packet.SpawnLaserParticlePacket;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityBase;
import de.ellpeck.actuallyadditions.mod.tile.TileEntityLaserRelayItem;
import de.ellpeck.actuallyadditions.mod.util.WorldUtil;
import de.ellpeck.actuallyadditions.mod.util.compat.SlotlessableItemHandlerWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;

public class TileEntityItemInterface
extends TileEntityBase {
    public final List<GenericItemHandlerInfo> genericInfos = new ArrayList<GenericItemHandlerInfo>();
    public final Map<Integer, IItemHandlerInfo> itemHandlerInfos = new HashMap<Integer, IItemHandlerInfo>();
    public final List<SlotlessItemHandlerInfo> slotlessInfos = new ArrayList<SlotlessItemHandlerInfo>();
    protected final SlotlessableItemHandlerWrapper itemHandler;
    public TileEntityLaserRelayItem connectedRelay;
    private int lastNetworkChangeAmount = -1;
    private int slotCount;

    public TileEntityItemInterface(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        IItemHandler normalHandler = new IItemHandler(){

            public int getSlots() {
                return TileEntityItemInterface.this.getSlotCount();
            }

            @Nonnull
            public ItemStack getStackInSlot(int slot) {
                IItemHandlerInfo handler = TileEntityItemInterface.this.getSwitchedIndexHandler(slot);
                if (handler != null && handler.isLoaded()) {
                    return handler.handler.getStackInSlot(handler.switchedIndex);
                }
                return ItemStack.EMPTY;
            }

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
                IItemHandlerInfo info = TileEntityItemInterface.this.getSwitchedIndexHandler(slot);
                if (info != null && info.isLoaded() && TileEntityItemInterface.this.isWhitelisted(info, stack, false)) {
                    ItemStack remain = info.handler.insertItem(info.switchedIndex, stack, simulate);
                    if (!ItemStack.isSameItem((ItemStack)remain, (ItemStack)stack) && !simulate) {
                        TileEntityItemInterface.this.setChanged();
                        TileEntityItemInterface.this.doItemParticle(stack, info.relayInQuestion.getBlockPos(), TileEntityItemInterface.this.connectedRelay.getBlockPos());
                    }
                    return remain;
                }
                return stack;
            }

            @Nonnull
            public ItemStack extractItem(int slot, int amount, boolean simulate) {
                IItemHandlerInfo info;
                ItemStack stackIn = this.getStackInSlot(slot);
                if (!stackIn.isEmpty() && (info = TileEntityItemInterface.this.getSwitchedIndexHandler(slot)) != null && info.isLoaded() && TileEntityItemInterface.this.isWhitelisted(info, stackIn, true)) {
                    ItemStack extracted = info.handler.extractItem(info.switchedIndex, amount, simulate);
                    if (!extracted.isEmpty() && !simulate) {
                        TileEntityItemInterface.this.setChanged();
                        TileEntityItemInterface.this.doItemParticle(extracted, TileEntityItemInterface.this.connectedRelay.getBlockPos(), info.relayInQuestion.getBlockPos());
                    }
                    return extracted;
                }
                return ItemStack.EMPTY;
            }

            public int getSlotLimit(int slot) {
                IItemHandlerInfo info = TileEntityItemInterface.this.getSwitchedIndexHandler(slot);
                if (info != null && info.isLoaded()) {
                    return info.handler.getSlotLimit(info.switchedIndex);
                }
                return 0;
            }

            public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
                return true;
            }
        };
        Object slotlessHandler = null;
        this.itemHandler = new SlotlessableItemHandlerWrapper(normalHandler, slotlessHandler);
    }

    public TileEntityItemInterface(BlockPos pos, BlockState state) {
        this(ActuallyBlocks.ITEM_INTERFACE.getTileEntityType(), pos, state);
    }

    public static <T extends BlockEntity> void clientTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityItemInterface) {
            TileEntityItemInterface tile = (TileEntityItemInterface)t;
            tile.clientTick();
        }
    }

    public static <T extends BlockEntity> void serverTick(Level level, BlockPos pos, BlockState state, T t) {
        if (t instanceof TileEntityItemInterface) {
            TileEntityItemInterface tile = (TileEntityItemInterface)t;
            tile.serverTick();
        }
    }

    @Override
    public IItemHandler getItemHandler(Direction facing) {
        return this.itemHandler.getNormalHandler();
    }

    private int getSlotCount() {
        this.queryAndSaveData();
        return this.slotCount;
    }

    public void doItemParticle(ItemStack stack, BlockPos input, BlockPos output) {
        if (!this.level.isClientSide) {
            int rangeSq = 256;
            for (Player player : this.level.players()) {
                if (!(player instanceof ServerPlayer)) continue;
                ServerPlayer serverPlayer = (ServerPlayer)player;
                if (!(player.distanceToSqr((double)input.getX(), (double)input.getY(), (double)input.getZ()) <= (double)rangeSq) && !(player.distanceToSqr((double)output.getX(), (double)output.getY(), (double)output.getZ()) <= (double)rangeSq)) continue;
                serverPlayer.connection.send((CustomPacketPayload)new SpawnLaserParticlePacket(stack, input, output));
            }
        }
    }

    private void queryAndSaveData() {
        Network network;
        if (this.connectedRelay != null && (network = this.connectedRelay.getNetwork()) != null) {
            if (this.lastNetworkChangeAmount != network.changeAmount) {
                this.clearInfos();
                this.connectedRelay.getItemHandlersInNetwork(network, this.genericInfos);
                if (!this.genericInfos.isEmpty()) {
                    Collections.sort(this.genericInfos);
                    int slotsQueried = 0;
                    for (GenericItemHandlerInfo info : this.genericInfos) {
                        if (!info.isLoaded()) continue;
                        for (SlotlessableItemHandlerWrapper handler : info.handlers) {
                            IItemHandler normalHandler = handler.getNormalHandler();
                            if (normalHandler == null) continue;
                            for (int i = 0; i < normalHandler.getSlots(); ++i) {
                                this.itemHandlerInfos.put(slotsQueried, new IItemHandlerInfo(normalHandler, i, info.relayInQuestion));
                                ++slotsQueried;
                            }
                        }
                    }
                    this.slotCount = slotsQueried;
                }
                this.lastNetworkChangeAmount = network.changeAmount;
            }
            return;
        }
        this.clearInfos();
        this.lastNetworkChangeAmount = -1;
    }

    private void clearInfos() {
        if (!this.genericInfos.isEmpty()) {
            this.genericInfos.clear();
        }
        if (!this.itemHandlerInfos.isEmpty()) {
            this.itemHandlerInfos.clear();
        }
        if (!this.slotlessInfos.isEmpty()) {
            this.slotlessInfos.clear();
        }
    }

    private IItemHandlerInfo getSwitchedIndexHandler(int i) {
        this.queryAndSaveData();
        return this.itemHandlerInfos.get(i);
    }

    @Override
    public boolean shouldSaveDataOnChangeOrWorldStart() {
        return true;
    }

    @Override
    public void saveDataOnChangeOrWorldStart() {
        TileEntityLaserRelayItem tileFound = null;
        if (this.level != null) {
            for (int i = 0; i <= 5; ++i) {
                BlockEntity tile;
                Direction side = WorldUtil.getDirectionBySidesInOrder(i);
                BlockPos pos = this.getBlockPos().relative(side);
                if (!this.level.isLoaded(pos) || !((tile = this.level.getBlockEntity(pos)) instanceof TileEntityLaserRelayItem)) continue;
                if (tileFound != null) {
                    this.connectedRelay = null;
                    return;
                }
                tileFound = (TileEntityLaserRelayItem)tile;
            }
        }
        this.connectedRelay = tileFound;
    }

    public boolean isWhitelisted(SpecificItemHandlerInfo handler, ItemStack stack, boolean output) {
        boolean whitelisted = handler.relayInQuestion.isWhitelisted(stack, output);
        TileEntityLaserRelayItem connected = this.connectedRelay;
        if (connected != null && connected != handler.relayInQuestion) {
            return whitelisted && connected.isWhitelisted(stack, output);
        }
        return whitelisted;
    }

    public static class GenericItemHandlerInfo
    implements Comparable<GenericItemHandlerInfo> {
        public final List<SlotlessableItemHandlerWrapper> handlers = new ArrayList<SlotlessableItemHandlerWrapper>();
        public final TileEntityLaserRelayItem relayInQuestion;

        public GenericItemHandlerInfo(TileEntityLaserRelayItem relayInQuestion) {
            this.relayInQuestion = relayInQuestion;
        }

        public boolean isLoaded() {
            return this.relayInQuestion.hasLevel() && this.relayInQuestion.getLevel().isLoaded(this.relayInQuestion.getBlockPos());
        }

        @Override
        public int compareTo(GenericItemHandlerInfo other) {
            int otherPrio;
            int thisPrio = this.relayInQuestion.getPriority();
            if (thisPrio == (otherPrio = other.relayInQuestion.getPriority())) {
                return 0;
            }
            if (thisPrio > otherPrio) {
                return -1;
            }
            return 1;
        }
    }

    public static class IItemHandlerInfo
    extends SpecificItemHandlerInfo {
        public final IItemHandler handler;
        public final int switchedIndex;

        public IItemHandlerInfo(IItemHandler handler, int switchedIndex, TileEntityLaserRelayItem relayInQuestion) {
            super(relayInQuestion);
            this.handler = handler;
            this.switchedIndex = switchedIndex;
        }
    }

    public static class SpecificItemHandlerInfo {
        public final TileEntityLaserRelayItem relayInQuestion;

        public SpecificItemHandlerInfo(TileEntityLaserRelayItem relayInQuestion) {
            this.relayInQuestion = relayInQuestion;
        }

        public boolean isLoaded() {
            return this.relayInQuestion.hasLevel() && this.relayInQuestion.getLevel().isLoaded(this.relayInQuestion.getBlockPos());
        }
    }

    public static class SlotlessItemHandlerInfo
    extends SpecificItemHandlerInfo {
        public final Object handler;

        public SlotlessItemHandlerInfo(Object handler, TileEntityLaserRelayItem relayInQuestion) {
            super(relayInQuestion);
            this.handler = handler;
        }
    }
}

