/*
 * Decompiled with CFR 0.152.
 */
package dev.aaronhowser.mods.aaron;

import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u000b\u001a\u00020\u0005*\u00020\fJ\n\u0010\r\u001a\u00020\u000e*\u00020\u000fJ\n\u0010\u0010\u001a\u00020\u000e*\u00020\u0011J\u001a\u0010\u0012\u001a\u00020\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0013J\u001a\u0010\u0012\u001a\u00020\u0017*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00172\u0006\u0010\u0016\u001a\u00020\u0017J\u001a\u0010\u0012\u001a\u00020\u0018*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0018J\u0012\u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0012\u0010\u0019\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000eJ\u0012\u0010\u001e\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u0012\u0010\u001e\u001a\u00020\u001a*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u000eJ\u0011\u0010\u001f\u001a\u00020\u0005*\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010 J\u0011\u0010!\u001a\u00020\u0005*\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010 J\n\u0010\"\u001a\u00020#*\u00020$J\u0010\u0010\"\u001a\u00020#*\b\u0012\u0004\u0012\u00020&0%J\u0012\u0010'\u001a\u00020\u0005*\u00020\u00142\u0006\u0010'\u001a\u00020(J+\u0010)\u001a\u00020\f\"\u0004\b\u0000\u0010**\u00020$2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H*0,2\u0006\u0010-\u001a\u0002H*\u00a2\u0006\u0002\u0010.J+\u0010)\u001a\u00020\f\"\u0004\b\u0000\u0010**\u00020\f2\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H*0,2\u0006\u0010-\u001a\u0002H*\u00a2\u0006\u0002\u0010/J\u0014\u00100\u001a\u0004\u0018\u000101*\u0002022\u0006\u00103\u001a\u00020\u000eJ\n\u00104\u001a\u000205*\u000206J\u0017\u00107\u001a\u0002H*\"\u0004\b\u0000\u0010**\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u00108R\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0007R\u0015\u0010\b\u001a\u00020\u0005*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\nR\u0015\u0010\u0004\u001a\u00020\u0005*\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\n\u00a8\u00069"}, d2={"Ldev/aaronhowser/mods/aaron/AaronExtensions;", "", "<init>", "()V", "isServerSide", "", "Lnet/minecraft/world/level/Level;", "(Lnet/minecraft/world/level/Level;)Z", "isClientSide", "Lnet/minecraft/world/entity/Entity;", "(Lnet/minecraft/world/entity/Entity;)Z", "isNotEmpty", "Lnet/minecraft/world/item/ItemStack;", "getDyeName", "", "Lnet/minecraft/world/item/DyeColor;", "getDirectionName", "Lnet/minecraft/core/Direction;", "nextRange", "", "Lnet/minecraft/util/RandomSource;", "min", "max", "", "", "status", "", "Lnet/minecraft/world/entity/player/Player;", "message", "Lnet/minecraft/network/chat/Component;", "tell", "isTrue", "(Ljava/lang/Boolean;)Z", "isNotTrue", "asIngredient", "Lnet/minecraft/world/item/crafting/Ingredient;", "Lnet/minecraft/world/level/ItemLike;", "Lnet/minecraft/tags/TagKey;", "Lnet/minecraft/world/item/Item;", "chance", "", "withComponent", "T", "componentType", "Lnet/minecraft/core/component/DataComponentType;", "component", "(Lnet/minecraft/world/level/ItemLike;Lnet/minecraft/core/component/DataComponentType;Ljava/lang/Object;)Lnet/minecraft/world/item/ItemStack;", "(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/core/component/DataComponentType;Ljava/lang/Object;)Lnet/minecraft/world/item/ItemStack;", "getUuidOrNull", "Ljava/util/UUID;", "Lnet/minecraft/nbt/CompoundTag;", "key", "toVec3", "Lnet/minecraft/world/phys/Vec3;", "Lnet/minecraft/core/Vec3i;", "cast", "(Ljava/lang/Object;)Ljava/lang/Object;", "aaron-1.21.1"})
public final class AaronExtensions {
    @NotNull
    public static final AaronExtensions INSTANCE = new AaronExtensions();

    private AaronExtensions() {
    }

    public final boolean isServerSide(@NotNull Level $this$isServerSide) {
        Intrinsics.checkNotNullParameter((Object)$this$isServerSide, (String)"<this>");
        return !$this$isServerSide.isClientSide;
    }

    public final boolean isClientSide(@NotNull Entity $this$isClientSide) {
        Intrinsics.checkNotNullParameter((Object)$this$isClientSide, (String)"<this>");
        return $this$isClientSide.level().isClientSide;
    }

    public final boolean isServerSide(@NotNull Entity $this$isServerSide) {
        Intrinsics.checkNotNullParameter((Object)$this$isServerSide, (String)"<this>");
        Level level = $this$isServerSide.level();
        Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
        return this.isServerSide(level);
    }

    public final boolean isNotEmpty(@NotNull ItemStack $this$isNotEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isNotEmpty, (String)"<this>");
        return !$this$isNotEmpty.isEmpty();
    }

    @NotNull
    public final String getDyeName(@NotNull DyeColor $this$getDyeName) {
        Intrinsics.checkNotNullParameter((Object)$this$getDyeName, (String)"<this>");
        String string = $this$getDyeName.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    @NotNull
    public final String getDirectionName(@NotNull Direction $this$getDirectionName) {
        Intrinsics.checkNotNullParameter((Object)$this$getDirectionName, (String)"<this>");
        String string = $this$getDirectionName.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        return string;
    }

    public final float nextRange(@NotNull RandomSource $this$nextRange, float min, float max) {
        Intrinsics.checkNotNullParameter((Object)$this$nextRange, (String)"<this>");
        return Mth.lerp((float)$this$nextRange.nextFloat(), (float)min, (float)max);
    }

    public final double nextRange(@NotNull RandomSource $this$nextRange, double min, double max) {
        Intrinsics.checkNotNullParameter((Object)$this$nextRange, (String)"<this>");
        return Mth.lerp((double)$this$nextRange.nextDouble(), (double)min, (double)max);
    }

    public final int nextRange(@NotNull RandomSource $this$nextRange, int min, int max) {
        Intrinsics.checkNotNullParameter((Object)$this$nextRange, (String)"<this>");
        return $this$nextRange.nextInt(max - min) + min;
    }

    public final void status(@NotNull Player $this$status, @NotNull Component message) {
        Intrinsics.checkNotNullParameter((Object)$this$status, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        $this$status.displayClientMessage(message, true);
    }

    public final void status(@NotNull Player $this$status, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)$this$status, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        MutableComponent mutableComponent = Component.literal((String)message);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
        this.status($this$status, (Component)mutableComponent);
    }

    public final void tell(@NotNull Player $this$tell, @NotNull Component message) {
        Intrinsics.checkNotNullParameter((Object)$this$tell, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        $this$tell.displayClientMessage(message, false);
    }

    public final void tell(@NotNull Player $this$tell, @NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)$this$tell, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        MutableComponent mutableComponent = Component.literal((String)message);
        Intrinsics.checkNotNullExpressionValue((Object)mutableComponent, (String)"literal(...)");
        this.tell($this$tell, (Component)mutableComponent);
    }

    public final boolean isTrue(@Nullable Boolean $this$isTrue) {
        return Intrinsics.areEqual((Object)$this$isTrue, (Object)true);
    }

    public final boolean isNotTrue(@Nullable Boolean $this$isNotTrue) {
        return !Intrinsics.areEqual((Object)$this$isNotTrue, (Object)true);
    }

    @NotNull
    public final Ingredient asIngredient(@NotNull ItemLike $this$asIngredient) {
        Intrinsics.checkNotNullParameter((Object)$this$asIngredient, (String)"<this>");
        ItemLike[] itemLikeArray = new ItemLike[]{$this$asIngredient};
        Ingredient ingredient = Ingredient.of((ItemLike[])itemLikeArray);
        Intrinsics.checkNotNullExpressionValue((Object)ingredient, (String)"of(...)");
        return ingredient;
    }

    @NotNull
    public final Ingredient asIngredient(@NotNull TagKey<Item> $this$asIngredient) {
        Intrinsics.checkNotNullParameter($this$asIngredient, (String)"<this>");
        Ingredient ingredient = Ingredient.of($this$asIngredient);
        Intrinsics.checkNotNullExpressionValue((Object)ingredient, (String)"of(...)");
        return ingredient;
    }

    public final boolean chance(@NotNull RandomSource $this$chance, @NotNull Number chance) {
        Intrinsics.checkNotNullParameter((Object)$this$chance, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)chance, (String)"chance");
        return $this$chance.nextDouble() <= chance.doubleValue();
    }

    @NotNull
    public final <T> ItemStack withComponent(@NotNull ItemLike $this$withComponent, @NotNull DataComponentType<T> componentType, T component) {
        Intrinsics.checkNotNullParameter((Object)$this$withComponent, (String)"<this>");
        Intrinsics.checkNotNullParameter(componentType, (String)"componentType");
        ItemStack stack = $this$withComponent.asItem().getDefaultInstance();
        stack.set(componentType, component);
        Intrinsics.checkNotNull((Object)stack);
        return stack;
    }

    @NotNull
    public final <T> ItemStack withComponent(@NotNull ItemStack $this$withComponent, @NotNull DataComponentType<T> componentType, T component) {
        Intrinsics.checkNotNullParameter((Object)$this$withComponent, (String)"<this>");
        Intrinsics.checkNotNullParameter(componentType, (String)"componentType");
        $this$withComponent.set(componentType, component);
        return $this$withComponent;
    }

    @Nullable
    public final UUID getUuidOrNull(@NotNull CompoundTag $this$getUuidOrNull, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)$this$getUuidOrNull, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return $this$getUuidOrNull.hasUUID(key) ? $this$getUuidOrNull.getUUID(key) : null;
    }

    @NotNull
    public final Vec3 toVec3(@NotNull Vec3i $this$toVec3) {
        Intrinsics.checkNotNullParameter((Object)$this$toVec3, (String)"<this>");
        return new Vec3((double)$this$toVec3.getX(), (double)$this$toVec3.getY(), (double)$this$toVec3.getZ());
    }

    public final <T> T cast(@Nullable Object $this$cast) {
        return (T)$this$cast;
    }
}

