/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.toolbelt.slot;

import dev.gigaherz.toolbelt.ToolBelt;
import dev.gigaherz.toolbelt.slot.BeltAttachment;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class BeltSlot
extends Slot {
    public static final ResourceLocation SLOT_BACKGROUND = ToolBelt.location("gui/empty_belt_slot_background");
    private static Container emptyInventory = new SimpleContainer(0);
    private final BeltAttachment slot;

    public BeltSlot(BeltAttachment slot, int x, int y) {
        super(emptyInventory, 0, x, y);
        this.slot = slot;
        this.setBackground(InventoryMenu.BLOCK_ATLAS, SLOT_BACKGROUND);
    }

    public boolean mayPlace(@Nonnull ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        return this.slot.canEquip(stack);
    }

    @Nonnull
    public ItemStack getItem() {
        return this.slot.getContents();
    }

    public void set(@Nonnull ItemStack stack) {
        this.slot.setContents(stack);
        this.setChanged();
    }

    public void onQuickCraft(@Nonnull ItemStack oldStackIn, @Nonnull ItemStack newStackIn) {
    }

    public int getMaxStackSize() {
        return 1;
    }

    public int getMaxStackSize(@Nonnull ItemStack stack) {
        return 1;
    }

    public boolean mayPickup(Player playerIn) {
        return this.slot.canUnequip();
    }

    @Nonnull
    public ItemStack remove(int amount) {
        ItemStack itemstack = this.slot.getContents();
        int available = Math.min(itemstack.getCount(), amount);
        int remaining = itemstack.getCount() - available;
        ItemStack split = itemstack.copy();
        split.setCount(available);
        itemstack.setCount(remaining);
        if (remaining <= 0) {
            this.slot.setContents(ItemStack.EMPTY);
        }
        this.setChanged();
        return split;
    }

    public BeltAttachment getExtensionSlot() {
        return this.slot;
    }

    public boolean isSameInventory(Slot other) {
        return other instanceof BeltSlot && ((BeltSlot)other).getExtensionSlot() == this.slot;
    }
}

