/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.replication.item;

import com.buuz135.replication.ReplicationAttachments;
import com.buuz135.replication.api.pattern.IMatterPatternModifier;
import com.buuz135.replication.block.tile.ChipStorageBlockEntity;
import com.buuz135.replication.item.ReplicationItem;
import com.hrznstudio.titanium.item.BasicItem;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.Nullable;

public class MatterBluePrintItem
extends ReplicationItem {
    public MatterBluePrintItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public boolean hasTooltipDetails(@Nullable BasicItem.Key key) {
        return key == null;
    }

    public void addTooltipDetails(@Nullable BasicItem.Key key, ItemStack stack, List<Component> tooltip, boolean advanced) {
        super.addTooltipDetails(key, stack, tooltip, advanced);
        if (key == null) {
            if (stack.has(ReplicationAttachments.BLUEPRINT)) {
                ItemStack item = ItemStack.parseOptional((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), (CompoundTag)((CompoundTag)stack.get(ReplicationAttachments.BLUEPRINT)).getCompound("Item"));
                double progress = ((CompoundTag)stack.get(ReplicationAttachments.BLUEPRINT)).getDouble("Progress");
                tooltip.add((Component)Component.literal((String)"").append((Component)Component.translatable((String)"relocation.blueprint.contains_information").withStyle(ChatFormatting.GOLD)).append((Component)Component.literal((String)new DecimalFormat("##.##").format(progress * 100.0)).withStyle(ChatFormatting.WHITE)).append((Component)Component.literal((String)"% ").withStyle(ChatFormatting.DARK_AQUA)).append(item.getHoverName()));
            } else {
                tooltip.add((Component)Component.translatable((String)"relocation.blueprint.not_found").withStyle(ChatFormatting.GRAY));
            }
            tooltip.add((Component)Component.empty());
            tooltip.add((Component)Component.translatable((String)"relocation.blueprint.use_on_chip_storage").withStyle(ChatFormatting.GRAY));
        }
    }

    public InteractionResult useOn(UseOnContext pContext) {
        if (pContext.getItemInHand().has(ReplicationAttachments.BLUEPRINT)) {
            ItemStack item = ItemStack.parseOptional((HolderLookup.Provider)pContext.getPlayer().level().registryAccess(), (CompoundTag)((CompoundTag)pContext.getItemInHand().get(ReplicationAttachments.BLUEPRINT)).getCompound("Item"));
            BlockEntity tile = pContext.getLevel().getBlockEntity(pContext.getClickedPos());
            if (tile instanceof ChipStorageBlockEntity) {
                ChipStorageBlockEntity chipStorageBlockEntity = (ChipStorageBlockEntity)tile;
                for (int i = 0; i < chipStorageBlockEntity.getChips().getSlots(); ++i) {
                    IMatterPatternModifier patternModifier;
                    IMatterPatternModifier.ModifierAction returnedValue;
                    Item item2;
                    ItemStack stack = chipStorageBlockEntity.getChips().getStackInSlot(i);
                    if (stack.isEmpty() || !((item2 = stack.getItem()) instanceof IMatterPatternModifier) || (returnedValue = (patternModifier = (IMatterPatternModifier)item2).addPattern(pContext.getLevel(), stack, item, (float)((CompoundTag)pContext.getItemInHand().get(ReplicationAttachments.BLUEPRINT)).getDouble("Progress"))).getPattern() == null) continue;
                    pContext.getItemInHand().shrink(1);
                    chipStorageBlockEntity.cachePatterns();
                    return InteractionResult.CONSUME;
                }
            }
        }
        return super.useOn(pContext);
    }
}

