/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.data;

import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.registries.DeferredHolder;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.psi.api.recipe.TrickRecipeBuilder;
import vazkii.psi.common.Psi;
import vazkii.psi.common.block.base.ModBlocks;
import vazkii.psi.common.crafting.ModCraftingRecipes;
import vazkii.psi.common.crafting.recipe.AssemblyScavengeRecipe;
import vazkii.psi.common.crafting.recipe.BulletToDriveRecipe;
import vazkii.psi.common.crafting.recipe.BulletUpgradeRecipe;
import vazkii.psi.common.crafting.recipe.ColorizerChangeRecipe;
import vazkii.psi.common.crafting.recipe.DriveDuplicateRecipe;
import vazkii.psi.common.crafting.recipe.SensorAttachRecipe;
import vazkii.psi.common.crafting.recipe.SensorRemoveRecipe;
import vazkii.psi.common.item.base.ModItems;
import vazkii.psi.common.lib.LibResources;
import vazkii.psi.common.lib.ModTags;

public class PsiRecipeGenerator
extends RecipeProvider {
    public PsiRecipeGenerator(PackOutput pOutput, CompletableFuture<HolderLookup.Provider> pRegistries) {
        super(pOutput, pRegistries);
    }

    protected <R extends Recipe<?>> void specialRecipe(RecipeOutput recipeOutput, DeferredHolder<RecipeType<?>, RecipeType<R>> type, Function<CraftingBookCategory, Recipe<?>> factory) {
        Recipe<?> recipe = factory.apply(CraftingBookCategory.MISC);
        ResourceLocation id = type.getId();
        recipeOutput.accept(ResourceLocation.fromNamespaceAndPath((String)id.getNamespace(), (String)("dynamic/" + id.getPath())), recipe, null);
    }

    protected void buildRecipes(RecipeOutput consumer) {
        this.specialRecipe(consumer, ModCraftingRecipes.SCAVENGE_TYPE, AssemblyScavengeRecipe::new);
        this.specialRecipe(consumer, ModCraftingRecipes.BULLET_TO_DRIVE_TYPE, BulletToDriveRecipe::new);
        this.specialRecipe(consumer, ModCraftingRecipes.COLORIZER_CHANGE_TYPE, ColorizerChangeRecipe::new);
        this.specialRecipe(consumer, ModCraftingRecipes.DRIVE_DUPLICATE_TYPE, DriveDuplicateRecipe::new);
        this.specialRecipe(consumer, ModCraftingRecipes.SENSOR_ATTACH_TYPE, SensorAttachRecipe::new);
        this.specialRecipe(consumer, ModCraftingRecipes.SENSOR_REMOVE_TYPE, SensorRemoveRecipe::new);
        Criterion hasIron = PsiRecipeGenerator.has((TagKey)Tags.Items.INGOTS_IRON);
        Criterion hasPsimetal = PsiRecipeGenerator.has(ModTags.INGOT_PSIMETAL);
        Criterion hasEbonyPsimetal = PsiRecipeGenerator.has(ModTags.INGOT_EBONY_PSIMETAL);
        Criterion hasIvoryPsimetal = PsiRecipeGenerator.has(ModTags.INGOT_IVORY_PSIMETAL);
        Criterion hasPsidust = PsiRecipeGenerator.has(ModTags.PSIDUST);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.cadAssembler.get())).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('P'), (ItemLike)Items.PISTON).pattern("IPI").pattern("I I").pattern(" I ").unlockedBy("has_iron", hasIron).save(consumer, Psi.location("assembler"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModBlocks.programmer.get())).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('D'), ModTags.PSIDUST).pattern("IDI").pattern("I I").pattern(" I ").unlockedBy("has_psidust", hasPsidust).save(consumer, Psi.location("programmer"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.ebonyPsimetal.get())).define(Character.valueOf('S'), ModTags.EBONY_SUBSTANCE).define(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).pattern("SSS").pattern("SIS").pattern("SSS").unlockedBy("has_ebony_substance", PsiRecipeGenerator.has((ItemLike)((ItemLike)ModItems.ebonySubstance.get()))).save(consumer, Psi.location("ebony_psimetal"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.ivoryPsimetal.get())).define(Character.valueOf('S'), ModTags.IVORY_SUBSTANCE).define(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).pattern("SSS").pattern("SIS").pattern("SSS").unlockedBy("has_ivory_substance", PsiRecipeGenerator.has((ItemLike)((ItemLike)ModItems.ivorySubstance.get()))).save(consumer, Psi.location("ivory_psimetal"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.cadAssemblyIron.get())).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).pattern("III").pattern("I  ").unlockedBy("has_iron", hasIron).save(consumer, Psi.location("cad_assembly_iron"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.cadAssemblyGold.get())).define(Character.valueOf('I'), Tags.Items.INGOTS_GOLD).pattern("III").pattern("I  ").unlockedBy("has_gold", PsiRecipeGenerator.has((TagKey)Tags.Items.INGOTS_GOLD)).save(consumer, Psi.location("cad_assembly_gold"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.cadAssemblyPsimetal.get())).define(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).pattern("III").pattern("I  ").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("cad_assembly_psimetal"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.cadAssemblyEbony.get())).define(Character.valueOf('I'), ModTags.INGOT_EBONY_PSIMETAL).pattern("III").pattern("I  ").unlockedBy("has_ebony_psimetal", hasEbonyPsimetal).save(consumer, Psi.location("cad_assembly_ebony"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.cadAssemblyIvory.get())).define(Character.valueOf('I'), ModTags.INGOT_IVORY_PSIMETAL).pattern("III").pattern("I  ").unlockedBy("has_ivory_psimetal", hasIvoryPsimetal).save(consumer, Psi.location("cad_assembly_ivory"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.cadCoreBasic.get())).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('D'), ModTags.PSIDUST).pattern(" I ").pattern("IDI").pattern(" I ").unlockedBy("has_psidust", hasPsidust).save(consumer, Psi.location("cad_core_basic"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.cadCoreOverclocked.get())).define(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).define(Character.valueOf('D'), Tags.Items.DUSTS_REDSTONE).pattern(" I ").pattern("IDI").pattern(" I ").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("cad_core_overclocked"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.cadCoreConductive.get())).define(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).define(Character.valueOf('D'), Tags.Items.DUSTS_GLOWSTONE).pattern(" I ").pattern("IDI").pattern(" I ").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("cad_core_conductive"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.cadCoreHyperClocked.get())).define(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).define(Character.valueOf('D'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('G'), ModTags.GEM_PSIGEM).pattern(" G ").pattern("IDI").pattern(" G ").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("cad_core_hyperclocked"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.cadCoreRadiative.get())).define(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).define(Character.valueOf('D'), Tags.Items.DUSTS_GLOWSTONE).define(Character.valueOf('G'), ModTags.GEM_PSIGEM).pattern(" G ").pattern("IDI").pattern(" G ").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("cad_core_radiative"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.cadSocketBasic.get())).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('D'), ModTags.PSIDUST).pattern("DI ").pattern("I  ").unlockedBy("has_psidust", hasPsidust).save(consumer, Psi.location("cad_socket_basic"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.cadSocketSignaling.get())).define(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).define(Character.valueOf('D'), Tags.Items.DUSTS_REDSTONE).pattern("DI ").pattern("I  ").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("cad_socket_signaling"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.cadSocketLarge.get())).define(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).define(Character.valueOf('D'), Tags.Items.DUSTS_GLOWSTONE).pattern("DI ").pattern("I  ").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("cad_socket_large"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.cadSocketTransmissive.get())).define(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).define(Character.valueOf('D'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('G'), ModTags.GEM_PSIGEM).pattern("DI ").pattern("IG ").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("cad_socket_transmissive"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.cadSocketHuge.get())).define(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).define(Character.valueOf('D'), Tags.Items.DUSTS_GLOWSTONE).define(Character.valueOf('G'), ModTags.GEM_PSIGEM).pattern("DI ").pattern("IG ").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("cad_socket_huge"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.cadBatteryBasic.get())).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('D'), ModTags.PSIDUST).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).pattern("I").pattern("D").pattern("G").unlockedBy("has_psidust", hasPsidust).save(consumer, Psi.location("cad_battery_basic"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.cadBatteryExtended.get())).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('D'), ModTags.INGOT_PSIMETAL).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).pattern("I").pattern("D").pattern("G").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("cad_battery_extended"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.cadBatteryUltradense.get())).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('D'), ModTags.GEM_PSIGEM).define(Character.valueOf('G'), Tags.Items.INGOTS_GOLD).pattern("I").pattern("D").pattern("G").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("cad_battery_ultradense"));
        for (DyeColor color : DyeColor.values()) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)BuiltInRegistries.ITEM.get(Psi.location("cad_colorizer_" + color.getSerializedName())))).group("psi:colorizer").define(Character.valueOf('D'), ModTags.PSIDUST).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).define(Character.valueOf('C'), color.getTag()).pattern(" D ").pattern("GCG").pattern(" I ").unlockedBy("has_psidust", hasPsidust).save(consumer, Psi.location("cad_colorizer_" + color.getSerializedName()));
        }
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.cadColorizerRainbow.get())).group("psi:colorizer").define(Character.valueOf('D'), ModTags.PSIDUST).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).define(Character.valueOf('C'), Tags.Items.GEMS_PRISMARINE).pattern(" D ").pattern("GCG").pattern(" I ").unlockedBy("has_psidust", hasPsidust).save(consumer, Psi.location("cad_colorizer_rainbow"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.cadColorizerPsi.get())).group("psi:colorizer").define(Character.valueOf('D'), ModTags.PSIDUST).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).define(Character.valueOf('C'), ModTags.PSIDUST).pattern(" D ").pattern("GCG").pattern(" I ").unlockedBy("has_psidust", hasPsidust).save(consumer, Psi.location("cad_colorizer_psi"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.spellBullet.get())).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('D'), ModTags.PSIDUST).pattern("ID").unlockedBy("has_psidust", hasPsidust).save(consumer, Psi.location("spell_bullet_basic"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.projectileSpellBullet.get())).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('D'), ModTags.PSIDUST).define(Character.valueOf('A'), ItemTags.ARROWS).pattern("AID").unlockedBy("has_psidust", hasPsidust).save(consumer, Psi.location("spell_bullet_projectile"));
        new BulletUpgradeRecipe.Builder((Item)ModItems.projectileSpellBullet.get()).requires((ItemLike)ModItems.spellBullet.get()).requires(Ingredient.of((TagKey)ItemTags.ARROWS)).unlockedBy("has_psidust", PsiRecipeGenerator.has((ItemLike)((ItemLike)ModItems.psidust.get()))).save(consumer, Psi.location("spell_bullet_projectile_upgrade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.loopSpellBullet.get())).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('D'), ModTags.PSIDUST).define(Character.valueOf('A'), Tags.Items.STRINGS).pattern("AID").unlockedBy("has_psidust", hasPsidust).save(consumer, Psi.location("spell_bullet_loopcast"));
        new BulletUpgradeRecipe.Builder((Item)ModItems.loopSpellBullet.get()).requires((ItemLike)ModItems.spellBullet.get()).requires(Ingredient.of((TagKey)Tags.Items.STRINGS)).unlockedBy("has_psidust", PsiRecipeGenerator.has((ItemLike)((ItemLike)ModItems.psidust.get()))).save(consumer, Psi.location("spell_bullet_loopcast_upgrade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.circleSpellBullet.get())).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('D'), ModTags.PSIDUST).define(Character.valueOf('A'), Ingredient.fromValues(Stream.of(new Ingredient.TagValue(Tags.Items.SLIME_BALLS), new Ingredient.ItemValue(new ItemStack((ItemLike)Items.SNOWBALL))))).pattern("AID").unlockedBy("has_psidust", hasPsidust).save(consumer, Psi.location("spell_bullet_circle"));
        new BulletUpgradeRecipe.Builder((Item)ModItems.circleSpellBullet.get()).requires((ItemLike)ModItems.spellBullet.get()).requires(Ingredient.fromValues(Stream.of(new Ingredient.TagValue(Tags.Items.SLIME_BALLS), new Ingredient.ItemValue(new ItemStack((ItemLike)Items.SNOWBALL))))).unlockedBy("has_psidust", PsiRecipeGenerator.has((ItemLike)((ItemLike)ModItems.psidust.get()))).save(consumer, Psi.location("spell_bullet_circle_upgrade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.grenadeSpellBullet.get())).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('D'), ModTags.PSIDUST).define(Character.valueOf('A'), Tags.Items.GUNPOWDERS).pattern("AID").unlockedBy("has_psidust", hasPsidust).save(consumer, Psi.location("spell_bullet_grenade"));
        new BulletUpgradeRecipe.Builder((Item)ModItems.grenadeSpellBullet.get()).requires((ItemLike)ModItems.spellBullet.get()).requires(Ingredient.of((TagKey)Tags.Items.GUNPOWDERS)).unlockedBy("has_psidust", PsiRecipeGenerator.has((ItemLike)((ItemLike)ModItems.psidust.get()))).save(consumer, Psi.location("spell_bullet_grenade_upgrade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.chargeSpellBullet.get())).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('D'), ModTags.PSIDUST).define(Character.valueOf('A'), Tags.Items.DUSTS_REDSTONE).pattern("AID").unlockedBy("has_psidust", hasPsidust).save(consumer, Psi.location("spell_bullet_charge"));
        new BulletUpgradeRecipe.Builder((Item)ModItems.chargeSpellBullet.get()).requires((ItemLike)ModItems.spellBullet.get()).requires(Ingredient.of((TagKey)Tags.Items.DUSTS_REDSTONE)).unlockedBy("has_psidust", PsiRecipeGenerator.has((ItemLike)((ItemLike)ModItems.psidust.get()))).save(consumer, Psi.location("spell_bullet_charge_upgrade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.mineSpellBullet.get())).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).define(Character.valueOf('D'), ModTags.PSIDUST).define(Character.valueOf('A'), ItemTags.BUTTONS).pattern("AID").unlockedBy("has_psidust", hasPsidust).save(consumer, Psi.location("spell_bullet_mine"));
        new BulletUpgradeRecipe.Builder((Item)ModItems.mineSpellBullet.get()).requires((ItemLike)ModItems.spellBullet.get()).requires(Ingredient.of((TagKey)ItemTags.BUTTONS)).unlockedBy("has_psidust", PsiRecipeGenerator.has((ItemLike)((ItemLike)ModItems.psidust.get()))).save(consumer, Psi.location("spell_bullet_mine_upgrade"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.spellDrive.get())).define(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).pattern("I").pattern("R").pattern("I").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("spell_drive"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.psimetalShovel.get())).define(Character.valueOf('P'), ModTags.INGOT_PSIMETAL).define(Character.valueOf('G'), ModTags.GEM_PSIGEM).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).pattern("GP").pattern(" I").pattern(" I").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("psimetal_shovel"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.psimetalPickaxe.get())).define(Character.valueOf('P'), ModTags.INGOT_PSIMETAL).define(Character.valueOf('G'), ModTags.GEM_PSIGEM).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).pattern("PGP").pattern(" I ").pattern(" I ").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("psimetal_pickaxe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.psimetalAxe.get())).define(Character.valueOf('P'), ModTags.INGOT_PSIMETAL).define(Character.valueOf('G'), ModTags.GEM_PSIGEM).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).pattern("GP").pattern("PI").pattern(" I").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("psimetal_axe"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.psimetalSword.get())).define(Character.valueOf('P'), ModTags.INGOT_PSIMETAL).define(Character.valueOf('G'), ModTags.GEM_PSIGEM).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).pattern("P").pattern("G").pattern("I").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("psimetal_sword"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.psimetalExosuitHelmet.get())).define(Character.valueOf('P'), ModTags.INGOT_PSIMETAL).define(Character.valueOf('G'), ModTags.GEM_PSIGEM).pattern("GPG").pattern("P P").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("psimetal_exosuit_helmet"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.psimetalExosuitChestplate.get())).define(Character.valueOf('P'), ModTags.INGOT_PSIMETAL).define(Character.valueOf('G'), ModTags.GEM_PSIGEM).pattern("P P").pattern("GPG").pattern("PPP").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("psimetal_exosuit_chestplate"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.psimetalExosuitLeggings.get())).define(Character.valueOf('P'), ModTags.INGOT_PSIMETAL).define(Character.valueOf('G'), ModTags.GEM_PSIGEM).pattern("GPG").pattern("P P").pattern("P P").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("psimetal_exosuit_leggings"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.COMBAT, (ItemLike)((ItemLike)ModItems.psimetalExosuitBoots.get())).define(Character.valueOf('P'), ModTags.INGOT_PSIMETAL).define(Character.valueOf('G'), ModTags.GEM_PSIGEM).pattern("G G").pattern("P P").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("psimetal_exosuit_boots"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.flashRing.get())).define(Character.valueOf('E'), ModTags.INGOT_EBONY_PSIMETAL).define(Character.valueOf('G'), Tags.Items.DUSTS_GLOWSTONE).define(Character.valueOf('P'), ModTags.GEM_PSIGEM).pattern(" E ").pattern("EGE").pattern(" P ").unlockedBy("has_ebony_psimetal", hasEbonyPsimetal).save(consumer, Psi.location("flash_ring"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.detonator.get())).define(Character.valueOf('P'), ModTags.PSIDUST).define(Character.valueOf('B'), ItemTags.BUTTONS).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).pattern(" B ").pattern("IPI").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("detonator"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.exosuitController.get())).define(Character.valueOf('R'), Tags.Items.DUSTS_REDSTONE).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).define(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).pattern("R").pattern("G").pattern("I").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("exosuit_controller"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.vectorRuler.get())).define(Character.valueOf('D'), ModTags.PSIDUST).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).pattern("D").pattern("I").pattern("I").unlockedBy("has_psidust", hasPsidust).save(consumer, Psi.location("vector_ruler"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.exosuitSensorLight.get())).define(Character.valueOf('M'), Tags.Items.DUSTS_GLOWSTONE).define(Character.valueOf('R'), Tags.Items.INGOTS_IRON).define(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).pattern(" I ").pattern("IMR").pattern(" R ").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("exosuit_sensor_light"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.exosuitSensorWater.get())).define(Character.valueOf('M'), Tags.Items.GEMS_PRISMARINE).define(Character.valueOf('R'), Tags.Items.INGOTS_IRON).define(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).pattern(" I ").pattern("IMR").pattern(" R ").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("exosuit_sensor_water"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.exosuitSensorHeat.get())).define(Character.valueOf('M'), (ItemLike)Items.FIRE_CHARGE).define(Character.valueOf('R'), Tags.Items.INGOTS_IRON).define(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).pattern(" I ").pattern("IMR").pattern(" R ").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("exosuit_sensor_heat"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.exosuitSensorStress.get())).define(Character.valueOf('M'), (ItemLike)Items.GLISTERING_MELON_SLICE).define(Character.valueOf('R'), Tags.Items.INGOTS_IRON).define(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).pattern(" I ").pattern("IMR").pattern(" R ").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("exosuit_sensor_stress"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)((ItemLike)ModItems.exosuitSensorTrigger.get())).define(Character.valueOf('M'), (ItemLike)Items.GUNPOWDER).define(Character.valueOf('R'), Tags.Items.INGOTS_IRON).define(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).pattern(" I ").pattern("IMR").pattern(" R ").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("exosuit_sensor_trigger"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)((ItemLike)ModItems.cadColorizerEmpty.get())).define(Character.valueOf('D'), ModTags.PSIDUST).define(Character.valueOf('G'), Tags.Items.GLASS_BLOCKS).define(Character.valueOf('I'), Tags.Items.INGOTS_IRON).pattern(" D ").pattern("G G").pattern(" I ").unlockedBy("has_psidust", hasPsidust).save(consumer, Psi.location("cad_colorizer_empty"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((Block)ModBlocks.psidustBlock.get()).asItem()).define(Character.valueOf('I'), (ItemLike)ModItems.psidust.get()).pattern("III").pattern("III").pattern("III").unlockedBy("has_psidust", hasPsidust).save(consumer, Psi.location("psidust_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((Block)ModBlocks.psimetalBlock.get()).asItem()).define(Character.valueOf('I'), (ItemLike)ModItems.psimetal.get()).pattern("III").pattern("III").pattern("III").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("psimetal_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((Block)ModBlocks.psigemBlock.get()).asItem()).define(Character.valueOf('I'), (ItemLike)ModItems.psigem.get()).pattern("III").pattern("III").pattern("III").unlockedBy("has_psigem", PsiRecipeGenerator.has((ItemLike)((ItemLike)ModItems.psigem.get()))).save(consumer, Psi.location("psigem_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((Block)ModBlocks.psimetalEbony.get()).asItem()).define(Character.valueOf('I'), (ItemLike)ModItems.ebonyPsimetal.get()).pattern("III").pattern("III").pattern("III").unlockedBy("has_ebony_psimetal", hasEbonyPsimetal).save(consumer, Psi.location("ebony_block"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((Block)ModBlocks.psimetalIvory.get()).asItem()).define(Character.valueOf('I'), (ItemLike)ModItems.ivoryPsimetal.get()).pattern("III").pattern("III").pattern("III").unlockedBy("has_ivory_psimetal", hasIvoryPsimetal).save(consumer, Psi.location("ivory_block"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModItems.psidust.get()), (int)9).requires((ItemLike)((Block)ModBlocks.psidustBlock.get()).asItem()).unlockedBy("has_psidust", hasPsidust).save(consumer, Psi.location("psidust_shapeless"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModItems.psimetal.get()), (int)9).requires((ItemLike)((Block)ModBlocks.psimetalBlock.get()).asItem()).unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("psimetal_shapeless"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModItems.psigem.get()), (int)9).requires((ItemLike)((Block)ModBlocks.psigemBlock.get()).asItem()).unlockedBy("has_psigem", PsiRecipeGenerator.has((ItemLike)((ItemLike)ModItems.psigem.get()))).save(consumer, Psi.location("psigem_shapeless"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModItems.ebonyPsimetal.get()), (int)9).requires((ItemLike)((Block)ModBlocks.psimetalEbony.get()).asItem()).unlockedBy("has_ebony_psimetal", hasEbonyPsimetal).save(consumer, Psi.location("ebony_ingot_shapeless"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)((ItemLike)ModItems.ivoryPsimetal.get()), (int)9).requires((ItemLike)((Block)ModBlocks.psimetalIvory.get()).asItem()).unlockedBy("has_ivory_psimetal", hasIvoryPsimetal).save(consumer, Psi.location("ivory_ingot_shapeless"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((Block)ModBlocks.psimetalPlateBlack.get()).asItem()).define(Character.valueOf('C'), ItemTags.COALS).define(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).pattern(" C ").pattern("CIC").pattern(" C ").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("psimetal_plate_black"));
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((Block)ModBlocks.psimetalPlateWhite.get()).asItem()).define(Character.valueOf('C'), Tags.Items.GEMS_QUARTZ).define(Character.valueOf('I'), ModTags.INGOT_PSIMETAL).pattern(" C ").pattern("CIC").pattern(" C ").unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("psimetal_plate_white"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((Block)ModBlocks.psimetalPlateBlackLight.get()).asItem()).requires(Tags.Items.DUSTS_GLOWSTONE).requires((ItemLike)((Block)ModBlocks.psimetalPlateBlack.get()).asItem()).unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("psimetal_plate_black_light"));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)((Block)ModBlocks.psimetalPlateWhiteLight.get()).asItem()).requires(Tags.Items.DUSTS_GLOWSTONE).requires((ItemLike)((Block)ModBlocks.psimetalPlateWhite.get()).asItem()).unlockedBy("has_psimetal", hasPsimetal).save(consumer, Psi.location("psimetal_plate_white_light"));
        this.buildTrickRecipes(consumer);
    }

    protected void buildTrickRecipes(RecipeOutput consumer) {
        TrickRecipeBuilder.of((ItemLike)ModItems.psidust.get()).input((TagKey<Item>)Tags.Items.DUSTS_REDSTONE).cad((ItemLike)ModItems.cadAssemblyIron.get()).build(consumer);
        TrickRecipeBuilder.of(PatchouliAPI.get().getBookStack(LibResources.PATCHOULI_BOOK)).input(new ItemLike[]{Items.BOOK}).cad((ItemLike)ModItems.cadAssemblyIron.get()).build(consumer);
        TrickRecipeBuilder.of((ItemLike)ModItems.cadAssemblyPsimetal.get()).input((ItemLike)ModItems.cadAssemblyGold.get()).trick(Psi.location("trick_infusion")).cad((ItemLike)ModItems.cadAssemblyIron.get()).unlockedBy(PsiRecipeGenerator.getHasName((ItemLike)((ItemLike)ModItems.cadAssemblyGold.get())), PsiRecipeGenerator.has((ItemLike)((ItemLike)ModItems.cadAssemblyGold.get()))).build(consumer, Psi.location("gold_to_psimetal_assembly_upgrade"));
        TrickRecipeBuilder.of((ItemLike)ModItems.psimetal.get()).input((TagKey<Item>)Tags.Items.INGOTS_GOLD).trick(Psi.location("trick_infusion")).cad((ItemLike)ModItems.cadAssemblyIron.get()).unlockedBy("has_gold_ingot", PsiRecipeGenerator.has((TagKey)Tags.Items.INGOTS_GOLD)).build(consumer);
        TrickRecipeBuilder.of((ItemLike)ModItems.psigem.get()).input((TagKey<Item>)Tags.Items.GEMS_DIAMOND).trick(Psi.location("trick_greater_infusion")).cad((ItemLike)ModItems.cadAssemblyPsimetal.get()).unlockedBy("has_diamond", PsiRecipeGenerator.has((TagKey)Tags.Items.GEMS_DIAMOND)).build(consumer);
        TrickRecipeBuilder.of((ItemLike)ModItems.ebonySubstance.get()).input((TagKey<Item>)ItemTags.COALS).trick(Psi.location("trick_ebony_ivory")).cad((ItemLike)ModItems.cadAssemblyPsimetal.get()).dimension((ResourceKey<Level>)Level.END).unlockedBy("has_coal", PsiRecipeGenerator.has((TagKey)ItemTags.COALS)).build(consumer);
        TrickRecipeBuilder.of((ItemLike)ModItems.ivorySubstance.get()).input((TagKey<Item>)Tags.Items.GEMS_QUARTZ).trick(Psi.location("trick_ebony_ivory")).cad((ItemLike)ModItems.cadAssemblyPsimetal.get()).dimension((ResourceKey<Level>)Level.END).unlockedBy("has_quartz", PsiRecipeGenerator.has((TagKey)Tags.Items.GEMS_QUARTZ)).build(consumer);
    }
}

