/*
 * Decompiled with CFR 0.152.
 */
package vazkii.psi.common.core.capability;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.EntityCapability;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.psi.api.PsiAPI;
import vazkii.psi.api.exosuit.PsiArmorEvent;
import vazkii.psi.api.spell.detonator.IDetonationHandler;

public record CapabilityTriggerSensor(Player player) implements IDetonationHandler,
ICapabilityProvider<EntityCapability<?, Void>, Void, CapabilityTriggerSensor>
{
    public static final String TRIGGER_TICK = "psi:LastTriggeredDetonation";

    @Nullable
    public CapabilityTriggerSensor getCapability(@NotNull EntityCapability<?, Void> capability, @Nullable Void facing) {
        if (capability == PsiAPI.DETONATION_HANDLER_CAPABILITY) {
            return this;
        }
        return null;
    }

    @Override
    public void detonate() {
        long worldTime;
        CompoundTag playerData = this.player.getPersistentData();
        long detonated = playerData.getLong(TRIGGER_TICK);
        if (detonated != (worldTime = this.player.level().getGameTime())) {
            playerData.putLong(TRIGGER_TICK, worldTime);
            PsiArmorEvent.post(new PsiArmorEvent(this.player, "psi.event.spell_detonate"));
        }
    }

    @Override
    public Vec3 objectLocus() {
        return this.player.position();
    }
}

