/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.rendering;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import moze_intel.projecte.gameObjs.block_entities.EmcChestBlockEntity;
import moze_intel.projecte.gameObjs.registration.impl.BlockRegistryObject;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class ChestRenderer
implements BlockEntityRenderer<EmcChestBlockEntity> {
    private final ModelPart lid;
    private final ModelPart bottom;
    private final ModelPart lock;
    private final BlockRegistryObject<?, ?> type;
    private final ResourceLocation texture;

    public ChestRenderer(BlockEntityRendererProvider.Context context, ResourceLocation texture, BlockRegistryObject<?, ?> type) {
        this.texture = texture;
        this.type = type;
        ModelPart modelpart = context.bakeLayer(ModelLayers.CHEST);
        this.bottom = modelpart.getChild("bottom");
        this.lid = modelpart.getChild("lid");
        this.lock = modelpart.getChild("lock");
    }

    public void render(@NotNull EmcChestBlockEntity chest, float partialTick, @NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light, int overlayLight) {
        BlockState state;
        matrix.pushPose();
        if (chest.getLevel() != null && !chest.isRemoved() && (state = chest.getLevel().getBlockState(chest.getBlockPos())).is(this.type.getBlock())) {
            matrix.translate(0.5, 0.5, 0.5);
            matrix.mulPose(Axis.YP.rotationDegrees(-((Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).toYRot()));
            matrix.translate(-0.5, -0.5, -0.5);
        }
        float lidAngle = 1.0f - chest.getOpenNess(partialTick);
        lidAngle = 1.0f - lidAngle * lidAngle * lidAngle;
        VertexConsumer builder = renderer.getBuffer(RenderType.entityCutout((ResourceLocation)this.texture));
        this.lock.xRot = this.lid.xRot = -(lidAngle * 1.5707964f);
        this.lid.render(matrix, builder, light, overlayLight);
        this.lock.render(matrix, builder, light, overlayLight);
        this.bottom.render(matrix, builder, light, overlayLight);
        matrix.popPose();
    }
}

