/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.packets.to_server;

import io.netty.buffer.ByteBuf;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.item.IExtraFunction;
import moze_intel.projecte.api.capabilities.item.IItemCharge;
import moze_intel.projecte.api.capabilities.item.IModeChanger;
import moze_intel.projecte.api.capabilities.item.IProjectileShooter;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.items.armor.GemArmorBase;
import moze_intel.projecte.gameObjs.items.armor.GemChest;
import moze_intel.projecte.gameObjs.items.armor.GemFeet;
import moze_intel.projecte.gameObjs.items.armor.GemHelmet;
import moze_intel.projecte.gameObjs.registries.PEAttachmentTypes;
import moze_intel.projecte.gameObjs.registries.PEItems;
import moze_intel.projecte.network.packets.IPEPacket;
import moze_intel.projecte.utils.PEKeybind;
import moze_intel.projecte.utils.PlayerHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.ItemCapability;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record KeyPressPKT(PEKeybind key) implements IPEPacket
{
    public static final CustomPacketPayload.Type<KeyPressPKT> TYPE = new CustomPacketPayload.Type(PECore.rl("key_press"));
    public static final StreamCodec<ByteBuf, KeyPressPKT> STREAM_CODEC = PEKeybind.STREAM_CODEC.map(KeyPressPKT::new, KeyPressPKT::key);

    @NotNull
    public CustomPacketPayload.Type<KeyPressPKT> type() {
        return TYPE;
    }

    @Override
    public void handle(IPayloadContext context) {
        Player player = context.player();
        if (player.isSpectator()) {
            return;
        }
        if (this.key == PEKeybind.HELMET_TOGGLE) {
            ItemStack helm = player.getItemBySlot(EquipmentSlot.HEAD);
            if (!helm.isEmpty() && helm.is(PEItems.GEM_HELMET)) {
                GemHelmet.toggleNightVision(helm, player);
            }
            return;
        }
        if (this.key == PEKeybind.BOOTS_TOGGLE) {
            ItemStack boots = player.getItemBySlot(EquipmentSlot.FEET);
            if (!boots.isEmpty() && boots.is(PEItems.GEM_BOOTS)) {
                GemFeet.toggleStepAssist(boots, player);
            }
            return;
        }
        block6: for (InteractionHand hand : InteractionHand.values()) {
            ItemStack stack = player.getItemInHand(hand);
            switch (this.key) {
                case CHARGE: {
                    if (KeyPressPKT.tryPerformCapability(player, stack, hand, PECapabilities.CHARGE_ITEM_CAPABILITY, IItemCharge::changeCharge)) {
                        return;
                    }
                    if (hand != InteractionHand.MAIN_HAND || !KeyPressPKT.isSafe(stack) || !GemArmorBase.hasAnyPiece(player)) continue block6;
                    player.setData(PEAttachmentTypes.GEM_ARMOR_STATE, (Object)((Boolean)player.getData(PEAttachmentTypes.GEM_ARMOR_STATE) == false ? 1 : 0));
                    PELang langEntry = (Boolean)player.getData(PEAttachmentTypes.GEM_ARMOR_STATE) != false ? PELang.GEM_ACTIVATE : PELang.GEM_DEACTIVATE;
                    player.sendSystemMessage((Component)langEntry.translate());
                    return;
                }
                case EXTRA_FUNCTION: {
                    ItemStack chestplate;
                    if (KeyPressPKT.tryPerformCapability(player, stack, hand, PECapabilities.EXTRA_FUNCTION_ITEM_CAPABILITY, IExtraFunction::doExtraFunction)) {
                        return;
                    }
                    if (hand != InteractionHand.MAIN_HAND || !KeyPressPKT.isSafe(stack) || !((Boolean)player.getData(PEAttachmentTypes.GEM_ARMOR_STATE)).booleanValue() || (chestplate = player.getItemBySlot(EquipmentSlot.CHEST)).isEmpty() || !chestplate.is(PEItems.GEM_CHESTPLATE) || !PlayerHelper.checkCooldown(player, (Item)PEItems.GEM_CHESTPLATE.get(), ProjectEConfig.server.cooldown.player.gemChest)) continue block6;
                    GemChest.doExplode(player);
                    return;
                }
                case FIRE_PROJECTILE: {
                    ItemStack helmet;
                    if (!stack.isEmpty() && PlayerHelper.checkCooldown(player, stack.getItem(), ProjectEConfig.server.cooldown.player.projectile) && KeyPressPKT.tryPerformCapability(player, stack, hand, PECapabilities.PROJECTILE_SHOOTER_ITEM_CAPABILITY, IProjectileShooter::shootProjectile)) {
                        PlayerHelper.swingItem(player, hand);
                    }
                    if (hand != InteractionHand.MAIN_HAND || !KeyPressPKT.isSafe(stack) || !((Boolean)player.getData(PEAttachmentTypes.GEM_ARMOR_STATE)).booleanValue() || (helmet = player.getItemBySlot(EquipmentSlot.HEAD)).isEmpty() || !helmet.is(PEItems.GEM_HELMET)) continue block6;
                    GemHelmet.doZap(player);
                    return;
                }
                case MODE: {
                    if (!KeyPressPKT.tryPerformCapability(player, stack, hand, PECapabilities.MODE_CHANGER_ITEM_CAPABILITY, IModeChanger::changeMode)) continue block6;
                    return;
                }
            }
        }
    }

    private static <CAPABILITY> boolean tryPerformCapability(Player player, ItemStack stack, InteractionHand hand, ItemCapability<CAPABILITY, Void> capability, CapabilityProcessor<CAPABILITY> processor) {
        Object impl = stack.getCapability(capability);
        return impl != null && processor.process(impl, player, stack, hand);
    }

    private static boolean isSafe(ItemStack stack) {
        return ProjectEConfig.server.misc.unsafeKeyBinds.get() || stack.isEmpty();
    }

    @FunctionalInterface
    private static interface CapabilityProcessor<CAPABILITY> {
        public boolean process(CAPABILITY var1, Player var2, ItemStack var3, InteractionHand var4);
    }
}

