/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.commands.client;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.lang.runtime.SwitchBootstraps;
import java.util.HashSet;
import java.util.Objects;
import moze_intel.projecte.PECore;
import moze_intel.projecte.api.ItemInfo;
import moze_intel.projecte.api.proxy.IEMCProxy;
import moze_intel.projecte.config.MappingConfig;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.emc.mappers.OreBlacklistMapper;
import moze_intel.projecte.emc.mappers.RawMaterialsBlacklistMapper;
import moze_intel.projecte.gameObjs.PETags;
import moze_intel.projecte.gameObjs.items.Tome;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.common.Tags;
import org.slf4j.Logger;

public class DumpMissingEmc {
    private static final boolean SKIP_TOP = Boolean.parseBoolean(System.getProperties().getProperty("projecte.skip_top"));

    public static ArgumentBuilder<CommandSourceStack, ?> register(CommandBuildContext context) {
        return ((LiteralArgumentBuilder)Commands.literal((String)"dumpmissingemc").then(Commands.argument((String)"skip_expected", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> DumpMissingEmc.execute((CommandContext<CommandSourceStack>)ctx, BoolArgumentType.getBool((CommandContext)ctx, (String)"skip_expected"))))).executes(ctx -> DumpMissingEmc.execute((CommandContext<CommandSourceStack>)ctx, false));
    }

    private static boolean expectedMissing(FeatureFlagSet enabledFeatures, ItemInfo info) {
        Holder<Item> holder;
        block10: {
            holder = info.getItem();
            if (holder.is(PETags.Items.IGNORE_MISSING_EMC)) {
                return true;
            }
            Item item = (Item)holder.value();
            Objects.requireNonNull(item);
            Item item2 = item;
            int n = 0;
            block5: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockItem.class, Tome.class, BundleItem.class}, (Object)item2, n)) {
                    case 0: {
                        BlockItem blockItem = (BlockItem)item2;
                        if (blockItem.getBlock().defaultDestroyTime() == -1.0f) break block5;
                        n = 1;
                        continue block5;
                    }
                    case 1: {
                        Tome tome = (Tome)item2;
                        if (!ProjectEConfig.common.craftableTome.get()) break block5;
                        n = 2;
                        continue block5;
                    }
                    case 2: {
                        BundleItem bundleItem = (BundleItem)item2;
                        if (!enabledFeatures.contains(FeatureFlags.BUNDLE)) break block5;
                        n = 3;
                        continue block5;
                    }
                    default: {
                        break block10;
                    }
                }
                break;
            }
            return true;
        }
        if (!FMLEnvironment.production && SKIP_TOP && holder.unwrapKey().map(key -> key.location().getNamespace().equals("theoneprobe")).orElse(false).booleanValue()) {
            return true;
        }
        if (MappingConfig.isEnabled(OreBlacklistMapper.INSTANCE) && (holder.is(Tags.Items.ORES) || holder.value() == Items.GILDED_BLACKSTONE)) {
            return true;
        }
        if (MappingConfig.isEnabled(RawMaterialsBlacklistMapper.INSTANCE) && (holder.is(Tags.Items.RAW_MATERIALS) || holder.is(Tags.Items.STORAGE_BLOCKS_RAW_COPPER) || holder.is(Tags.Items.STORAGE_BLOCKS_RAW_IRON) || holder.is(Tags.Items.STORAGE_BLOCKS_RAW_GOLD))) {
            return true;
        }
        PotionContents potionContents = (PotionContents)info.getOrNull(DataComponents.POTION_CONTENTS);
        return potionContents != null && potionContents.potion().isPresent() && ((Holder)potionContents.potion().get()).is(PETags.Potions.IGNORE_MISSING_EMC);
    }

    private static int execute(CommandContext<CommandSourceStack> ctx, boolean skipExpectedMissing) {
        ItemInfo itemInfo;
        CommandSourceStack source = (CommandSourceStack)ctx.getSource();
        RegistryAccess registryAccess = source.registryAccess();
        Minecraft minecraft = Minecraft.getInstance();
        FeatureFlagSet features = minecraft.getConnection() == null ? FeatureFlags.DEFAULT_FLAGS : minecraft.getConnection().enabledFeatures();
        CreativeModeTab tab = (CreativeModeTab)registryAccess.holderOrThrow(CreativeModeTabs.SEARCH).value();
        if (tab.getSearchTabDisplayItems().isEmpty()) {
            boolean hasPermissions = (Boolean)minecraft.options.operatorItemsTab().get();
            if (!hasPermissions) {
                hasPermissions = minecraft.player != null ? minecraft.player.canUseGameMasterBlocks() : source.hasPermission(2);
            }
            try {
                tab.buildContents(new CreativeModeTab.ItemDisplayParameters(features, hasPermissions, (HolderLookup.Provider)registryAccess));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        HashSet<ItemInfo> missing = new HashSet<ItemInfo>();
        for (Item item : registryAccess.registryOrThrow(Registries.ITEM)) {
            if (item == Items.AIR || !item.isEnabled(features)) continue;
            itemInfo = ItemInfo.fromItem((ItemLike)item);
            if (skipExpectedMissing && DumpMissingEmc.expectedMissing(features, itemInfo) || IEMCProxy.INSTANCE.hasValue(itemInfo)) continue;
            missing.add(itemInfo);
        }
        for (ItemStack stack : tab.getSearchTabDisplayItems()) {
            if (stack.isEmpty() || stack.isComponentsPatchEmpty()) continue;
            itemInfo = ItemInfo.fromStack(stack);
            if (IEMCProxy.INSTANCE.hasValue(itemInfo)) {
                missing.remove(itemInfo.itemOnly());
                continue;
            }
            if (skipExpectedMissing && DumpMissingEmc.expectedMissing(features, itemInfo)) continue;
            missing.add(itemInfo);
        }
        int missingCount = missing.size();
        if (missingCount == 0) {
            source.sendSuccess(PELang.DUMP_MISSING_EMC_NONE_MISSING::translate, true);
        } else {
            if (missingCount == 1) {
                source.sendSuccess(PELang.DUMP_MISSING_EMC_ONE_MISSING::translate, true);
            } else {
                source.sendSuccess(() -> PELang.DUMP_MISSING_EMC_MULTIPLE_MISSING.translate(missingCount), true);
            }
            missing.stream().map(ItemInfo::toString).sorted().forEach(arg_0 -> ((Logger)PECore.LOGGER).info(arg_0));
        }
        return missingCount;
    }
}

