/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network.commands;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.datafixers.util.Either;
import java.util.function.Predicate;
import moze_intel.projecte.PEPermissions;
import moze_intel.projecte.api.nss.NSSItem;
import moze_intel.projecte.config.CustomEMCParser;
import moze_intel.projecte.network.commands.SetEmcCMD;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.commands.arguments.item.ItemArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;

public class RemoveEmcCMD {
    private static final SimpleCommandExceptionType EMPTY_STACK = new SimpleCommandExceptionType((Message)PELang.COMMAND_NO_ITEM.translate());

    public static LiteralArgumentBuilder<CommandSourceStack> register(CommandBuildContext context) {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"removeemc").requires((Predicate)PEPermissions.COMMAND_REMOVE_EMC)).then(Commands.argument((String)"item", (ArgumentType)ItemArgument.item((CommandBuildContext)context)).executes(ctx -> {
            ItemInput itemInput = ItemArgument.getItem((CommandContext)ctx, (String)"item");
            return RemoveEmcCMD.removeEmc((CommandContext<CommandSourceStack>)ctx, NSSItem.createItem(itemInput.createItemStack(1, false)));
        }))).then(Commands.argument((String)"tag", (ArgumentType)ResourceOrTagKeyArgument.resourceOrTagKey((ResourceKey)Registries.ITEM)).executes(ctx -> {
            Either result = ResourceOrTagKeyArgument.getResourceOrTagKey((CommandContext)ctx, (String)"tag", (ResourceKey)Registries.ITEM, (DynamicCommandExceptionType)SetEmcCMD.ERROR_INVALID_ITEM).unwrap();
            return RemoveEmcCMD.removeEmc((CommandContext<CommandSourceStack>)ctx, (NSSItem)result.map(NSSItem::createItem, NSSItem::createTag));
        }))).executes(ctx -> RemoveEmcCMD.removeEmc((CommandContext<CommandSourceStack>)ctx, RemoveEmcCMD.getHeldStack((CommandContext<CommandSourceStack>)ctx)));
    }

    private static int removeEmc(CommandContext<CommandSourceStack> ctx, NSSItem item) {
        CustomEMCParser.addToFile(item, 0L);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> PELang.COMMAND_REMOVE_SUCCESS.translate(item), true);
        ((CommandSourceStack)ctx.getSource()).sendSuccess(PELang.RELOAD_NOTICE::translate, true);
        return 1;
    }

    public static NSSItem getHeldStack(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer player = ((CommandSourceStack)ctx.getSource()).getPlayerOrException();
        ItemStack stack = player.getMainHandItem();
        if (stack.isEmpty()) {
            stack = player.getOffhandItem();
        }
        if (stack.isEmpty()) {
            throw EMPTY_STACK.create();
        }
        return NSSItem.createItem(stack);
    }
}

