/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.blocks;

import java.util.List;
import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.item.IPedestalItem;
import moze_intel.projecte.gameObjs.EnumMatterType;
import moze_intel.projecte.gameObjs.IMatterType;
import moze_intel.projecte.gameObjs.block_entities.DMPedestalBlockEntity;
import moze_intel.projecte.gameObjs.blocks.IMatterBlock;
import moze_intel.projecte.gameObjs.blocks.PEEntityBlock;
import moze_intel.projecte.gameObjs.registration.impl.BlockEntityTypeRegistryObject;
import moze_intel.projecte.gameObjs.registries.PEBlockEntityTypes;
import moze_intel.projecte.utils.WorldHelper;
import moze_intel.projecte.utils.text.PELang;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Pedestal
extends Block
implements SimpleWaterloggedBlock,
PEEntityBlock<DMPedestalBlockEntity>,
IMatterBlock {
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)2.0, (double)13.0), (VoxelShape)Shapes.or((VoxelShape)Block.box((double)6.0, (double)2.0, (double)6.0, (double)10.0, (double)9.0, (double)10.0), (VoxelShape)Block.box((double)5.0, (double)9.0, (double)5.0, (double)11.0, (double)10.0, (double)11.0)));

    public Pedestal(BlockBehaviour.Properties props) {
        super(props);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> props) {
        super.createBlockStateDefinition(props);
        props.add(new Property[]{BlockStateProperties.WATERLOGGED});
    }

    @Deprecated
    public boolean isPathfindable(@NotNull BlockState state, @NotNull PathComputationType pathComputationType) {
        return false;
    }

    @Deprecated
    @NotNull
    public VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext ctx) {
        return SHAPE;
    }

    private boolean dropItem(Level level, BlockPos pos) {
        ItemStack stack;
        DMPedestalBlockEntity pedestal = WorldHelper.getBlockEntity(DMPedestalBlockEntity.class, (BlockGetter)level, pos);
        if (pedestal != null && !(stack = pedestal.getInventory().getStackInSlot(0)).isEmpty()) {
            pedestal.getInventory().setStackInSlot(0, ItemStack.EMPTY);
            level.addFreshEntity((Entity)new ItemEntity(level, (double)pos.getX(), (double)pos.getY() + 0.8, (double)pos.getZ(), stack));
            return true;
        }
        return false;
    }

    @Deprecated
    public void onRemove(BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            this.dropItem(level, pos);
            super.onRemove(state, level, pos, newState, isMoving);
        }
    }

    @Deprecated
    public void attack(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player) {
        if (!level.isClientSide) {
            this.dropItem(level, pos);
        }
    }

    public boolean onDestroyedByPlayer(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, boolean willHarvest, @NotNull FluidState fluid) {
        if (player.isCreative() && this.dropItem(level, pos)) {
            level.sendBlockUpdated(pos, state, state, 8);
            return false;
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    @Deprecated
    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult rtr) {
        if (!level.isClientSide) {
            DMPedestalBlockEntity pedestal = WorldHelper.getBlockEntity(DMPedestalBlockEntity.class, (BlockGetter)level, pos, true);
            if (pedestal == null) {
                return ItemInteractionResult.FAIL;
            }
            ItemStack item = pedestal.getInventory().getStackInSlot(0);
            if (stack.isEmpty() && !item.isEmpty()) {
                IPedestalItem pedestalItem = (IPedestalItem)item.getCapability(PECapabilities.PEDESTAL_ITEM_CAPABILITY);
                if (pedestalItem != null) {
                    pedestal.setActive(level, pos, !pedestal.getActive());
                    level.sendBlockUpdated(pos, state, state, 8);
                }
            } else if (!stack.isEmpty() && item.isEmpty()) {
                pedestal.getInventory().setStackInSlot(0, stack.split(1));
            }
        }
        return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    @Deprecated
    public void neighborChanged(@NotNull BlockState state, Level level, @NotNull BlockPos pos, @NotNull Block neighbor, @NotNull BlockPos neighborPos, boolean isMoving) {
        boolean hasSignal = level.hasNeighborSignal(pos);
        DMPedestalBlockEntity ped = WorldHelper.getBlockEntity(DMPedestalBlockEntity.class, (BlockGetter)level, pos);
        if (ped != null && ped.previousRedstoneState != hasSignal) {
            ItemStack stack;
            if (hasSignal && (stack = ped.getInventory().getStackInSlot(0)).getCapability(PECapabilities.PEDESTAL_ITEM_CAPABILITY) != null) {
                ped.setActive(level, pos, !ped.getActive());
                level.sendBlockUpdated(pos, state, state, 11);
            }
            ped.previousRedstoneState = hasSignal;
            ped.markDirty(level, pos, false);
        }
    }

    @Deprecated
    public boolean hasAnalogOutputSignal(@NotNull BlockState state) {
        return true;
    }

    @Deprecated
    public int getAnalogOutputSignal(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        ItemStack stack;
        DMPedestalBlockEntity pedestal = WorldHelper.getBlockEntity(DMPedestalBlockEntity.class, (BlockGetter)level, pos);
        if (pedestal != null && !(stack = pedestal.getInventory().getStackInSlot(0)).isEmpty()) {
            if (stack.getCapability(PECapabilities.PEDESTAL_ITEM_CAPABILITY) != null) {
                return pedestal.getActive() ? 15 : 10;
            }
            return 5;
        }
        return 0;
    }

    @Override
    @Nullable
    public BlockEntityTypeRegistryObject<DMPedestalBlockEntity> getType() {
        return PEBlockEntityTypes.DARK_MATTER_PEDESTAL;
    }

    @Deprecated
    public boolean triggerEvent(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, int id, int param) {
        super.triggerEvent(state, level, pos, id, param);
        return this.triggerBlockEntityEvent(state, level, pos, id, param);
    }

    public void appendHoverText(@NotNull ItemStack stack, @NotNull Item.TooltipContext context, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
        super.appendHoverText(stack, context, tooltip, flags);
        MutableComponent interact = Component.keybind((String)"key.use");
        tooltip.add((Component)PELang.PEDESTAL_TOOLTIP1.translate(interact, Component.keybind((String)"key.attack")));
        tooltip.add((Component)PELang.PEDESTAL_TOOLTIP2.translate(interact));
    }

    @Nullable
    public BlockState getStateForPlacement(@NotNull BlockPlaceContext context) {
        BlockState state = super.getStateForPlacement(context);
        return state == null ? null : (BlockState)state.setValue((Property)BlockStateProperties.WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
    }

    @Deprecated
    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @Deprecated
    @NotNull
    public BlockState updateShape(@NotNull BlockState state, @NotNull Direction facing, @NotNull BlockState facingState, @NotNull LevelAccessor level, @NotNull BlockPos currentPos, @NotNull BlockPos facingPos) {
        if (((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        return super.updateShape(state, facing, facingState, level, currentPos, facingPos);
    }

    @Override
    public IMatterType getMatterType() {
        return EnumMatterType.DARK_MATTER;
    }
}

