/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.gameObjs.block_entities;

import moze_intel.projecte.api.capabilities.PECapabilities;
import moze_intel.projecte.api.capabilities.item.IAlchChestItem;
import moze_intel.projecte.gameObjs.block_entities.EmcBlockEntity;
import moze_intel.projecte.gameObjs.block_entities.EmcChestBlockEntity;
import moze_intel.projecte.gameObjs.container.AlchChestContainer;
import moze_intel.projecte.gameObjs.registration.impl.BlockEntityTypeRegistryObject;
import moze_intel.projecte.gameObjs.registries.PEBlockEntityTypes;
import moze_intel.projecte.gameObjs.registries.PEBlocks;
import moze_intel.projecte.utils.text.TextComponentUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AlchBlockEntityChest
extends EmcChestBlockEntity {
    public static final ICapabilityProvider<AlchBlockEntityChest, @Nullable Direction, IItemHandler> INVENTORY_PROVIDER = (chest, side) -> chest.inventory;
    private final EmcBlockEntity.StackHandler inventory = new EmcBlockEntity.StackHandler(104){

        @Override
        public void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            if (AlchBlockEntityChest.this.level != null && !((AlchBlockEntityChest)AlchBlockEntityChest.this).level.isClientSide) {
                AlchBlockEntityChest.this.inventoryChanged = true;
            }
        }
    };
    private boolean inventoryChanged;

    public AlchBlockEntityChest(BlockPos pos, BlockState state) {
        super((BlockEntityTypeRegistryObject<? extends EmcChestBlockEntity>)PEBlockEntityTypes.ALCHEMICAL_CHEST, pos, state, 1000L);
    }

    @Override
    public void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.inventory.deserializeNBT(registries, tag);
    }

    @Override
    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        tag.merge(this.inventory.serializeNBT(registries));
    }

    public static void tickClient(Level level, BlockPos pos, BlockState state, AlchBlockEntityChest alchChest) {
        int slots = alchChest.inventory.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack stack = alchChest.inventory.getStackInSlot(i);
            IAlchChestItem alchChestItem = (IAlchChestItem)stack.getCapability(PECapabilities.ALCH_CHEST_ITEM_CAPABILITY);
            if (alchChestItem == null) continue;
            alchChestItem.updateInAlchChest(level, pos, stack);
        }
        EmcChestBlockEntity.lidAnimateTick(level, pos, state, alchChest);
    }

    public static void tickServer(Level level, BlockPos pos, BlockState state, AlchBlockEntityChest alchChest) {
        EmcBlockEntity.StackHandler inventory = alchChest.inventory;
        int slots = inventory.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack stack = inventory.getStackInSlot(i);
            IAlchChestItem alchChestItem = (IAlchChestItem)stack.getCapability(PECapabilities.ALCH_CHEST_ITEM_CAPABILITY);
            if (alchChestItem == null || !alchChestItem.updateInAlchChest(level, pos, stack)) continue;
            inventory.onContentsChanged(i);
        }
        if (alchChest.inventoryChanged) {
            alchChest.inventoryChanged = false;
            level.sendBlockUpdated(pos, state, state, 2);
        }
        alchChest.updateComparators(level, pos);
    }

    public IItemHandler getInventory() {
        return this.inventory;
    }

    @NotNull
    public AbstractContainerMenu createMenu(int windowId, @NotNull Inventory playerInventory, @NotNull Player playerIn) {
        return new AlchChestContainer(windowId, playerInventory, this);
    }

    @NotNull
    public Component getDisplayName() {
        return TextComponentUtil.build(PEBlocks.ALCHEMICAL_CHEST);
    }
}

