/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.world_transmutation;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import java.util.Optional;
import moze_intel.projecte.api.world_transmutation.IWorldTransmutation;
import moze_intel.projecte.api.world_transmutation.SimpleWorldTransmutation;
import net.minecraft.core.Holder;
import net.minecraft.core.IdMap;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.NeoForgeExtraCodecs;
import org.jetbrains.annotations.NotNull;

public record WorldTransmutation(@NotNull BlockState originState, @NotNull BlockState result, @NotNull BlockState altResult) implements IWorldTransmutation
{
    static final String ORIGIN_KEY = "origin";
    static final String RESULT_KEY = "result";
    static final String ALT_RESULT_KEY = "alt_result";
    private static final Codec<BlockState> STATE_CODEC = NeoForgeExtraCodecs.withAlternative((Codec)BuiltInRegistries.BLOCK.byNameCodec().flatXmap(block -> DataResult.success((Object)block.defaultBlockState()), state -> {
        if (state.getValues().isEmpty()) {
            return DataResult.success((Object)state.getBlock());
        }
        return DataResult.error(() -> "Flattened state codec cannot be used for blocks that define any properties.");
    }), (Codec)BlockState.CODEC);
    private static final StreamCodec<ByteBuf, BlockState> STATE_STREAM_CODEC = ByteBufCodecs.idMapper((IdMap)Block.BLOCK_STATE_REGISTRY);
    public static final Codec<WorldTransmutation> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)STATE_CODEC.fieldOf(ORIGIN_KEY).forGetter(WorldTransmutation::originState), (App)STATE_CODEC.fieldOf(RESULT_KEY).forGetter(WorldTransmutation::result), (App)STATE_CODEC.optionalFieldOf(ALT_RESULT_KEY).forGetter(entry -> entry.hasAlternate() ? Optional.of(entry.altResult()) : Optional.empty())).apply((Applicative)instance, (origin, result, altResult) -> new WorldTransmutation((BlockState)origin, (BlockState)result, altResult.orElse(result))));
    public static final StreamCodec<ByteBuf, WorldTransmutation> STREAM_CODEC = new StreamCodec<ByteBuf, WorldTransmutation>(){

        @NotNull
        public WorldTransmutation decode(@NotNull ByteBuf buffer) {
            BlockState origin = (BlockState)STATE_STREAM_CODEC.decode((Object)buffer);
            BlockState result = (BlockState)STATE_STREAM_CODEC.decode((Object)buffer);
            if (buffer.readBoolean()) {
                return new WorldTransmutation(origin, result, (BlockState)STATE_STREAM_CODEC.decode((Object)buffer));
            }
            return new WorldTransmutation(origin, result);
        }

        public void encode(@NotNull ByteBuf buffer, @NotNull WorldTransmutation transmutation) {
            STATE_STREAM_CODEC.encode((Object)buffer, (Object)transmutation.originState());
            STATE_STREAM_CODEC.encode((Object)buffer, (Object)transmutation.result());
            boolean hasAlternate = transmutation.hasAlternate();
            buffer.writeBoolean(hasAlternate);
            if (hasAlternate) {
                STATE_STREAM_CODEC.encode((Object)buffer, (Object)transmutation.altResult());
            }
        }
    };

    public WorldTransmutation(@NotNull BlockState originState, @NotNull BlockState result, @NotNull BlockState altResult) {
        Objects.requireNonNull(originState, "Origin state cannot be null");
        Objects.requireNonNull(result, "Result state cannot be null");
        Objects.requireNonNull(altResult, "Alternate result state cannot be null");
    }

    public WorldTransmutation(@NotNull BlockState originState, @NotNull BlockState result) {
        this(originState, result, result);
    }

    @NotNull
    public static IWorldTransmutation of(@NotNull BlockState origin, @NotNull BlockState result) {
        if (origin.getValues().isEmpty() && result.getValues().isEmpty()) {
            return new SimpleWorldTransmutation((Holder<Block>)origin.getBlockHolder(), (Holder<Block>)result.getBlockHolder());
        }
        return new WorldTransmutation(origin, result);
    }

    @NotNull
    public static IWorldTransmutation of(@NotNull BlockState origin, @NotNull BlockState result, @NotNull BlockState altResult) {
        if (origin.getValues().isEmpty() && result.getValues().isEmpty() && altResult.getValues().isEmpty()) {
            return new SimpleWorldTransmutation((Holder<Block>)origin.getBlockHolder(), (Holder<Block>)result.getBlockHolder(), (Holder<Block>)altResult.getBlockHolder());
        }
        return new WorldTransmutation(origin, result, altResult);
    }

    @Override
    public Holder<Block> origin() {
        return this.originState.getBlockHolder();
    }

    @Override
    public boolean hasAlternate() {
        return this.altResult != this.result;
    }

    @Override
    public BlockState result(@NotNull BlockState state, boolean isSneaking) {
        if (this.canTransmute(state)) {
            return isSneaking ? this.altResult : this.result;
        }
        return null;
    }

    @Override
    public boolean canTransmute(@NotNull BlockState state) {
        return state == this.originState;
    }

    @Override
    public String toString() {
        String representation = "World Transmutation from: '" + String.valueOf(this.originState) + "' to: '" + String.valueOf(this.result) + "'";
        if (this.hasAlternate()) {
            representation = representation + ", with secondary output of: '" + String.valueOf(this.altResult) + "'";
        }
        return representation;
    }
}

