/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.api.conversion;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.SequencedMap;
import moze_intel.projecte.api.codec.IPECodecHelper;
import moze_intel.projecte.api.conversion.ConversionGroup;
import moze_intel.projecte.api.conversion.FixedValues;
import net.minecraft.util.ExtraCodecs;
import org.jetbrains.annotations.Nullable;

public record CustomConversionFile(boolean replace, @Nullable String comment, SequencedMap<String, ConversionGroup> groups, FixedValues values) {
    private static final Codec<SequencedMap<String, ConversionGroup>> GROUP_CODEC = IPECodecHelper.INSTANCE.modifiableMap(Codec.unboundedMap((Codec)ExtraCodecs.NON_EMPTY_STRING, ConversionGroup.CODEC), LinkedHashMap::new);
    public static final Codec<CustomConversionFile> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("replace", (Object)false).forGetter(CustomConversionFile::replace), (App)ExtraCodecs.NON_EMPTY_STRING.optionalFieldOf("comment").forGetter(file -> Optional.ofNullable(file.comment())), (App)GROUP_CODEC.optionalFieldOf("groups").forGetter(file -> IPECodecHelper.INSTANCE.ifNotEmpty(file.groups())), (App)FixedValues.CODEC.optionalFieldOf("values").forGetter(file -> IPECodecHelper.INSTANCE.ifNotEmpty(file.values(), FixedValues::isEmpty))).apply((Applicative)instance, (replace, comment, groups, values) -> new CustomConversionFile((boolean)replace, comment.orElse(null), groups.orElseGet(LinkedHashMap::new), values.orElseGet(FixedValues::new))));

    public CustomConversionFile() {
        this(false, null, new LinkedHashMap<String, ConversionGroup>(), new FixedValues());
    }

    public static CustomConversionFile merge(CustomConversionFile left, CustomConversionFile right) {
        if (right.replace) {
            return right;
        }
        for (Map.Entry entry : right.groups.entrySet()) {
            left.groups.merge((String)entry.getKey(), (ConversionGroup)entry.getValue(), ConversionGroup::merge);
        }
        left.values.merge(right.values);
        return left;
    }

    public ConversionGroup getOrAddGroup(String groupName) {
        return this.groups.computeIfAbsent(groupName, name -> new ConversionGroup());
    }
}

