/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.client.gui.entry;

import fuzs.pickupnotifier.PickUpNotifier;
import fuzs.pickupnotifier.client.gui.entry.DisplayEntry;
import fuzs.pickupnotifier.client.util.DisplayEntryRenderHelper;
import fuzs.pickupnotifier.client.util.TransparencyBuffer;
import fuzs.pickupnotifier.config.ClientConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class ItemDisplayEntry
extends DisplayEntry {
    private final ItemStack stack;

    public ItemDisplayEntry(ItemStack stack, int amount) {
        super(amount, stack.getRarity());
        this.stack = stack;
    }

    @Override
    protected Component getEntryName() {
        if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).behavior.combineEntries == ClientConfig.CombineEntries.ALWAYS) {
            return this.stack.getItem().getName(this.stack);
        }
        return this.stack.getHoverName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean mayMergeWith(DisplayEntry other, boolean excludeNamed) {
        if (!(other instanceof ItemDisplayEntry)) return false;
        ItemDisplayEntry itemDisplayEntry = (ItemDisplayEntry)other;
        if (!this.sameItem(itemDisplayEntry.stack, excludeNamed)) return false;
        return true;
    }

    private boolean sameItem(ItemStack other, boolean testHoverName) {
        if (this.stack.getItem() == other.getItem()) {
            if (testHoverName) {
                return this.stack.getHoverName().equals((Object)other.getHoverName()) && this.stack.getRarity().equals((Object)other.getRarity());
            }
            return this.stack.getItem().getName(this.stack).equals((Object)other.getItem().getName(other));
        }
        return false;
    }

    @Override
    protected int getInventoryCount(Inventory inventory) {
        return ContainerHelper.clearOrCountMatchingItems((Container)inventory, stack -> this.sameItem((ItemStack)stack, false), (int)Integer.MAX_VALUE, (boolean)true);
    }

    @Override
    protected void renderSprite(Minecraft minecraft, GuiGraphics guiGraphics, int posX, int posY, float scale, float fadeTime) {
        TransparencyBuffer.prepareExtraFramebuffer();
        guiGraphics.renderItem(this.stack, posX, posY);
        if (((ClientConfig)PickUpNotifier.CONFIG.get(ClientConfig.class)).display.displayAmount.sprite()) {
            DisplayEntryRenderHelper.renderGuiItemDecorations(guiGraphics, minecraft.font, this.getDisplayAmount(), posX, posY);
        }
        TransparencyBuffer.preInject(fadeTime);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().scale(1.0f / scale, 1.0f / scale, 1.0f);
        TransparencyBuffer.drawExtraFramebuffer(guiGraphics);
        guiGraphics.pose().popPose();
        TransparencyBuffer.postInject();
    }
}

