/*
 * Decompiled with CFR 0.152.
 */
package fuzs.overflowingbars.client.packs;

import com.mojang.blaze3d.platform.NativeImage;
import fuzs.overflowingbars.OverflowingBars;
import fuzs.overflowingbars.client.gui.NewHealthBarRenderer;
import fuzs.puzzleslib.api.resources.v1.AbstractModPackResources;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntUnaryOperator;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.VanillaPackResources;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;

public class DynamicallyCopiedPackResources
extends AbstractModPackResources {
    private final ResourceManager resourceManager;
    private final VanillaPackResources vanillaPackResources;
    private final Map<ResourceLocation, TextureCopy> textures;

    protected DynamicallyCopiedPackResources(TextureCopy ... textures) {
        Minecraft minecraft = Minecraft.getInstance();
        this.resourceManager = minecraft.getResourceManager();
        this.vanillaPackResources = minecraft.getVanillaPackResources();
        this.textures = Stream.of(textures).collect(Collectors.toMap(TextureCopy::destinationLocation, Function.identity()));
    }

    public static Supplier<AbstractModPackResources> create(TextureCopy ... textures) {
        return () -> new DynamicallyCopiedPackResources(textures);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public IoSupplier<InputStream> getResource(PackType packType, ResourceLocation resourceLocation) {
        if (!this.textures.containsKey(resourceLocation)) return null;
        TextureCopy textureCopy = this.textures.get(resourceLocation);
        Optional vanillaResource = this.resourceManager.getResource(textureCopy.vanillaLocation());
        if (!vanillaResource.isPresent()) return null;
        try (NativeImage nativeImage = NativeImage.read((InputStream)((Resource)vanillaResource.get()).open());){
            if (nativeImage.getWidth() / nativeImage.getHeight() == textureCopy.vanillaImageWidth() / textureCopy.vanillaImageHeight()) return () -> ((Resource)((Resource)vanillaResource.get())).open();
            IoSupplier ioSupplier = this.vanillaPackResources.getResource(packType, textureCopy.vanillaLocation());
            return ioSupplier;
        }
        catch (IOException iOException) {
        }
        return () -> ((Resource)((Resource)vanillaResource.get())).open();
    }

    public Set<String> getNamespaces(PackType packType) {
        return Collections.singleton("overflowingbars");
    }

    public void listResources(PackType packType, String namespace, String path, PackResources.ResourceOutput resourceOutput) {
        String prefix = "textures/gui/sprites";
        if (path.startsWith(prefix)) {
            int[] dyes;
            FileToIdConverter textureIdConverter = SpriteSource.TEXTURE_ID_CONVERTER;
            for (int dye : dyes = new int[]{19841, 31863, 291073, 16749568, 11867904, 10098784}) {
                Stream.of(Gui.HeartType.values()).flatMap(NewHealthBarRenderer::getHeartTypeTextureLocations).forEach(resourceLocation -> {
                    ResourceLocation resourceLocation1 = OverflowingBars.id(resourceLocation.getPath()).withSuffix("_" + dye);
                    ResourceLocation resourceLocation2 = resourceLocation.withPrefix(prefix + "/").withSuffix(".png");
                    Optional resource = this.resourceManager.getResource(resourceLocation2);
                    if (resource.isPresent()) {
                        ResourceLocation t = resourceLocation1.withPrefix(prefix + "/").withSuffix(".png");
                        resourceOutput.accept((Object)t, () -> DynamicallyCopiedPackResources.makeImageTranslucent((IoSupplier<InputStream>)((IoSupplier)() -> ((Resource)((Resource)resource.get())).open()), dye));
                    }
                });
            }
        }
    }

    private static InputStream makeImageTranslucent(IoSupplier<InputStream> supplier, int dye) throws IOException {
        try (InputStream inputStream = (InputStream)supplier.get();){
            ByteArrayInputStream byteArrayInputStream;
            block14: {
                NativeImage image = NativeImage.read((InputStream)inputStream);
                try {
                    for (int x = 0; x < image.getWidth(); ++x) {
                        for (int y = 0; y < image.getHeight(); ++y) {
                            int pixel = image.getPixelRGBA(x, y);
                            pixel = DynamicallyCopiedPackResources.colorizePixel(pixel, dye);
                            image.setPixelRGBA(x, y, pixel);
                        }
                    }
                    byteArrayInputStream = new ByteArrayInputStream(image.asByteArray());
                    if (image == null) break block14;
                }
                catch (Throwable throwable) {
                    if (image != null) {
                        try {
                            image.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                image.close();
            }
            return byteArrayInputStream;
        }
    }

    public static int applyBlend(int greyscale, int dye) {
        int r = DynamicallyCopiedPackResources.softLightInt(FastColor.ABGR32.red((int)greyscale), FastColor.ABGR32.red((int)dye));
        int g = DynamicallyCopiedPackResources.softLightInt(FastColor.ABGR32.green((int)greyscale), FastColor.ABGR32.green((int)dye));
        int b = DynamicallyCopiedPackResources.softLightInt(FastColor.ABGR32.blue((int)greyscale), FastColor.ABGR32.blue((int)dye));
        return FastColor.ABGR32.color((int)FastColor.ABGR32.alpha((int)greyscale), (int)b, (int)g, (int)r);
    }

    public static int softLightInt(int a, int b) {
        return Mth.clamp((int)((int)(DynamicallyCopiedPackResources.softLight((double)a / 255.0, (double)b / 255.0) * 255.0)), (int)0, (int)255);
    }

    public static double softLight(double a, double b) {
        if (b < 0.5) {
            return 2.0 * a * b + a * a * (1.0 - 2.0 * b);
        }
        return 2.0 * a * (255.0 - b) + Math.sqrt(a) * (2.0 * b - 1.0);
    }

    public static int lerpColor(int greyscale, int dye, double range) {
        int blueBase = (int)((double)FastColor.ABGR32.blue((int)greyscale) + (double)(FastColor.ABGR32.blue((int)dye) - FastColor.ABGR32.blue((int)greyscale)) * range);
        int greenBase = (int)((double)FastColor.ABGR32.green((int)greyscale) + (double)(FastColor.ABGR32.green((int)dye) - FastColor.ABGR32.green((int)greyscale)) * range);
        int redBase = (int)((double)FastColor.ABGR32.red((int)greyscale) + (double)(FastColor.ABGR32.red((int)dye) - FastColor.ABGR32.red((int)greyscale)) * range);
        return FastColor.ABGR32.color((int)FastColor.ABGR32.alpha((int)greyscale), (int)blueBase, (int)greenBase, (int)redBase);
    }

    public static IntUnaryOperator getColorOverlayOperator(int color) {
        return DynamicallyCopiedPackResources.getColorOverlayOperator(FastColor.ABGR32.red((int)color), FastColor.ABGR32.green((int)color), FastColor.ABGR32.blue((int)color));
    }

    public static IntUnaryOperator getColorOverlayOperator(int redColor, int greenColor, int blueColor) {
        return pixel -> {
            int alphaBase = FastColor.ABGR32.alpha((int)pixel);
            if (alphaBase == 0) {
                return pixel;
            }
            int blueBase = FastColor.ABGR32.blue((int)pixel);
            int greenBase = FastColor.ABGR32.green((int)pixel);
            int redBase = FastColor.ABGR32.red((int)pixel);
            int blue = blueBase < 128 ? 2 * (blueBase * blueColor / 255) : 255 - 2 * (255 - blueBase) * (alphaBase - blueColor) / 255;
            int green = greenBase < 128 ? 2 * (greenBase * greenColor / 255) : 255 - 2 * (255 - greenBase) * (alphaBase - greenColor) / 255;
            int red = redBase < 128 ? 2 * (redBase * redColor / 255) : 255 - 2 * (255 - redBase) * (alphaBase - redColor) / 255;
            return FastColor.ABGR32.color((int)alphaBase, (int)blue, (int)green, (int)red);
        };
    }

    public static int colorizePixel(int argb, int dye) {
        float hue = Color.RGBtoHSB(FastColor.ABGR32.red((int)dye), FastColor.ABGR32.green((int)dye), FastColor.ABGR32.blue((int)dye), null)[0];
        int alpha = argb & 0xFF000000;
        int grayLevel = DynamicallyCopiedPackResources.toGreyscale(argb) & 0xFF;
        float brightness = (float)grayLevel / 255.0f;
        int rgb = Color.HSBtoRGB(hue, 1.0f, brightness);
        argb = rgb & 0xFFFFFF | alpha;
        return argb;
    }

    public static int toGreyscale(int color) {
        int alpha = FastColor.ABGR32.alpha((int)color);
        if (alpha == 0) {
            return color;
        }
        int red = FastColor.ABGR32.red((int)color);
        int green = FastColor.ABGR32.green((int)color);
        int blue = FastColor.ABGR32.blue((int)color);
        int avg = (int)(0.299 * (double)red + 0.587 * (double)green + 0.114 * (double)blue);
        return alpha << 24 | avg << 16 | avg << 8 | avg;
    }

    public record TextureCopy(ResourceLocation vanillaLocation, ResourceLocation destinationLocation, int vanillaImageWidth, int vanillaImageHeight) {
        public TextureCopy {
            if (vanillaLocation.getNamespace().equals(destinationLocation.getNamespace())) {
                throw new IllegalStateException("%s and %s share same namespace".formatted(vanillaLocation, destinationLocation));
            }
            if (!vanillaLocation.getPath().endsWith(".png")) {
                throw new IllegalArgumentException("%s is no texture location".formatted(vanillaLocation));
            }
            if (!destinationLocation.getPath().endsWith(".png")) {
                throw new IllegalArgumentException("%s is no texture location".formatted(destinationLocation));
            }
        }
    }
}

