/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.utils;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.components.CommandSuggestions;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class Fields {
    public static Field suggestionsBuilderList = null;
    public static Field suggestionsBuilderInt = null;
    public static Field suggestionsListRect = null;
    public static Field suggestionsListList = null;
    public static Field commandContextArguments = null;
    public static List<Field> suggestionsBuilderStrings = null;
    @Nullable
    public static Pair<String, Class<?>[]> itemUseOnMethodData = null;
    @Nullable
    public static Pair<String, Class<?>[]> itemAppendHoverTextMethodData = null;

    public static void init() {
        suggestionsBuilderList = Fields.getField(SuggestionsBuilder.class, List.class);
        suggestionsBuilderInt = Fields.getField(SuggestionsBuilder.class, Integer.TYPE);
        suggestionsListRect = Fields.getField(CommandSuggestions.SuggestionsList.class, Rect2i.class);
        suggestionsListList = Fields.getField(CommandSuggestions.SuggestionsList.class, List.class);
        commandContextArguments = Fields.getField(CommandContext.class, Map.class);
        suggestionsBuilderStrings = Fields.getFields(SuggestionsBuilder.class, String.class);
        itemUseOnMethodData = Fields.findMethodName(Item.class, false, InteractionResult.class, new Class[]{UseOnContext.class});
        itemAppendHoverTextMethodData = Fields.findMethodName(Item.class, false, Void.TYPE, new Class[]{ItemStack.class, Item.TooltipContext.class, List.class, TooltipFlag.class});
    }

    private static Field getField(Class<?> declaringClass, Class<?> fieldType) {
        Field[] fields;
        for (Field field : fields = declaringClass.getDeclaredFields()) {
            if (Modifier.isStatic(field.getModifiers()) || !fieldType.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            return field;
        }
        return null;
    }

    private static List<Field> getFields(Class<?> declaringClass, Class<?> fieldType) {
        ArrayList<Field> fields = new ArrayList<Field>(Arrays.asList(declaringClass.getDeclaredFields()));
        fields.removeIf(field -> !fieldType.isAssignableFrom(field.getType()));
        fields.removeIf(field -> Modifier.isStatic(field.getModifiers()));
        fields.forEach(field -> field.setAccessible(true));
        return fields;
    }

    @Nullable
    private static Pair<String, Class<?>[]> findMethodName(Class<?> declaringClass, boolean isStatic, Class<?> returnType, Class<?>[] arguments) {
        Method[] methods;
        for (Method method : methods = declaringClass.getDeclaredMethods()) {
            int modifiers = method.getModifiers();
            if (Modifier.isStatic(modifiers) != isStatic || method.getReturnType() != returnType || method.getParameterCount() != arguments.length) continue;
            Class<?>[] declaredArguments = method.getParameterTypes();
            for (int i = 0; i < arguments.length; ++i) {
                if (declaredArguments[i] == arguments[i]) continue;
                return null;
            }
            return Pair.of((Object)method.getName(), arguments);
        }
        return null;
    }

    public static boolean isMethodOverridden(@Nullable Pair<String, Class<?>[]> data, Object obj, Class<?> superClass) {
        try {
            return data != null && obj.getClass().getMethod((String)data.getLeft(), (Class[])data.getRight()).getDeclaringClass() != superClass;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static <T> List<T> getStaticFields(Class<?> fromClass, Class<T> ofClass) {
        try {
            ArrayList<Object> list = new ArrayList<Object>();
            for (Field field : fromClass.getDeclaredFields()) {
                Object obj;
                if (!Modifier.isStatic(field.getModifiers()) || !Modifier.isPublic(field.getModifiers()) || !ofClass.isAssignableFrom((obj = field.get(null)).getClass())) continue;
                list.add(obj);
            }
            return list;
        }
        catch (Exception exception) {
            return List.of();
        }
    }
}

