/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac.autocomplete.suggestions;

import com.mojang.brigadier.StringReader;
import com.mt1006.nbt_ac.autocomplete.CustomTagParser;
import com.mt1006.nbt_ac.autocomplete.suggestions.CustomSuggestion;
import com.mt1006.nbt_ac.config.ModConfig;
import org.jetbrains.annotations.Nullable;

public class StringSuggestion
extends CustomSuggestion {
    private final String quotedText;

    protected StringSuggestion(String text, @Nullable String subtext, CustomTagParser.Type parserType, StringType stringType, int priority) {
        super(StringSuggestion.getFinalText(text, stringType, parserType.requiresDoubleQuotes), subtext, priority);
        this.quotedText = StringSuggestion.getQuotedText(this.text, stringType, parserType.requiresDoubleQuotes);
    }

    public StringSuggestion(String text, @Nullable String subtext, CustomTagParser.Type parserType, int priority) {
        this(text, subtext, parserType, StringType.OTHER, priority);
    }

    public StringSuggestion(String text, @Nullable String subtext, CustomTagParser.Type parserType) {
        this(text, subtext, parserType, StringType.OTHER, 0);
    }

    @Override
    public String getVisibleText() {
        return this.quotedText;
    }

    private static String getFinalText(String text, StringType stringType, boolean isRawJson) {
        char quoteChar;
        if ((stringType == StringType.ID && ((Boolean)ModConfig.hideMcNamespaceInStrings.val).booleanValue() || stringType == StringType.TAG_ID && ((Boolean)ModConfig.hideMcNamespaceInTags.val).booleanValue()) && text.startsWith("minecraft:")) {
            text = text.substring(10);
        }
        if (!StringSuggestion.strRequiresParsing(text, quoteChar = ModConfig.getDefaultQuotationMark(isRawJson))) {
            return text;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            if (ch == '\\' || ch == quoteChar) {
                builder.append('\\');
            }
            builder.append(ch);
        }
        return builder.toString();
    }

    private static String getQuotedText(String newText, StringType stringType, boolean isRawJson) {
        boolean requiresQuotes;
        boolean bl = requiresQuotes = (stringType == StringType.TAG ? (Boolean)ModConfig.tagQuotationMarks.val : (Boolean)ModConfig.stringQuotationMarks.val) != false || isRawJson;
        if (!requiresQuotes && !(requiresQuotes = StringSuggestion.strRequiresQuotes(newText))) {
            return newText;
        }
        char quoteChar = ModConfig.getDefaultQuotationMark(isRawJson);
        return String.format("%c%s%c", Character.valueOf(quoteChar), newText, Character.valueOf(quoteChar));
    }

    protected static boolean strRequiresParsing(String str, char quoteChar) {
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (ch != quoteChar && ch != '\\') continue;
            return true;
        }
        return false;
    }

    protected static boolean strRequiresQuotes(String str) {
        for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (StringReader.isAllowedInUnquotedString((char)ch) && ch != '.') continue;
            return true;
        }
        return false;
    }

    protected static enum StringType {
        TAG,
        TAG_ID,
        ID,
        FULL_ID,
        OTHER;

    }
}

