/*
 * Decompiled with CFR 0.152.
 */
package com.mt1006.nbt_ac;

import com.mt1006.nbt_ac.NBTac;
import com.mt1006.nbt_ac.NBTacLoaderInterface;
import com.mt1006.nbt_ac.autocomplete.loader.Loader;
import com.mt1006.nbt_ac.config.ModConfig;
import com.mt1006.nbt_ac.neoforge.ConfigScreenFactory;
import com.mt1006.nbt_ac.neoforge.NeoForgeResourceLoader;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModList;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;

@Mod(value="nbt_ac")
public class NBTacNeoForge
implements NBTacLoaderInterface {
    public static final boolean isDedicatedServer = FMLEnvironment.dist.isDedicatedServer();

    public NBTacNeoForge(IEventBus modEventBus) {
        if (isDedicatedServer) {
            return;
        }
        ModLoadingContext.get().registerExtensionPoint(IConfigScreenFactory.class, ConfigScreenFactory::new);
        ((ReloadableResourceManager)Minecraft.getInstance().getResourceManager()).registerReloadListener((PreparableReloadListener)new NeoForgeResourceLoader());
        modEventBus.addListener(this::setup);
        modEventBus.addListener(this::loadComplete);
    }

    public void setup(FMLCommonSetupEvent event) {
        NBTac.init(isDedicatedServer, this);
    }

    public void loadComplete(FMLLoadCompleteEvent event) {
        if (isDedicatedServer) {
            return;
        }
        if (((Boolean)ModConfig.useNewThread.val).booleanValue()) {
            new Thread(Loader::load).start();
        } else {
            Loader.load();
        }
    }

    @Override
    public void appendModVersionIds(Set<String> mods) {
        for (IModInfo modInfo : ModList.get().getMods()) {
            String id = modInfo.getModId();
            ArtifactVersion version = modInfo.getVersion();
            String qualifier = version.getQualifier();
            mods.add(String.format("%s@%d.%d.%d.%d#%s;", id, version.getMajorVersion(), version.getMinorVersion(), version.getIncrementalVersion(), version.getBuildNumber(), qualifier != null ? qualifier : "?"));
        }
    }

    @Override
    public boolean isModPresent(String id) {
        return ModList.get().isLoaded(id);
    }

    @Override
    public boolean isFabric() {
        return false;
    }
}

