/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.recipe.lookup.cache;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import mekanism.api.functions.ConstantPredicates;
import mekanism.api.recipes.MekanismRecipe;
import mekanism.api.recipes.ingredients.InputIngredient;
import mekanism.common.recipe.MekanismRecipeType;
import mekanism.common.recipe.lookup.cache.AbstractInputRecipeCache;
import mekanism.common.recipe.lookup.cache.type.IInputCache;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.util.TriPredicate;
import org.jetbrains.annotations.Nullable;

public abstract class SingleInputRecipeCache<INPUT, INGREDIENT extends InputIngredient<INPUT>, RECIPE extends MekanismRecipe<?>, CACHE extends IInputCache<INPUT, INGREDIENT, RECIPE>>
extends AbstractInputRecipeCache<RECIPE> {
    private final Set<RECIPE> complexRecipes = new HashSet<RECIPE>();
    private final Function<RECIPE, INGREDIENT> inputExtractor;
    private final CACHE cache;

    protected SingleInputRecipeCache(MekanismRecipeType<?, RECIPE, ?> recipeType, Function<RECIPE, INGREDIENT> inputExtractor, CACHE cache) {
        super(recipeType);
        this.inputExtractor = inputExtractor;
        this.cache = cache;
    }

    @Override
    public void clear() {
        super.clear();
        this.cache.clear();
        this.complexRecipes.clear();
    }

    public boolean containsInput(@Nullable Level world, INPUT input) {
        return this.containsInput(world, input, this.inputExtractor, this.cache, this.complexRecipes);
    }

    @Nullable
    public RECIPE findFirstRecipe(@Nullable Level world, INPUT input) {
        if (this.cache.isEmpty(input)) {
            return null;
        }
        this.initCacheIfNeeded(world);
        Object recipe = this.findFirstRecipe(input, this.cache.getRecipes(input));
        return recipe == null ? this.findFirstRecipe(input, this.complexRecipes) : recipe;
    }

    @Nullable
    private RECIPE findFirstRecipe(INPUT input, Iterable<RECIPE> recipes) {
        for (MekanismRecipe recipe : recipes) {
            if (!((Predicate)((Object)recipe)).test(input)) continue;
            return (RECIPE)recipe;
        }
        return null;
    }

    @Nullable
    public RECIPE findTypeBasedRecipe(@Nullable Level world, INPUT input) {
        if (this.cache.isEmpty(input)) {
            return null;
        }
        this.initCacheIfNeeded(world);
        Object recipe = this.cache.findFirstRecipe(input, ConstantPredicates.alwaysTrue());
        if (recipe == null) {
            for (MekanismRecipe complexRecipe : this.complexRecipes) {
                if (!((InputIngredient)this.inputExtractor.apply(complexRecipe)).testType(input)) continue;
                return (RECIPE)complexRecipe;
            }
        }
        return (RECIPE)recipe;
    }

    @Nullable
    public <DATA> RECIPE findTypeBasedRecipe(@Nullable Level world, INPUT input, DATA data, TriPredicate<RECIPE, INPUT, DATA> matchCriteria) {
        if (this.cache.isEmpty(input)) {
            return null;
        }
        this.initCacheIfNeeded(world);
        for (MekanismRecipe recipe : this.cache.getRecipes(input)) {
            if (!matchCriteria.test((Object)recipe, input, data)) continue;
            return (RECIPE)recipe;
        }
        for (MekanismRecipe complexRecipe : this.complexRecipes) {
            if (!((InputIngredient)this.inputExtractor.apply(complexRecipe)).testType(input) || !matchCriteria.test((Object)complexRecipe, input, data)) continue;
            return (RECIPE)complexRecipe;
        }
        return null;
    }

    @Nullable
    public <DATA_1, DATA_2> RECIPE findTypeBasedRecipe(@Nullable Level world, INPUT input, DATA_1 data1, DATA_2 data2, CheckRecipeType<INPUT, RECIPE, DATA_1, DATA_2> matchCriteria) {
        if (this.cache.isEmpty(input)) {
            return null;
        }
        this.initCacheIfNeeded(world);
        for (MekanismRecipe recipe : this.cache.getRecipes(input)) {
            if (!matchCriteria.testType(recipe, input, data1, data2)) continue;
            return (RECIPE)recipe;
        }
        for (MekanismRecipe complexRecipe : this.complexRecipes) {
            if (!((InputIngredient)this.inputExtractor.apply(complexRecipe)).testType(input) || !matchCriteria.testType(complexRecipe, input, data1, data2)) continue;
            return (RECIPE)complexRecipe;
        }
        return null;
    }

    @Override
    protected void initCache(List<RecipeHolder<RECIPE>> recipes) {
        for (RecipeHolder<RECIPE> recipeHolder : recipes) {
            MekanismRecipe recipe = (MekanismRecipe)recipeHolder.value();
            if (!this.cache.mapInputs((MekanismRecipe)recipe, (InputIngredient)((InputIngredient)this.inputExtractor.apply(recipe)))) continue;
            this.complexRecipes.add(recipe);
        }
    }

    @FunctionalInterface
    public static interface CheckRecipeType<INPUT, RECIPE extends MekanismRecipe<?>, DATA_1, DATA_2> {
        public boolean testType(RECIPE var1, INPUT var2, DATA_1 var3, DATA_2 var4);
    }
}

