/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.crafttweaker.recipe.manager;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.recipes.ChemicalToChemicalRecipe;
import mekanism.api.recipes.basic.BasicActivatingRecipe;
import mekanism.api.recipes.basic.BasicCentrifugingRecipe;
import mekanism.api.recipes.ingredients.ChemicalStackIngredient;
import mekanism.api.recipes.vanilla_input.SingleChemicalRecipeInput;
import mekanism.common.integration.crafttweaker.CrTUtils;
import mekanism.common.integration.crafttweaker.chemical.ICrTChemicalStack;
import mekanism.common.integration.crafttweaker.recipe.manager.MekanismRecipeManager;
import mekanism.common.recipe.IMekanismRecipeTypeProvider;
import mekanism.common.recipe.MekanismRecipeType;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.mekanism.recipe.manager.ChemicalToChemical")
public abstract class ChemicalToChemicalRecipeManager
extends MekanismRecipeManager<SingleChemicalRecipeInput, ChemicalToChemicalRecipe> {
    protected ChemicalToChemicalRecipeManager(IMekanismRecipeTypeProvider<SingleChemicalRecipeInput, ChemicalToChemicalRecipe, ?> recipeType) {
        super(recipeType);
    }

    @ZenCodeType.Method
    public void addRecipe(String name, ChemicalStackIngredient input, ICrTChemicalStack output) {
        this.addRecipe(name, this.makeRecipe(input, output));
    }

    public final ChemicalToChemicalRecipe makeRecipe(ChemicalStackIngredient input, ICrTChemicalStack output) {
        return this.makeRecipe(input, this.getAndValidateNotEmpty(output));
    }

    protected abstract ChemicalToChemicalRecipe makeRecipe(ChemicalStackIngredient var1, ChemicalStack var2);

    @Override
    protected String describeOutputs(ChemicalToChemicalRecipe recipe) {
        return CrTUtils.describeOutputs(recipe.getOutputDefinition());
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.ChemicalToChemical.Centrifuging")
    public static class IsotopicCentrifugeRecipeManager
    extends ChemicalToChemicalRecipeManager {
        public static final IsotopicCentrifugeRecipeManager INSTANCE = new IsotopicCentrifugeRecipeManager();

        private IsotopicCentrifugeRecipeManager() {
            super((IMekanismRecipeTypeProvider<SingleChemicalRecipeInput, ChemicalToChemicalRecipe, ?>)MekanismRecipeType.CENTRIFUGING);
        }

        @Override
        protected ChemicalToChemicalRecipe makeRecipe(ChemicalStackIngredient ingredient, ChemicalStack output) {
            return new BasicCentrifugingRecipe(ingredient, output);
        }
    }

    @ZenRegister
    @ZenCodeType.Name(value="mods.mekanism.recipe.manager.ChemicalToChemical.Activating")
    public static class SolarNeutronActivatorRecipeManager
    extends ChemicalToChemicalRecipeManager {
        public static final SolarNeutronActivatorRecipeManager INSTANCE = new SolarNeutronActivatorRecipeManager();

        private SolarNeutronActivatorRecipeManager() {
            super((IMekanismRecipeTypeProvider<SingleChemicalRecipeInput, ChemicalToChemicalRecipe, ?>)MekanismRecipeType.ACTIVATING);
        }

        @Override
        protected ChemicalToChemicalRecipe makeRecipe(ChemicalStackIngredient ingredient, ChemicalStack output) {
            return new BasicActivatingRecipe(ingredient, output);
        }
    }
}

