/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.content.transporter;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import mekanism.api.text.EnumColor;
import mekanism.common.content.filter.FilterType;
import mekanism.common.content.filter.IItemStackFilter;
import mekanism.common.content.transporter.SorterFilter;
import mekanism.common.lib.inventory.Finder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class SorterItemStackFilter
extends SorterFilter<SorterItemStackFilter>
implements IItemStackFilter<SorterItemStackFilter> {
    public static final MapCodec<SorterItemStackFilter> CODEC = RecordCodecBuilder.mapCodec(instance -> SorterItemStackFilter.baseSorterCodec(instance).and((App)ItemStack.SINGLE_ITEM_CODEC.fieldOf("target_stack").forGetter(SorterItemStackFilter::getItemStack)).and((App)Codec.BOOL.optionalFieldOf("fuzzy", (Object)false).forGetter(filter -> filter.fuzzyMode)).apply((Applicative)instance, SorterItemStackFilter::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, SorterItemStackFilter> STREAM_CODEC = StreamCodec.composite(SorterItemStackFilter.baseSorterStreamCodec(SorterItemStackFilter::new), Function.identity(), (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, SorterItemStackFilter::getItemStack, (StreamCodec)ByteBufCodecs.BOOL, filter -> filter.fuzzyMode, (filter, itemType, fuzzyMode) -> {
        filter.itemType = itemType;
        filter.fuzzyMode = fuzzyMode;
        return filter;
    });
    private ItemStack itemType = ItemStack.EMPTY;
    public boolean fuzzyMode;

    public SorterItemStackFilter() {
    }

    protected SorterItemStackFilter(boolean enabled, boolean allowDefault, boolean sizeMode, int min, int max, Optional<EnumColor> color, ItemStack itemType, boolean fuzzyMode) {
        super(enabled, allowDefault, sizeMode, min, max, color.orElse(null));
        this.itemType = itemType;
        this.fuzzyMode = fuzzyMode;
    }

    public SorterItemStackFilter(SorterItemStackFilter filter) {
        super(filter);
        this.itemType = filter.itemType.copy();
        this.fuzzyMode = filter.fuzzyMode;
    }

    @Override
    public Finder getFinder() {
        return this.fuzzyMode ? Finder.item(this.itemType) : Finder.strict(this.itemType);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.itemType.getItem().hashCode();
        result = 31 * result + Boolean.hashCode(this.fuzzyMode);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass() || !super.equals(o)) {
            return false;
        }
        SorterItemStackFilter other = (SorterItemStackFilter)o;
        if (this.fuzzyMode == other.fuzzyMode) {
            if (this.fuzzyMode) {
                return this.itemType.is(other.itemType.getItemHolder());
            }
            return ItemStack.isSameItemSameComponents((ItemStack)this.itemType, (ItemStack)other.itemType);
        }
        return false;
    }

    @Override
    public SorterItemStackFilter clone() {
        return new SorterItemStackFilter(this);
    }

    @Override
    public FilterType getFilterType() {
        return FilterType.SORTER_ITEMSTACK_FILTER;
    }

    @Override
    @NotNull
    public ItemStack getItemStack() {
        return this.itemType;
    }

    @Override
    public void setItemStack(@NotNull ItemStack stack) {
        this.itemType = stack;
    }
}

