/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.recipe;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.MustBeInvokedByOverriders;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.context.ActionContext;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.contextual.Chance;
import snownee.lychee.util.BoundsExtensions;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.contextual.ContextualCondition;
import snownee.lychee.util.input.ExtendedItemStackHolder;
import snownee.lychee.util.input.ItemStackHolderCollection;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.BlockKeyableRecipe;
import snownee.lychee.util.recipe.ChanceRecipe;
import snownee.lychee.util.recipe.LycheeRecipeType;

public class BlockKeyableRecipeType<R extends BlockKeyableRecipe>
extends LycheeRecipeType<R> {
    protected final Map<Block, List<RecipeHolder<R>>> recipesByBlock = Maps.newHashMap();
    protected final List<RecipeHolder<R>> anyBlockRecipes = Lists.newLinkedList();
    public boolean extractChance;

    public BlockKeyableRecipeType(String name, Class<R> clazz, @Nullable LootContextParamSet paramSet) {
        super(name, clazz, paramSet);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @MustBeInvokedByOverriders
    public void refreshCache() {
        this.recipesByBlock.clear();
        this.anyBlockRecipes.clear();
        super.refreshCache();
        ArrayListMultimap multimap = ArrayListMultimap.create();
        for (RecipeHolder recipeHolder : this.recipes) {
            ContextualCondition condition;
            Iterator<ContextualCondition> iterator = ((BlockKeyableRecipe)recipeHolder.value()).conditions().iterator();
            if (iterator.hasNext() && (condition = iterator.next()) instanceof Chance) {
                float chance2;
                Chance chance = (Chance)condition;
                try {
                    float f;
                    chance2 = f = chance.chance();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                Recipe recipe = recipeHolder.value();
                if (recipe instanceof ChanceRecipe) {
                    ChanceRecipe chanceRecipe = (ChanceRecipe)recipe;
                    chanceRecipe.setChance(chance2);
                }
            }
            if (BlockPredicateExtensions.isAny(((BlockKeyableRecipe)recipeHolder.value()).blockPredicate())) {
                this.anyBlockRecipes.add(recipeHolder);
                continue;
            }
            for (Block block : BlockPredicateExtensions.matchedBlocks(((BlockKeyableRecipe)recipeHolder.value()).blockPredicate())) {
                multimap.put((Object)block, (Object)recipeHolder);
            }
        }
        Iterator<Object> iterator = multimap.asMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            this.recipesByBlock.put((Block)entry.getKey(), List.copyOf((Collection)entry.getValue()));
        }
        return;
    }

    @Override
    public Comparator<RecipeHolder<R>> comparator() {
        return Comparator.comparing(RecipeHolder::value, Comparator.comparing($ -> !BlockPredicateExtensions.isAny($.blockPredicate())).thenComparingInt($ -> $.getIngredients().size()).thenComparing($ -> !$.maxRepeats().isAny()).thenComparing(Recipe::isSpecial).reversed());
    }

    public List<ItemStack> blockKeysToItems() {
        return this.recipesByBlock.keySet().stream().map(Block::asItem).filter($ -> $ != Items.AIR).sorted(Comparator.comparingInt(Item::getId)).map(Item::getDefaultInstance).toList();
    }

    public Optional<R> process(Player player, InteractionHand hand, BlockPos pos, Vec3 origin, LycheeContext context) {
        if (this.isEmpty()) {
            return Optional.empty();
        }
        Level level = player.level();
        BlockState blockstate = level.getBlockState(pos);
        List<RecipeHolder<R>> recipes = this.recipesByBlock.getOrDefault(blockstate.getBlock(), List.of());
        if (recipes.isEmpty() && this.anyBlockRecipes.isEmpty()) {
            return Optional.empty();
        }
        LootParamsContext lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        lootParams.set(LootContextParams.ORIGIN, CommonProxy.clampPos(origin, pos));
        lootParams.set(LootContextParams.THIS_ENTITY, player);
        lootParams.set(LootContextParams.BLOCK_STATE, blockstate);
        lootParams.set(LycheeLootContextParams.BLOCK_POS, pos);
        lootParams.validate();
        ItemStack stack = player.getItemInHand(hand);
        ItemStack otherStack = player.getItemInHand(hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        context.put(LycheeContextKey.ITEM, ItemStackHolderCollection.Inventory.of(context, stack, otherStack));
        ItemStackHolderCollection itemContext = context.get(LycheeContextKey.ITEM);
        ActionContext actionContext = context.get(LycheeContextKey.ACTION);
        Iterable<RecipeHolder<R>> iterable = this.mergeAnyBlockRecipes(recipes);
        for (RecipeHolder<R> recipeHolder : iterable) {
            if (!this.tryMatch(recipeHolder, level, context).isPresent()) continue;
            context.put(recipeHolder);
            BlockKeyableRecipe recipe = (BlockKeyableRecipe)recipeHolder.value();
            if (!level.isClientSide && recipe.tickOrApply(context)) {
                int times;
                if (recipe.sizedIngredients().size() == 1) {
                    ((ExtendedItemStackHolder)itemContext.get(1)).setConsumption(0);
                }
                for (int i = 0; i < recipe.sizedIngredients().size(); ++i) {
                    ((ExtendedItemStackHolder)itemContext.get(i)).setConsumption(recipe.sizedIngredients().get(i).count());
                }
                if (recipe.maxRepeats() == BoundsExtensions.ONE) {
                    times = 1;
                } else {
                    times = Integer.MAX_VALUE;
                    for (ExtendedItemStackHolder holder : itemContext) {
                        if (holder.getConsumption() == 0) continue;
                        int count = holder.get().getCount() / holder.getConsumption();
                        if (count == 0) {
                            return Optional.empty();
                        }
                        times = Math.min(times, count);
                    }
                }
                times = recipe.getRandomRepeats(Math.max(1, times), context);
                recipe.applyPostActions(context, times);
                itemContext.postApply(!actionContext.avoidDefault, times);
                player.setItemInHand(hand, context.getItem(0));
                player.setItemInHand(hand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND, context.getItem(1));
            }
            return Optional.of(recipe);
        }
        return Optional.empty();
    }

    public boolean has(Block block) {
        return !this.anyBlockRecipes.isEmpty() || this.recipesByBlock.containsKey(block);
    }

    public boolean has(BlockState state) {
        return this.has(state.getBlock());
    }

    @Nullable
    public RecipeHolder<R> process(Level level, BlockState state, LycheeContext context) {
        List<RecipeHolder<R>> recipes = this.recipesByBlock.getOrDefault(state.getBlock(), List.of());
        Iterable<RecipeHolder<R>> iterable = this.mergeAnyBlockRecipes(recipes);
        for (RecipeHolder<R> recipe : iterable) {
            ChanceRecipe chance;
            if (this.extractChance && (chance = (ChanceRecipe)recipe.value()).getChance() != 1.0f && chance.getChance() <= context.get(LycheeContextKey.RANDOM).nextFloat() || !this.tryMatch(recipe, level, context).isPresent()) continue;
            context.put(recipe);
            ((BlockKeyableRecipe)recipe.value()).applyPostActions(context, 1);
            return recipe;
        }
        return null;
    }

    public Iterable<RecipeHolder<R>> mergeAnyBlockRecipes(List<RecipeHolder<R>> recipes) {
        if (this.anyBlockRecipes.isEmpty()) {
            return recipes;
        }
        if (recipes.isEmpty()) {
            return this.anyBlockRecipes;
        }
        return Iterables.concat(recipes, this.anyBlockRecipes);
    }
}

