/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.input;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.input.ExtendedItemStackHolder;
import snownee.lychee.util.input.ItemStackHolder;

public abstract class ItemStackHolderCollection
extends ArrayList<ExtendedItemStackHolder> {
    public final List<ItemStack> stacksNeedHandle = Lists.newArrayList();

    public static ItemStackHolderCollection empty() {
        return InWorld.of(new ItemEntity[0]);
    }

    protected ItemStackHolderCollection(ItemStackHolder ... holders) {
        for (ItemStackHolder holder : holders) {
            this.add(new ExtendedItemStackHolder(holder));
        }
    }

    public ItemStackHolder split(int index, int amount) {
        ExtendedItemStackHolder holder = (ExtendedItemStackHolder)this.get(index);
        ItemStack original = holder.get();
        ItemStack split = holder.split(amount);
        if (!original.isEmpty()) {
            this.stacksNeedHandle.add(original);
        }
        holder.set(split);
        return holder;
    }

    public ItemStackHolder replace(int index, ItemStack item) {
        ExtendedItemStackHolder holder = (ExtendedItemStackHolder)this.get(index);
        ItemStack original = holder.replace(item);
        if (!original.isEmpty()) {
            this.stacksNeedHandle.add(original);
        }
        this.set(index, holder);
        return holder;
    }

    protected int consumeInputs(int times) {
        int result = 0;
        for (ExtendedItemStackHolder holder : this) {
            if (holder.getConsumption() == 0 || holder.get().isEmpty()) continue;
            ItemStack stack = holder.split(times * holder.getConsumption());
            result += stack.getCount();
        }
        return result;
    }

    public abstract int postApply(boolean var1, int var2);

    public static class InWorld
    extends ItemStackHolderCollection {
        private ItemEntity itemEntity;

        public InWorld(ItemStackHolder.Entity ... holders) {
            super(holders);
            if (holders.length > 0) {
                this.itemEntity = holders[0].getEntity();
            }
        }

        public static ItemStackHolderCollection of(ItemEntity ... entities) {
            return new InWorld((ItemStackHolder.Entity[])Stream.of(entities).map(ItemStackHolder.Entity::new).toArray(ItemStackHolder.Entity[]::new));
        }

        @Override
        public int postApply(boolean consumeInputs, int times) {
            for (ItemStack stack : this.stacksNeedHandle) {
                if (stack.isEmpty()) continue;
                Vec3 pos = this.itemEntity.position();
                ItemEntity newEntity = new ItemEntity(this.itemEntity.level(), pos.x, pos.y, pos.z, stack);
                this.itemEntity.level().addFreshEntity((Entity)newEntity);
            }
            return consumeInputs ? this.consumeInputs(times) : 0;
        }
    }

    public static class Inventory
    extends ItemStackHolderCollection {
        private final LycheeContext context;

        public Inventory(LycheeContext context, ItemStackHolder.Direct ... holders) {
            super(holders);
            this.context = context;
        }

        public static ItemStackHolderCollection of(LycheeContext ctx, ItemStack ... items) {
            return new Inventory(ctx, (ItemStackHolder.Direct[])Stream.of(items).map(ItemStackHolder.Direct::new).toArray(ItemStackHolder.Direct[]::new));
        }

        @Override
        public int postApply(boolean consumeInputs, int times) {
            LootParamsContext lootParams = this.context.get(LycheeContextKey.LOOT_PARAMS);
            Level level = this.context.level();
            Entity entity = (Entity)lootParams.getOrNull(LootContextParams.THIS_ENTITY);
            Player player = null;
            if (entity instanceof Player) {
                Player playerEntity;
                player = playerEntity = (Player)entity;
            }
            Vec3 pos = (Vec3)lootParams.getOrNull(LootContextParams.ORIGIN);
            for (ItemStack stack : this.stacksNeedHandle) {
                if (player != null) {
                    if (player.addItem(stack)) continue;
                    player.drop(stack, false);
                    continue;
                }
                if (pos == null) continue;
                CommonProxy.dropItemStack(level, pos.x, pos.y, pos.z, stack, null);
            }
            return consumeInputs ? this.consumeInputs(times) : 0;
        }
    }
}

