/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util.action;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.util.context.LycheeContext;

public final class ActionData {
    public static final Codec<ActionData> CODEC = RecordCodecBuilder.create(i -> i.group((App)LycheeContext.CODEC.fieldOf("context").forGetter(ActionData::getContext), (App)Codec.INT.fieldOf("delayedTicks").forGetter(ActionData::getDelayedTicks)).apply((Applicative)i, ActionData::new));
    private LycheeContext context;
    private int delayedTicks;

    public ActionData(LycheeContext context, int delayedTicks) {
        this.context = context;
        this.delayedTicks = delayedTicks;
    }

    public LycheeContext getContext() {
        return this.context;
    }

    public void setContext(@Nullable LycheeContext context) {
        this.context = context;
    }

    public int getDelayedTicks() {
        return this.delayedTicks;
    }

    public int consumeDelayedTicks() {
        return this.delayedTicks--;
    }

    public void setDelayedTicks(int delayedTicks) {
        this.delayedTicks = delayedTicks;
    }

    public void addDelayedTicks(int ticks) {
        this.delayedTicks += ticks;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("context", (Object)this.context.toString()).append("delayedTicks", this.delayedTicks).toString();
    }
}

