/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.context.ItemShapelessContext;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.recipes.ItemInsideRecipeType;
import snownee.lychee.util.IngredientCollection;
import snownee.lychee.util.LycheeCounter;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.BlockKeyableRecipe;
import snownee.lychee.util.recipe.ItemShapelessRecipeUtils;
import snownee.lychee.util.recipe.LycheeRecipe;
import snownee.lychee.util.recipe.LycheeRecipeCommonProperties;
import snownee.lychee.util.recipe.LycheeRecipeSerializer;

public class ItemInsideRecipe
extends LycheeRecipe<LycheeContext>
implements BlockKeyableRecipe {
    protected final BlockPredicate blockPredicate;
    protected final int time;
    protected boolean special;
    protected IngredientCollection ingredients;

    public ItemInsideRecipe(LycheeRecipeCommonProperties commonProperties, BlockPredicate blockPredicate, int time, IngredientCollection ingredients) {
        super(commonProperties);
        this.blockPredicate = blockPredicate;
        this.time = time;
        this.ingredients = ingredients;
        this.onConstructed();
    }

    public int time() {
        return this.time;
    }

    public boolean isSpecial() {
        return this.special;
    }

    @Override
    public BlockPredicate blockPredicate() {
        return this.blockPredicate;
    }

    @Override
    public boolean tickOrApply(LycheeContext context) {
        LootParamsContext lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        LycheeCounter counter = (LycheeCounter)lootParams.get(LootContextParams.THIS_ENTITY);
        if (counter.lychee$getCount() >= this.time) {
            counter.lychee$setRecipeId(null);
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(LycheeContext context, Level level) {
        ItemShapelessContext itemShapelessContext = context.get(LycheeContextKey.ITEM_SHAPELESS);
        if (itemShapelessContext.totalItems < this.ingredients.size()) {
            return false;
        }
        if (!BlockPredicateExtensions.isAny(this.blockPredicate) && !BlockPredicateExtensions.matches(this.blockPredicate, context)) {
            return false;
        }
        return ItemShapelessRecipeUtils.matches(context, this.ingredients);
    }

    @Override
    public LycheeRecipeSerializer<ItemInsideRecipe> getSerializer() {
        return RecipeSerializers.ITEM_INSIDE;
    }

    @Override
    public ItemInsideRecipeType getType() {
        return RecipeTypes.ITEM_INSIDE;
    }

    @Override
    public IngredientCollection ingredientCollection() {
        return this.ingredients;
    }

    public static class Serializer
    implements LycheeRecipeSerializer<ItemInsideRecipe> {
        public static final MapCodec<ItemInsideRecipe> CODEC = ItemShapelessRecipeUtils.validatedCodec(RecordCodecBuilder.mapCodec(instance -> instance.group((App)LycheeRecipeCommonProperties.SIMPLE_MAP_CODEC.forGetter(LycheeRecipe::commonProperties), (App)BlockPredicateExtensions.CODEC_FOR_TESTING.optionalFieldOf("block_in", (Object)BlockPredicateExtensions.ANY).forGetter(ItemInsideRecipe::blockPredicate), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("time", (Object)0).forGetter(ItemInsideRecipe::time), (App)IngredientCollection.codec(1, Integer.MAX_VALUE).fieldOf("item_in").forGetter(ItemInsideRecipe::ingredientCollection)).apply((Applicative)instance, ItemInsideRecipe::new)));
        public static final StreamCodec<RegistryFriendlyByteBuf, ItemInsideRecipe> STREAM_CODEC = StreamCodec.composite(LycheeRecipeCommonProperties.STREAM_CODEC, LycheeRecipe::commonProperties, (StreamCodec)BlockPredicate.STREAM_CODEC, ItemInsideRecipe::blockPredicate, (StreamCodec)ByteBufCodecs.VAR_INT, ItemInsideRecipe::time, IngredientCollection.STREAM_CODEC, ItemInsideRecipe::ingredientCollection, ItemInsideRecipe::new);

        @Override
        public MapCodec<ItemInsideRecipe> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, ItemInsideRecipe> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

