/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.contextual;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.FluidPredicate;
import net.minecraft.advancements.critereon.LightPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.BoundsExtensions;
import snownee.lychee.util.ClientProxy;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.RegistryEntryDisplay;
import snownee.lychee.util.codec.LycheeCodecs;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.contextual.ContextualCondition;
import snownee.lychee.util.contextual.ContextualConditionDisplay;
import snownee.lychee.util.contextual.ContextualConditionType;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record Location(LocationCheck check) implements ContextualCondition
{
    public static final ImmutableList<Rule<?>> RULES = Location.bootstrapRules();

    private static ImmutableList<Rule<?>> bootstrapRules() {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)new PosRule("x", it -> it.position().map(LocationPredicate.PositionPredicate::x), Vec3::x));
        builder.add((Object)new PosRule("y", it -> it.position().map(LocationPredicate.PositionPredicate::y), Vec3::y));
        builder.add((Object)new PosRule("z", it -> it.position().map(LocationPredicate.PositionPredicate::z), Vec3::z));
        builder.add((Object)new DimensionRule());
        builder.add((Object)new FeatureRule());
        builder.add((Object)new BiomeRule());
        builder.add((Object)new BlockRule());
        builder.add((Object)new FluidRule());
        builder.add((Object)new LightRule());
        builder.add((Object)new SmokeyRule());
        builder.add((Object)new CanSeeSkyRule());
        return builder.build();
    }

    public ContextualConditionType<Location> type() {
        return ContextualConditionType.LOCATION;
    }

    @Override
    public int test(@Nullable ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        Level level = ctx.level();
        LootParamsContext lootParams = ctx.get(LycheeContextKey.LOOT_PARAMS);
        if (level.isClientSide) {
            return this.testClient(level, lootParams.get(LycheeLootContextParams.BLOCK_POS), (Vec3)lootParams.get(LootContextParams.ORIGIN)).get() ? times : 0;
        }
        return this.check.test(lootParams.asLootContext()) ? times : 0;
    }

    @Override
    public TriState testForTooltips(Level level, @Nullable Player player) {
        if (player == null) {
            return TriState.DEFAULT;
        }
        if (!BlockPos.ZERO.equals((Object)this.check.offset())) {
            return TriState.DEFAULT;
        }
        Vec3 vec = player.position();
        BlockPos pos = player.blockPosition();
        return this.testClient(level, pos, vec);
    }

    public TriState testClient(Level level, BlockPos pos, Vec3 vec) {
        if (this.check.predicate().isEmpty()) {
            return TriState.TRUE;
        }
        BlockPos offset = this.check.offset();
        if (!BlockPos.ZERO.equals((Object)offset)) {
            pos = pos.offset(offset.getX(), offset.getY(), offset.getZ());
        }
        LocationPredicate predicate = (LocationPredicate)this.check.predicate().get();
        TriState finalResult = TriState.TRUE;
        for (Rule rule : RULES) {
            if (rule.isEmpty(predicate)) continue;
            TriState result = rule.testClient(rule.cast(predicate), level, pos, vec);
            if (result == TriState.FALSE) {
                return result;
            }
            if (result != TriState.DEFAULT) continue;
            finalResult = TriState.DEFAULT;
        }
        return finalResult;
    }

    @Override
    public void appendToTooltips(List<Component> tooltips, Level level, @Nullable Player player, int indent, boolean inverted) {
        TriState result;
        if (this.check.predicate().isEmpty()) {
            return;
        }
        LocationPredicate predicate = (LocationPredicate)this.check.predicate().get();
        boolean test = false;
        Vec3 vec = null;
        BlockPos pos = null;
        String key = this.getDescriptionId(inverted);
        boolean noOffset = BlockPos.ZERO.equals((Object)this.check.offset());
        if (!noOffset) {
            BlockPos offset = this.check.offset();
            MutableComponent content = Component.translatable((String)key, (Object[])new Object[]{offset.getX(), offset.getY(), offset.getZ()}).withStyle(ChatFormatting.GRAY);
            result = this.testForTooltips(level, player);
            ContextualConditionDisplay.appendToTooltips(tooltips, result, indent, content);
            ++indent;
        }
        if (noOffset && player != null) {
            test = true;
            vec = player.position();
            pos = player.blockPosition();
        }
        for (Rule rule : RULES) {
            if (rule.isEmpty(predicate)) continue;
            result = TriState.DEFAULT;
            if (test) {
                result = rule.testClient(rule.cast(predicate), level, pos, vec);
            }
            rule.appendToTooltips(tooltips, indent, key, rule.cast(predicate), result);
        }
    }

    @Override
    public int showingCount() {
        int c = 0;
        if (this.check.predicate().isEmpty()) {
            return c;
        }
        LocationPredicate predicate = (LocationPredicate)this.check.predicate().get();
        for (Rule rule : RULES) {
            if (rule.isEmpty(predicate)) continue;
            ++c;
        }
        return c;
    }

    private static class PosRule
    extends Rule<MinMaxBounds.Doubles> {
        private final Function<Vec3, Double> valueGetter;

        private PosRule(String name, Function<LocationPredicate, Optional<MinMaxBounds.Doubles>> boundsGetter, Function<Vec3, Double> valueGetter) {
            super(name, boundsGetter);
            this.valueGetter = valueGetter;
        }

        @Override
        public boolean isEmpty(LocationPredicate predicate) {
            return super.isEmpty(predicate) || ((MinMaxBounds.Doubles)((Optional)this.getter.apply(predicate)).orElseThrow()).isAny();
        }

        @Override
        public TriState testClient(MinMaxBounds.Doubles value, Level level, BlockPos pos, Vec3 vec) {
            return TriState.of((boolean)value.matches(this.valueGetter.apply(vec).doubleValue()));
        }

        @Override
        public void appendToTooltips(List<Component> tooltips, int indent, String key, MinMaxBounds.Doubles value, TriState result) {
            ContextualConditionDisplay.appendToTooltips(tooltips, result, indent, Component.translatable((String)(key + "." + this.name), (Object[])new Object[]{BoundsExtensions.getDescription(value)}));
        }
    }

    private static class DimensionRule
    extends Rule<ResourceKey<Level>> {
        private DimensionRule() {
            super("dimension", LocationPredicate::dimension);
        }

        @Override
        public TriState testClient(ResourceKey<Level> value, Level level, BlockPos pos, Vec3 vec) {
            return TriState.of((value == level.dimension() ? 1 : 0) != 0);
        }

        @Override
        public void appendToTooltips(List<Component> tooltips, int indent, String key, ResourceKey<Level> value, TriState result) {
            MutableComponent displayName = RegistryEntryDisplay.of(value, Registries.DIMENSION).withStyle(ChatFormatting.WHITE);
            ContextualConditionDisplay.appendToTooltips(tooltips, result, indent, Component.translatable((String)(key + "." + this.name), (Object[])new Object[]{displayName}));
        }
    }

    private static class FeatureRule
    extends Rule<HolderSet<Structure>> {
        private FeatureRule() {
            super("feature", LocationPredicate::structures);
        }

        @Override
        public void appendToTooltips(List<Component> tooltips, int indent, String key, HolderSet<Structure> value, TriState result) {
            MutableComponent displayName = RegistryEntryDisplay.of(value, Registries.STRUCTURE).withStyle(ChatFormatting.WHITE);
            ContextualConditionDisplay.appendToTooltips(tooltips, result, indent, Component.translatable((String)(key + "." + this.name), (Object[])new Object[]{displayName}));
        }
    }

    private static class BiomeRule
    extends Rule<HolderSet<Biome>> {
        private BiomeRule() {
            super("biome", LocationPredicate::biomes);
        }

        @Override
        public TriState testClient(HolderSet<Biome> value, Level level, BlockPos pos, Vec3 vec) {
            return TriState.of((boolean)value.contains(level.getBiome(pos)));
        }

        @Override
        public void appendToTooltips(List<Component> tooltips, int indent, String key, HolderSet<Biome> value, TriState result) {
            MutableComponent displayName = RegistryEntryDisplay.of(value, Registries.BIOME).withStyle(ChatFormatting.WHITE);
            ContextualConditionDisplay.appendToTooltips(tooltips, result, indent, Component.translatable((String)(key + "." + this.name), (Object[])new Object[]{displayName}));
        }
    }

    private static class BlockRule
    extends Rule<BlockPredicate> {
        private BlockRule() {
            super("block", LocationPredicate::block);
        }

        @Override
        public void appendToTooltips(List<Component> tooltips, int indent, String key, BlockPredicate value, TriState result) {
            Block block = CommonProxy.getCycledItem(List.copyOf(BlockPredicateExtensions.matchedBlocks(value)), Blocks.AIR, 1000);
            MutableComponent displayName = block.getName().withStyle(ChatFormatting.WHITE);
            if (value.properties().isPresent() || value.nbt().isPresent()) {
                displayName.append("*");
            }
            ContextualConditionDisplay.appendToTooltips(tooltips, result, indent, Component.translatable((String)(key + "." + this.name), (Object[])new Object[]{displayName}));
        }

        @Override
        public TriState testClient(BlockPredicate value, Level level, BlockPos pos, Vec3 vec) {
            return TriState.of((boolean)BlockPredicateExtensions.unsafeMatches(level, value, level.getBlockState(pos), () -> level.getBlockEntity(pos)));
        }
    }

    private static class FluidRule
    extends Rule<FluidPredicate> {
        private FluidRule() {
            super("fluid", LocationPredicate::fluid);
        }

        @Override
        public void appendToTooltips(List<Component> tooltips, int indent, String key, FluidPredicate value, TriState result) {
            List fluids = value.fluids().map($ -> $.stream().map(Holder::value).toList()).orElse(List.of());
            Fluid fluid = CommonProxy.getCycledItem(fluids, Fluids.EMPTY, 1000);
            MutableComponent displayName = ClientProxy.getFluidName(fluid).copy().withStyle(ChatFormatting.WHITE);
            if (value.properties().isPresent()) {
                displayName.append("*");
            }
            ContextualConditionDisplay.appendToTooltips(tooltips, result, indent, Component.translatable((String)(key + "." + this.name), (Object[])new Object[]{displayName}));
        }
    }

    private static class LightRule
    extends Rule<LightPredicate> {
        private LightRule() {
            super("light", LocationPredicate::light);
        }

        @Override
        public TriState testClient(LightPredicate value, Level level, BlockPos pos, Vec3 vec) {
            int brightness = level.getMaxLocalRawBrightness(pos);
            return TriState.of((boolean)value.composite().matches(brightness));
        }

        @Override
        public void appendToTooltips(List<Component> tooltips, int indent, String key, LightPredicate value, TriState result) {
            MutableComponent displayName = BoundsExtensions.getDescription(value.composite());
            ContextualConditionDisplay.appendToTooltips(tooltips, result, indent, Component.translatable((String)(key + "." + this.name), (Object[])new Object[]{displayName}));
        }
    }

    private static class SmokeyRule
    extends Rule<Boolean> {
        private SmokeyRule() {
            super("smokey", LocationPredicate::smokey);
        }

        @Override
        public void appendToTooltips(List<Component> tooltips, int indent, String key, Boolean value, TriState result) {
            key = (String)key + "." + this.name;
            if (!value.booleanValue()) {
                key = (String)key + ".not";
            }
            ContextualConditionDisplay.appendToTooltips(tooltips, result, indent, Component.translatable((String)key));
        }
    }

    private static class CanSeeSkyRule
    extends Rule<Boolean> {
        private CanSeeSkyRule() {
            super("can_see_sky", LocationPredicate::canSeeSky);
        }

        @Override
        public void appendToTooltips(List<Component> tooltips, int indent, String key, Boolean value, TriState result) {
            key = (String)key + "." + this.name;
            if (!value.booleanValue()) {
                key = (String)key + ".not";
            }
            ContextualConditionDisplay.appendToTooltips(tooltips, result, indent, Component.translatable((String)key));
        }
    }

    public static abstract class Rule<T> {
        public final String name;
        protected final Function<LocationPredicate, Optional<T>> getter;

        protected Rule(String name, Function<LocationPredicate, Optional<T>> getter) {
            this.name = name;
            this.getter = getter;
        }

        public boolean isEmpty(LocationPredicate predicate) {
            return this.getter.apply(predicate).isEmpty();
        }

        public final <Any> Any cast(LocationPredicate predicate) {
            return (Any)this.getter.apply(predicate).orElseThrow();
        }

        public TriState testClient(T value, Level level, BlockPos pos, Vec3 vec) {
            return TriState.DEFAULT;
        }

        public abstract void appendToTooltips(List<Component> var1, int var2, String var3, T var4, TriState var5);
    }

    public static class Type
    implements ContextualConditionType<Location> {
        private static final MapCodec<LocationCheck> LOCATION_CHECK_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LocationPredicate.CODEC.optionalFieldOf("predicate").forGetter(LocationCheck::predicate), (App)LycheeCodecs.OFFSET.forGetter(LocationCheck::offset)).apply((Applicative)instance, LocationCheck::new));
        public static final MapCodec<Location> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)LOCATION_CHECK_CODEC.forGetter(Location::check)).apply((Applicative)instance, Location::new));

        @Override
        public MapCodec<Location> codec() {
            return CODEC;
        }
    }
}

