/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer.jei.display;

import java.util.List;
import java.util.stream.Stream;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Unmodifiable;
import snownee.lychee.recipes.AnvilCraftingRecipe;

public record AnvilCraftingDisplay(RecipeHolder<AnvilCraftingRecipe> recipeHolder, List<ItemStack> left, List<ItemStack> right) implements IJeiAnvilRecipe
{
    public static AnvilCraftingDisplay of(RecipeHolder<AnvilCraftingRecipe> recipeHolder) {
        AnvilCraftingRecipe recipe = (AnvilCraftingRecipe)recipeHolder.value();
        NonNullList<Ingredient> ingredients = recipe.getIngredients();
        List<ItemStack> left = List.of(((Ingredient)ingredients.getFirst()).getItems());
        List<ItemStack> right = ingredients.size() == 1 ? List.of() : Stream.of(((Ingredient)ingredients.getLast()).getItems()).map(ItemStack::copy).peek(it -> it.setCount(recipe.materialCost())).toList();
        return new AnvilCraftingDisplay(recipeHolder, left, right);
    }

    public @Unmodifiable List<ItemStack> getLeftInputs() {
        return this.left;
    }

    public @Unmodifiable List<ItemStack> getRightInputs() {
        return this.right;
    }

    public @Unmodifiable List<ItemStack> getOutputs() {
        return List.of(((AnvilCraftingRecipe)this.recipeHolder.value()).output());
    }

    public ResourceLocation getUid() {
        return this.recipeHolder.id();
    }
}

