/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer.emi.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import snownee.lychee.compat.recipeviewer.emi.LycheeEMIPlugin;
import snownee.lychee.recipes.AnvilCraftingRecipe;

public class LycheeEmiAnvilRecipe
implements EmiRecipe {
    private final RecipeHolder<AnvilCraftingRecipe> recipe;
    private List<EmiIngredient> inputs;
    private List<EmiStack> outputs;

    public LycheeEmiAnvilRecipe(RecipeHolder<AnvilCraftingRecipe> recipe) {
        this.recipe = recipe;
        this.inputs = ((AnvilCraftingRecipe)recipe.value()).getIngredients().stream().map(EmiIngredient::of).toList();
        this.outputs = List.of(EmiStack.of((ItemStack)((AnvilCraftingRecipe)recipe.value()).output()));
    }

    public EmiRecipeCategory getCategory() {
        return VanillaEmiRecipeCategories.ANVIL_REPAIRING;
    }

    public ResourceLocation getId() {
        return this.recipe.id();
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return this.outputs;
    }

    public int getDisplayWidth() {
        return 125;
    }

    public int getDisplayHeight() {
        return 18;
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.PLUS, 27, 3);
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 75, 1);
        widgets.addSlot(this.inputs.getFirst(), 0, 0);
        widgets.addSlot((EmiIngredient)(this.inputs.size() == 2 ? this.inputs.getLast() : EmiStack.EMPTY), 49, 0);
        widgets.addSlot((EmiIngredient)this.outputs.getFirst(), 107, 0).recipeContext((EmiRecipe)this);
        LycheeEMIPlugin.addInfoIcon(widgets, this.recipe, 75, 1);
    }
}

