/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.compat.recipeviewer.emi;

import dev.emi.emi.api.EmiEntrypoint;
import dev.emi.emi.api.EmiPlugin;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import snownee.lychee.RecipeTypes;
import snownee.lychee.client.gui.RenderElement;
import snownee.lychee.compat.recipeviewer.RvPlugin;
import snownee.lychee.compat.recipeviewer.category.RvCategory;
import snownee.lychee.compat.recipeviewer.category.RvCategoryInstance;
import snownee.lychee.compat.recipeviewer.emi.category.EmiRvHelper;
import snownee.lychee.compat.recipeviewer.emi.category.RvCategoryAdapter;
import snownee.lychee.compat.recipeviewer.emi.element.EmiWidgetAdapter;
import snownee.lychee.compat.recipeviewer.emi.recipe.EmiRecipeAdapter;
import snownee.lychee.compat.recipeviewer.emi.recipe.LycheeEmiAnvilRecipe;
import snownee.lychee.recipes.AnvilCraftingRecipe;
import snownee.lychee.recipes.ShapedCraftingRecipe;
import snownee.lychee.util.recipe.ILycheeRecipe;

@EmiEntrypoint
public class LycheeEMIPlugin
implements EmiPlugin {
    private final RvPlugin<EmiRvHelper> rvPlugin = new RvPlugin<EmiRvHelper>(EmiRvHelper.INSTANCE);

    public void register(EmiRegistry registry) {
        this.rvPlugin.init();
        for (RvCategoryInstance rvCategoryInstance : this.rvPlugin.categories().values()) {
            RvCategoryAdapter category = new RvCategoryAdapter(rvCategoryInstance);
            registry.addCategory(category);
            for (Ingredient ingredient : rvCategoryInstance.workstations()) {
                registry.addWorkstation(category, EmiIngredient.of((Ingredient)ingredient));
            }
            for (RecipeHolder recipeHolder : rvCategoryInstance.recipes()) {
                registry.addRecipe(new EmiRecipeAdapter(category, recipeHolder));
            }
        }
        for (RecipeHolder recipeHolder : RecipeTypes.ANVIL_CRAFTING.inViewerRecipes()) {
            registry.addRecipe((EmiRecipe)new LycheeEmiAnvilRecipe((RecipeHolder<AnvilCraftingRecipe>)recipeHolder));
        }
        registry.addRecipeDecorator(VanillaEmiRecipeCategories.CRAFTING, (emiRecipe, widgets) -> {
            RecipeHolder recipeHolder = emiRecipe.getBackingRecipe();
            if (recipeHolder == null || !(recipeHolder.value() instanceof ShapedCraftingRecipe)) {
                return;
            }
            LycheeEMIPlugin.addInfoIcon(widgets, recipeHolder, 60, 18);
        });
    }

    public static void addInfoIcon(WidgetHolder widgets, RecipeHolder<? extends ILycheeRecipe<?>> recipe, int x, int y) {
        if (!RvCategory.needInfo((ILycheeRecipe)recipe.value())) {
            return;
        }
        y = Math.max(y - 9, 0);
        widgets.add((Widget)new EmiWidgetAdapter((RenderElement)RvCategory.infoIcon(recipe).at(x += EmiTexture.EMPTY_ARROW.regionWidth / 2 - 4, y)));
    }
}

