/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.action;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.network.SUpdateFallingBlockPacket;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionCommonProperties;
import snownee.lychee.util.action.PostActionType;
import snownee.lychee.util.action.PostActionTypes;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record SetBlock(PostActionCommonProperties commonProperties, BlockPredicate block) implements PostAction
{
    @Override
    public PostActionType<?> type() {
        return PostActionTypes.SET_BLOCK;
    }

    @Override
    public void apply(@Nullable ILycheeRecipe<?> recipe, LycheeContext context, int times) {
        Entity entity = (Entity)context.get(LycheeContextKey.LOOT_PARAMS).getOrNull(LootContextParams.THIS_ENTITY);
        if (entity instanceof FallingBlockEntity) {
            FallingBlockEntity fbe = (FallingBlockEntity)entity;
            fbe.blockState = BlockPredicateExtensions.anyBlockState(this.block);
            if (!fbe.blockState.isAir()) {
                if (fbe.blockData != null || this.block.requiresNbt()) {
                    fbe.blockData = this.block.nbt().map(NbtPredicate::tag).orElse(null);
                }
                new SUpdateFallingBlockPacket(fbe).send(fbe);
            }
        }
    }

    @Override
    public Component getDisplayName() {
        BlockState blockState = BlockPredicateExtensions.anyBlockState(this.block);
        String key = CommonProxy.makeDescriptionId("postAction", LycheeRegistries.POST_ACTION.getKey(this.type()));
        return Component.translatable((String)key, (Object[])new Object[]{blockState.getBlock().getName()});
    }

    @Override
    public List<ItemStack> getOutputItems() {
        return BlockPredicateExtensions.matchedItemStacks(this.block);
    }

    @Override
    public List<BlockPredicate> getOutputBlocks() {
        return BlockPredicateExtensions.isAny(this.block) ? List.of() : List.of(this.block);
    }

    @Override
    public boolean repeatable() {
        return false;
    }

    public static class Type
    implements PostActionType<SetBlock> {
        public static final MapCodec<SetBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PostActionCommonProperties.MAP_CODEC.forGetter(SetBlock::commonProperties), (App)BlockPredicateExtensions.CODEC.optionalFieldOf("block", (Object)BlockPredicateExtensions.ANY).forGetter(SetBlock::block)).apply((Applicative)instance, SetBlock::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, SetBlock> STREAM_CODEC = StreamCodec.composite(PostActionCommonProperties.STREAM_CODEC, SetBlock::commonProperties, (StreamCodec)BlockPredicate.STREAM_CODEC, SetBlock::block, SetBlock::new);

        @Override
        public MapCodec<SetBlock> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, SetBlock> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

