/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.action;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionCommonProperties;
import snownee.lychee.util.action.PostActionType;
import snownee.lychee.util.action.PostActionTypes;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record Move(PostActionCommonProperties commonProperties, Vec3 offset, String with) implements PostAction
{
    public PostActionType<Move> type() {
        return PostActionTypes.MOVE;
    }

    @Override
    public void apply(@Nullable ILycheeRecipe<?> recipe, LycheeContext context, int times) {
        LootParamsContext lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        Vec3 offset = this.offset;
        if (!this.with.isEmpty()) {
            BlockState blockState = (BlockState)lootParams.getOrNull(LootContextParams.BLOCK_STATE);
            if (blockState == null) {
                return;
            }
            Property property = blockState.getBlock().getStateDefinition().getProperty(this.with);
            if (!(property instanceof DirectionProperty)) {
                return;
            }
            DirectionProperty directionProperty = (DirectionProperty)property;
            Direction direction = (Direction)blockState.getValue((Property)directionProperty);
            offset = switch (direction) {
                default -> throw new MatchException(null, null);
                case Direction.DOWN -> offset.xRot((float)Math.PI);
                case Direction.UP -> offset;
                case Direction.NORTH -> offset.xRot(1.5707964f);
                case Direction.SOUTH -> offset.xRot(1.5707964f).yRot((float)Math.PI);
                case Direction.WEST -> offset.xRot(1.5707964f).yRot(1.5707964f);
                case Direction.EAST -> offset.xRot(1.5707964f).yRot(-1.5707964f);
            };
        }
        Vec3 pos = (Vec3)lootParams.get(LootContextParams.ORIGIN);
        lootParams.set(LootContextParams.ORIGIN, pos.add(offset));
    }

    @Override
    public boolean preventSync() {
        return true;
    }

    public static class Type
    implements PostActionType<Move> {
        public static final MapCodec<Move> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)PostActionCommonProperties.MAP_CODEC.forGetter(Move::commonProperties), (App)Vec3.CODEC.fieldOf("offset").forGetter(Move::offset), (App)Codec.STRING.optionalFieldOf("with", (Object)"").forGetter(Move::with)).apply((Applicative)inst, Move::new));

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, Move> streamCodec() {
            throw new UnsupportedOperationException();
        }

        @Override
        public MapCodec<Move> codec() {
            return CODEC;
        }
    }
}

