/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.action;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.ClientProxy;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionCommonProperties;
import snownee.lychee.util.action.PostActionType;
import snownee.lychee.util.action.PostActionTypes;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record DropXp(PostActionCommonProperties commonProperties, int xp) implements PostAction
{
    public PostActionType<DropXp> type() {
        return PostActionTypes.DROP_XP;
    }

    @Override
    public void apply(@Nullable ILycheeRecipe<?> recipe, LycheeContext context, int times) {
        LootParamsContext lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        Vec3 pos = (Vec3)lootParams.get(LootContextParams.ORIGIN);
        ExperienceOrb.award((ServerLevel)((ServerLevel)context.level()), (Vec3)pos, (int)(this.xp * times));
    }

    @Override
    public Component getDisplayName() {
        return ClientProxy.format(CommonProxy.makeDescriptionId("postAction", LycheeRegistries.POST_ACTION.getKey(this.type())), this.xp);
    }

    public static class Type
    implements PostActionType<DropXp> {
        public static final MapCodec<DropXp> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PostActionCommonProperties.MAP_CODEC.forGetter(DropXp::commonProperties), (App)ExtraCodecs.POSITIVE_INT.fieldOf("xp").forGetter(DropXp::xp)).apply((Applicative)instance, DropXp::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, DropXp> STREAM_CODEC = StreamCodec.composite(PostActionCommonProperties.STREAM_CODEC, DropXp::commonProperties, (StreamCodec)ByteBufCodecs.VAR_INT, DropXp::xp, DropXp::new);

        @Override
        public MapCodec<DropXp> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, DropXp> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

