/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.action;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.function.Supplier;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.context.LootParamsContext;
import snownee.lychee.util.action.PostAction;
import snownee.lychee.util.action.PostActionCommonProperties;
import snownee.lychee.util.action.PostActionType;
import snownee.lychee.util.action.PostActionTypes;
import snownee.lychee.util.codec.LycheeCodecs;
import snownee.lychee.util.context.LycheeContext;
import snownee.lychee.util.context.LycheeContextKey;
import snownee.lychee.util.predicates.BlockPredicateExtensions;
import snownee.lychee.util.recipe.ILycheeRecipe;

public record CycleStateProperty(PostActionCommonProperties commonProperties, BlockPredicate block, String propertyName, Supplier<Property<?>> propertySupplier, BlockPos offset, boolean reversed) implements PostAction
{
    public CycleStateProperty(PostActionCommonProperties commonProperties, BlockPredicate block, BlockPos offset, String propertyName, boolean reversed) {
        this(commonProperties, block, propertyName, (Supplier<Property<?>>)Suppliers.memoize(() -> CycleStateProperty.findProperty(block, propertyName)), offset, reversed);
    }

    public static Property<?> findProperty(BlockPredicate blockPredicate, String name) {
        BlockState block = BlockPredicateExtensions.anyBlockState(blockPredicate);
        for (Property property : block.getProperties()) {
            if (!name.equals(property.getName())) continue;
            return property;
        }
        throw new IllegalArgumentException("Unknown property name: " + name);
    }

    public PostActionType<CycleStateProperty> type() {
        return PostActionTypes.CYCLE_STATE_PROPERTY;
    }

    @Override
    public void apply(@Nullable ILycheeRecipe<?> recipe, LycheeContext context, int times) {
        BlockState state;
        LootParamsContext lootParams = context.get(LycheeContextKey.LOOT_PARAMS);
        BlockPos pos = lootParams.get(LycheeLootContextParams.BLOCK_POS).offset((Vec3i)this.offset);
        Level level = context.level();
        BlockState oldState = level.getBlockState(pos);
        BlockState blockState = state = this.reversed ? CycleStateProperty.cycleReversed(oldState, this.property()) : (BlockState)oldState.cycle(this.property());
        if (!level.setBlockAndUpdate(pos, state)) {
            return;
        }
        level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((BlockState)state));
    }

    private static <T extends Comparable<T>> BlockState cycleReversed(BlockState oldState, Property<T> property) {
        Comparable value = oldState.getValue(property);
        Collection values = property.getPossibleValues();
        Comparable last = null;
        for (Comparable v : values) {
            if (last != null && v == value) {
                return (BlockState)oldState.setValue(property, last);
            }
            last = v;
        }
        return last == null ? oldState : (BlockState)oldState.setValue(property, last);
    }

    public Property<?> property() {
        return this.propertySupplier.get();
    }

    public static class Type
    implements PostActionType<CycleStateProperty> {
        public static final MapCodec<CycleStateProperty> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PostActionCommonProperties.MAP_CODEC.forGetter(CycleStateProperty::commonProperties), (App)BlockPredicateExtensions.CODEC.fieldOf("block").forGetter(CycleStateProperty::block), (App)LycheeCodecs.OFFSET.forGetter(CycleStateProperty::offset), (App)ExtraCodecs.NON_EMPTY_STRING.fieldOf("property").forGetter(CycleStateProperty::propertyName), (App)Codec.BOOL.optionalFieldOf("reversed", (Object)false).forGetter(CycleStateProperty::reversed)).apply((Applicative)instance, CycleStateProperty::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, CycleStateProperty> STREAM_CODEC = StreamCodec.composite(PostActionCommonProperties.STREAM_CODEC, CycleStateProperty::commonProperties, (StreamCodec)BlockPredicate.STREAM_CODEC, CycleStateProperty::block, (StreamCodec)BlockPos.STREAM_CODEC, CycleStateProperty::offset, (StreamCodec)ByteBufCodecs.STRING_UTF8, CycleStateProperty::propertyName, (StreamCodec)ByteBufCodecs.BOOL, CycleStateProperty::reversed, CycleStateProperty::new);

        @Override
        public MapCodec<CycleStateProperty> codec() {
            return CODEC;
        }

        @Override
        public StreamCodec<RegistryFriendlyByteBuf, CycleStateProperty> streamCodec() {
            return STREAM_CODEC;
        }
    }
}

