/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.block.KBlockUtils;
import snownee.kiwi.customization.block.behavior.BlockBehaviorRegistry;
import snownee.kiwi.customization.block.component.KBlockComponent;
import snownee.kiwi.customization.block.component.LayeredComponent;
import snownee.kiwi.customization.block.loader.KBlockComponents;

public record CycleVariantsComponent(IntegerProperty property, boolean rightClickToCycle, Optional<String> onPlace) implements KBlockComponent,
LayeredComponent
{
    public static final MapCodec<CycleVariantsComponent> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.POSITIVE_INT.fieldOf("amount").forGetter(CycleVariantsComponent::maxValue), (App)Codec.BOOL.optionalFieldOf("right_click_to_cycle", (Object)true).forGetter(CycleVariantsComponent::rightClickToCycle), (App)ExtraCodecs.NON_EMPTY_STRING.optionalFieldOf("on_place").forGetter(CycleVariantsComponent::onPlace)).apply((Applicative)instance, CycleVariantsComponent::create));

    public static CycleVariantsComponent create(int amount) {
        return CycleVariantsComponent.create(amount, true, Optional.empty());
    }

    public static CycleVariantsComponent create(int amount, boolean rightClickToCycle, Optional<String> onPlace) {
        return new CycleVariantsComponent(KBlockUtils.internProperty(IntegerProperty.create((String)"variant", (int)1, (int)amount)), rightClickToCycle, onPlace);
    }

    @Override
    public KBlockComponent.Type<?> type() {
        return KBlockComponents.CYCLE_VARIANTS.getOrCreate();
    }

    @Override
    public void injectProperties(Block block, StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{this.property});
    }

    @Override
    public BlockState registerDefaultState(BlockState state) {
        return (BlockState)state.setValue((Property)this.property, (Comparable)Integer.valueOf(this.getDefaultLayer()));
    }

    @Override
    public BlockState getStateForPlacement(KBlockSettings settings, BlockState state, BlockPlaceContext context) {
        if (this.onPlace.isPresent() && "randomize".equals(this.onPlace.get())) {
            int randomValue = context.getLevel().random.nextInt(this.maxValue() - this.minValue() + 1) + this.minValue();
            state = (BlockState)state.setValue((Property)this.property, (Comparable)Integer.valueOf(randomValue));
        }
        return state;
    }

    public int minValue() {
        return this.property.min;
    }

    public int maxValue() {
        return this.property.max;
    }

    @Override
    public IntegerProperty getLayerProperty() {
        return this.property;
    }

    @Override
    public int getDefaultLayer() {
        return this.minValue();
    }

    @Override
    public void addBehaviors(BlockBehaviorRegistry registry) {
        if (this.rightClickToCycle) {
            registry.addUseHandler((pState, pPlayer, pLevel, pHand, pHit) -> {
                BlockState newState = (BlockState)pState.cycle((Property)this.property);
                pLevel.setBlock(pHit.getBlockPos(), newState, 3);
                return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
            });
        }
    }
}

