/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.common.blocks.wooden.CraftingTableBlockEntity;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.mixin.accessors.CraftingContainerAccess;
import invtweaks.api.container.ChestContainer;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.ResultContainer;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.SlotItemHandler;

@ChestContainer
public class CraftingTableMenu
extends IEContainerMenu {
    private final CraftingContainer craftingInventory = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 3);
    private final ResultContainer craftResultInventory = new ResultContainer();
    private final Player player;
    private final ContainerLevelAccess access;

    public static CraftingTableMenu makeServer(MenuType<?> type, int id, Inventory invPlayer, CraftingTableBlockEntity be) {
        return new CraftingTableMenu(CraftingTableMenu.blockCtx(type, id, be), invPlayer, be.getCraftingInventory(), Objects.requireNonNull((IItemHandler)be.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, be.getBlockPos(), null)), ContainerLevelAccess.create((Level)be.getLevel(), (BlockPos)be.getBlockPos()));
    }

    public static CraftingTableMenu makeClient(MenuType<?> type, int id, Inventory invPlayer) {
        return new CraftingTableMenu(CraftingTableMenu.clientCtx(type, id), invPlayer, (NonNullList<ItemStack>)NonNullList.withSize((int)9, (Object)ItemStack.EMPTY), (IItemHandler)new ItemStackHandler(18), ContainerLevelAccess.NULL);
    }

    private CraftingTableMenu(IEContainerMenu.MenuContext ctx, Inventory inventoryPlayer, NonNullList<ItemStack> craftingItems, IItemHandler storageInventory, ContainerLevelAccess access) {
        super(ctx);
        int i;
        this.player = inventoryPlayer.player;
        this.access = access;
        ((CraftingContainerAccess)this.craftingInventory).setItems(craftingItems);
        this.addSlot((Slot)new ResultSlot(this.player, this.craftingInventory, (Container)this.craftResultInventory, 0, 124, 35));
        for (int i2 = 0; i2 < 9; ++i2) {
            this.addSlot(new Slot((Container)this.craftingInventory, i2, 30 + i2 % 3 * 18, 17 + i2 / 3 * 18));
        }
        int iSlot = 0;
        for (i = 0; i < 18; ++i) {
            this.addSlot((Slot)new SlotItemHandler(this, storageInventory, iSlot++, 8 + i % 9 * 18, 79 + i / 9 * 18){

                public boolean allowModification(Player player) {
                    return true;
                }
            });
        }
        this.ownSlotCount = storageInventory.getSlots() + craftingItems.size() + 1;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 129 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventoryPlayer, i, 8 + i * 18, 187));
        }
        this.addSlotListener(new ContainerListener(){

            public void slotChanged(@Nonnull AbstractContainerMenu menu, int index, @Nonnull ItemStack stack) {
                CraftingTableMenu.this.slotsChanged(null);
            }

            public void dataChanged(@Nonnull AbstractContainerMenu menu, int index, int value) {
            }
        });
    }

    public void slotsChanged(@Nullable Container inventoryIn) {
        this.access.execute((world, $) -> {
            RecipeHolder icraftingrecipe;
            ServerPlayer serverplayerentity = (ServerPlayer)this.player;
            ItemStack itemstack = ItemStack.EMPTY;
            Optional optional = world.getServer().getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)this.craftingInventory.asCraftInput(), world);
            if (optional.isPresent() && this.craftResultInventory.setRecipeUsed(world, serverplayerentity, icraftingrecipe = (RecipeHolder)optional.get())) {
                itemstack = ((CraftingRecipe)icraftingrecipe.value()).assemble((RecipeInput)this.craftingInventory.asCraftInput(), (HolderLookup.Provider)world.registryAccess());
            }
            this.craftResultInventory.setItem(0, itemstack);
            serverplayerentity.connection.send((Packet)new ClientboundContainerSetSlotPacket(this.containerId, this.incrementStateId(), 0, itemstack));
        });
    }

    @Override
    @Nonnull
    public ItemStack quickMoveStack(Player playerIn, int index) {
        if (index != 0) {
            return super.quickMoveStack(playerIn, index);
        }
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(index);
        if (slot != null && slot.hasItem()) {
            ItemStack itemstack1 = slot.getItem();
            itemstack = itemstack1.copy();
            this.access.execute((world, $) -> itemstack1.getItem().onCraftedBy(itemstack1, world, playerIn));
            if (!this.moveItemStackTo(itemstack1, 10, 46, true)) {
                return ItemStack.EMPTY;
            }
            slot.onQuickCraft(itemstack1, itemstack);
            if (itemstack1.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else {
                slot.setChanged();
            }
            if (itemstack1.getCount() == itemstack.getCount()) {
                return ItemStack.EMPTY;
            }
            slot.onTake(playerIn, itemstack1);
        }
        return itemstack;
    }

    public boolean canTakeItemForPickAll(@Nonnull ItemStack pStack, Slot pSlot) {
        return pSlot.container != this.craftResultInventory && super.canTakeItemForPickAll(pStack, pSlot);
    }
}

