/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.data.skippreds.pane;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import xfacthd.framedblocks.api.predicate.cull.SideSkipPredicate;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.data.BlockType;
import xfacthd.framedblocks.common.data.skippreds.CullTest;

@CullTest(value={BlockType.FRAMED_PANE})
public final class PaneSkipPredicate
implements SideSkipPredicate {
    @Override
    @CullTest.TestTarget(value={BlockType.FRAMED_PANE})
    public boolean test(BlockGetter level, BlockPos pos, BlockState state, BlockState adjState, Direction side) {
        if (adjState.getBlock() != state.getBlock()) {
            return false;
        }
        boolean north = (Boolean)state.getValue((Property)BlockStateProperties.NORTH);
        boolean east = (Boolean)state.getValue((Property)BlockStateProperties.EAST);
        boolean south = (Boolean)state.getValue((Property)BlockStateProperties.SOUTH);
        boolean west = (Boolean)state.getValue((Property)BlockStateProperties.WEST);
        boolean adjNorth = (Boolean)adjState.getValue((Property)BlockStateProperties.NORTH);
        boolean adjEast = (Boolean)adjState.getValue((Property)BlockStateProperties.EAST);
        boolean adjSouth = (Boolean)adjState.getValue((Property)BlockStateProperties.SOUTH);
        boolean adjWest = (Boolean)adjState.getValue((Property)BlockStateProperties.WEST);
        if (Utils.isY(side) && north == adjNorth && east == adjEast && south == adjSouth && west == adjWest) {
            return true;
        }
        return switch (side) {
            case Direction.NORTH -> {
                if (north && adjSouth) {
                    yield true;
                }
                yield false;
            }
            case Direction.EAST -> {
                if (east && adjWest) {
                    yield true;
                }
                yield false;
            }
            case Direction.SOUTH -> {
                if (south && adjNorth) {
                    yield true;
                }
                yield false;
            }
            case Direction.WEST -> {
                if (west && adjEast) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }
}

