/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.crafting;

import com.google.common.base.Preconditions;
import java.util.List;
import net.minecraft.advancements.Criterion;
import net.minecraft.core.Holder;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;
import xfacthd.framedblocks.common.crafting.FramingSawRecipeAdditive;

public final class FramingSawRecipeBuilder
implements RecipeBuilder {
    private final Item result;
    private final int count;
    private int material = 0;
    private List<FramingSawRecipeAdditive> additives = List.of();
    private boolean disabled = false;

    private FramingSawRecipeBuilder(ItemLike result, int count) {
        this.result = result.asItem();
        this.count = count;
    }

    public static <T extends ItemLike> FramingSawRecipeBuilder builder(Holder<T> result) {
        return FramingSawRecipeBuilder.builder((ItemLike)result.value());
    }

    public static FramingSawRecipeBuilder builder(ItemLike result) {
        return FramingSawRecipeBuilder.builder(result, 1);
    }

    public static <T extends ItemLike> FramingSawRecipeBuilder builder(Holder<T> result, int count) {
        return FramingSawRecipeBuilder.builder((ItemLike)result.value(), count);
    }

    public static FramingSawRecipeBuilder builder(ItemLike result, int count) {
        Preconditions.checkNotNull((Object)result, (Object)"Result must be non-null");
        Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"Result count must be greater than 0");
        return new FramingSawRecipeBuilder(result, count);
    }

    public FramingSawRecipeBuilder material(int material) {
        Preconditions.checkArgument((material > 0 ? 1 : 0) != 0, (Object)"Material value must be greater than 0");
        this.material = material;
        return this;
    }

    public FramingSawRecipeBuilder additive(FramingSawRecipeAdditive additive) {
        Preconditions.checkNotNull((Object)additive, (Object)"Additive must be non-null");
        this.additives = List.of(additive);
        return this;
    }

    public FramingSawRecipeBuilder additives(List<FramingSawRecipeAdditive> additives) {
        Preconditions.checkNotNull(additives, (Object)"Additives must be non-null");
        this.additives = additives;
        return this;
    }

    public FramingSawRecipeBuilder disabled() {
        this.disabled = true;
        return this;
    }

    public RecipeBuilder unlockedBy(String criterionName, Criterion<?> criterion) {
        throw new UnsupportedOperationException("Advancements are not supported");
    }

    public RecipeBuilder group(@Nullable String groupName) {
        throw new UnsupportedOperationException("Recipe groups are not supported");
    }

    public Item getResult() {
        return this.result;
    }

    public void save(RecipeOutput output, ResourceLocation recipeId) {
        Preconditions.checkState((this.material > 0 ? 1 : 0) != 0, (Object)"Material value not set");
        Preconditions.checkState((this.material / this.count * this.count == this.material ? 1 : 0) != 0, (Object)"Material value not divisible by result size");
        recipeId = recipeId.withPrefix("framing_saw/");
        FramingSawRecipe recipe = new FramingSawRecipe(this.material, this.additives, new ItemStack((ItemLike)this.result, this.count), this.disabled);
        output.accept(recipeId, (Recipe)recipe, null);
    }
}

