/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.client.screen.widget;

import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public final class BlockPreviewTooltipComponent
implements ClientTooltipComponent {
    private static final int SIZE = 36;
    private static final float CENTER_OFF = 18.0f;
    private static final float Z_OFF = 100.0f;
    private static final float STACK_SCALE = 48.0f;
    private static final Quaternionf ROT_180_ZP = Axis.ZP.rotationDegrees(180.0f);
    private static final Quaternionf ROT_22_5_XN = Axis.XN.rotationDegrees(22.5f);
    private final ItemStack stack;

    public BlockPreviewTooltipComponent(Component component) {
        this.stack = component.stack;
    }

    public void renderImage(Font font, int x, int y, GuiGraphics graphics) {
        graphics.pose().pushPose();
        graphics.pose().translate((float)x + 18.0f, (float)y + 18.0f, 100.0f);
        graphics.pose().scale(48.0f, 48.0f, -48.0f);
        long rotY = System.currentTimeMillis() / 20L % 360L;
        graphics.pose().mulPose(new Matrix4f().rotate((Quaternionfc)ROT_180_ZP).rotate((Quaternionfc)ROT_22_5_XN).rotate((Quaternionfc)Axis.YP.rotationDegrees((float)rotY)));
        Minecraft.getInstance().getItemRenderer().renderStatic(this.stack, ItemDisplayContext.FIXED, 0xF000F0, OverlayTexture.NO_OVERLAY, graphics.pose(), (MultiBufferSource)graphics.bufferSource(), null, 0);
        graphics.pose().popPose();
    }

    public int getWidth(Font font) {
        return 36;
    }

    public int getHeight() {
        return 36;
    }

    public record Component(ItemStack stack) implements TooltipComponent
    {
    }
}

